/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class IncrExecutor
extends StringExecutor {
    private final String ERROR_VALUE_NOT_USABLE = "The value at this key cannot be incremented numerically";
    private final String ERROR_OVERFLOW = "This incrementation cannot be performed due to overflow";
    private final int INIT_VALUE_INT = 1;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long value;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the INCR command is \"INCR key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper valueWrapper = (ByteArrayWrapper)r.get((Object)key);
        if (valueWrapper == null) {
            byte[] newValue = new byte[]{49};
            r.put((Object)key, (Object)new ByteArrayWrapper(newValue));
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
            return;
        }
        String stringValue = valueWrapper.toString();
        try {
            value = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this key cannot be incremented numerically"));
            return;
        }
        if (value == Long.MAX_VALUE) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This incrementation cannot be performed due to overflow"));
            return;
        }
        stringValue = "" + ++value;
        r.put((Object)key, (Object)new ByteArrayWrapper(Coder.stringToBytes(stringValue)));
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

