/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZRangeByScoreExecutor
extends SortedSetExecutor
implements Extendable {
    private final String ERROR_NOT_NUMERIC = "The number provided is not numeric";
    private final String ERROR_LIMIT = "The offset and count cannot be negative";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Collection<?> list;
        double stop;
        double start;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        boolean withScores = false;
        byte[] elem4Array = null;
        int offset = 0;
        int limit = -1;
        if (commandElems.size() >= 5) {
            elem4Array = commandElems.get(4);
            String elem4 = Coder.bytesToString(elem4Array);
            int limitIndex = 4;
            if (elem4.equalsIgnoreCase("WITHSCORES")) {
                withScores = true;
                ++limitIndex;
            }
            if (commandElems.size() >= limitIndex + 2) {
                byte[] lastElemArray;
                String lastString;
                String limitString = Coder.bytesToString(commandElems.get(limitIndex));
                if (limitString.equalsIgnoreCase("LIMIT")) {
                    try {
                        byte[] offsetArray = commandElems.get(limitIndex + 1);
                        byte[] limitArray = commandElems.get(limitIndex + 2);
                        offset = Coder.bytesToInt(offsetArray);
                        limit = Coder.bytesToInt(limitArray);
                    }
                    catch (NumberFormatException e) {
                        command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number provided is not numeric"));
                        return;
                    }
                }
                if (offset < 0 || limit < 0) {
                    command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The offset and count cannot be negative"));
                    return;
                }
                if (limitIndex == 4 && commandElems.size() >= 8 && (lastString = Coder.bytesToString(lastElemArray = commandElems.get(7))).equalsIgnoreCase("WITHSCORES")) {
                    withScores = true;
                }
            }
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        int startIndex = this.isReverse() ? 3 : 2;
        int stopIndex = this.isReverse() ? 2 : 3;
        boolean startInclusive = true;
        boolean stopInclusive = true;
        byte[] startArray = commandElems.get(startIndex);
        byte[] stopArray = commandElems.get(stopIndex);
        String startString = Coder.bytesToString(startArray);
        String stopString = Coder.bytesToString(stopArray);
        if (startArray[0] == 40) {
            startString = startString.substring(1);
            startInclusive = false;
        }
        if (stopArray[0] == 40) {
            stopString = stopString.substring(1);
            stopInclusive = false;
        }
        try {
            start = Coder.stringToDouble(startString);
            stop = Coder.stringToDouble(stopString);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number provided is not numeric"));
            return;
        }
        try {
            list = this.getKeys(key, keyRegion, context, start, stop, startInclusive, stopInclusive, offset, limit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (list == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(Coder.zRangeResponse(context.getByteBufAllocator(), list, withScores));
        }
    }

    private Collection<?> getKeys(ByteArrayWrapper key, Region<ByteArrayWrapper, DoubleWrapper> keyRegion, ExecutionHandlerContext context, double start, double stop, boolean startInclusive, boolean stopInclusive, int offset, int limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults results;
        Object[] params;
        Query query;
        if (start == Double.POSITIVE_INFINITY || stop == Double.NEGATIVE_INFINITY || start > stop || start == stop && (!startInclusive || !stopInclusive)) {
            return null;
        }
        if (start == Double.NEGATIVE_INFINITY && stop == Double.POSITIVE_INFINITY) {
            return new HashSet(keyRegion.entrySet());
        }
        if (this.isReverse()) {
            query = startInclusive ? (stopInclusive ? this.getQuery(key, SortedSetQuery.ZREVRBSSTISI, context) : this.getQuery(key, SortedSetQuery.ZREVRBSSTI, context)) : (stopInclusive ? this.getQuery(key, SortedSetQuery.ZREVRBSSI, context) : this.getQuery(key, SortedSetQuery.ZREVRBS, context));
            params = new Object[]{start, stop, INFINITY_LIMIT};
        } else {
            query = startInclusive ? (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRBSSTISI, context) : this.getQuery(key, SortedSetQuery.ZRBSSTI, context)) : (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRBSSI, context) : this.getQuery(key, SortedSetQuery.ZRBS, context));
            params = new Object[]{start, stop, INFINITY_LIMIT};
        }
        if (limit > 0) {
            params[params.length - 1] = limit + offset;
        }
        if (offset < (results = (SelectResults)query.execute(params)).size()) {
            return results.asList().subList(offset, results.size());
        }
        return null;
    }

    protected boolean isReverse() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the ZRANGEBYSCORE command is \"ZRANGEBYSCORE key min max [WITHSCORES] [LIMIT offset count]\"";
    }
}

