/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.HashMap;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SAddExecutor
extends SetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SADD command is \"SADD key member [member ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<?, ?> keyRegion = context.getRegionProvider().getOrCreateRegion(key, RedisDataType.REDIS_SET, context);
        if (commandElems.size() >= 4) {
            HashMap<ByteArrayWrapper, Boolean> entries = new HashMap<ByteArrayWrapper, Boolean>();
            for (int i = 2; i < commandElems.size(); ++i) {
                entries.put(new ByteArrayWrapper(commandElems.get(i)), true);
            }
            keyRegion.putAll(entries);
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), entries.size()));
        } else {
            Object v = keyRegion.put((Object)new ByteArrayWrapper(commandElems.get(2)), (Object)true);
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), v == null ? 1 : 0));
        }
    }
}

