/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HIncrByFloatExecutor
extends HashExecutor {
    private final String ERROR_FIELD_NOT_USABLE = "The value at this field cannot be incremented numerically because it is not a float";
    private final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be floating point numeric";
    private final int FIELD_INDEX = 2;
    private final int INCREMENT_INDEX = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        double value;
        double increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HINCRBYFLOAT command is \"HINCRBYFLOAT key field increment\""));
            return;
        }
        byte[] incrArray = commandElems.get(3);
        try {
            increment = Coder.bytesToDouble(incrArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The increment on this key must be floating point numeric"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_HASH);
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        ByteArrayWrapper oldValue = (ByteArrayWrapper)keyRegion.get((Object)field);
        if (oldValue == null) {
            keyRegion.put((Object)field, (Object)new ByteArrayWrapper(incrArray));
            this.respondBulkStrings(command, context, increment);
            return;
        }
        String valueS = oldValue.toString();
        if (valueS.contains(" ")) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this field cannot be incremented numerically because it is not a float"));
            return;
        }
        try {
            value = Coder.stringToDouble(valueS);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this field cannot be incremented numerically because it is not a float"));
            return;
        }
        keyRegion.put((Object)field, (Object)new ByteArrayWrapper(Coder.doubleToBytes(value += increment)));
        this.respondBulkStrings(command, context, value);
    }
}

