/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RedisDataTypeMismatchException;

public class KeyRegistrar {
    private Region<String, RedisDataType> redisMetaRegion;

    public KeyRegistrar(Region<String, RedisDataType> redisMetaRegion) {
        this.redisMetaRegion = redisMetaRegion;
    }

    public void register(ByteArrayWrapper key, RedisDataType type) {
        RedisDataType existingType = (RedisDataType)((Object)this.redisMetaRegion.putIfAbsent((Object)key.toString(), (Object)type));
        if (!this.isValidDataType(existingType, type)) {
            this.throwDataTypeException(key, existingType);
        }
    }

    public boolean unregister(ByteArrayWrapper key) {
        return this.redisMetaRegion.remove((Object)key.toString()) != null;
    }

    public boolean isRegistered(ByteArrayWrapper key) {
        return this.redisMetaRegion.containsKey((Object)key.toString());
    }

    public Set<String> keys() {
        Set keysWithProtected = this.redisMetaRegion.keySet();
        return keysWithProtected;
    }

    public Set<Map.Entry<String, RedisDataType>> keyInfos() {
        return this.redisMetaRegion.entrySet();
    }

    public int numKeys() {
        return this.redisMetaRegion.size() - 3;
    }

    public RedisDataType getType(ByteArrayWrapper key) {
        return (RedisDataType)((Object)this.redisMetaRegion.get((Object)key.toString()));
    }

    public void validate(ByteArrayWrapper key, RedisDataType type) {
        RedisDataType currentType = (RedisDataType)((Object)this.redisMetaRegion.get((Object)key.toString()));
        if (!this.isValidDataType(currentType, type)) {
            this.throwDataTypeException(key, currentType);
        }
    }

    private boolean isValidDataType(RedisDataType actualDataType, RedisDataType expectedDataType) {
        return this.isKeyUnused(actualDataType) || actualDataType == expectedDataType;
    }

    private boolean isKeyUnused(RedisDataType dataType) {
        return dataType == null;
    }

    private void throwDataTypeException(ByteArrayWrapper key, RedisDataType dataType) {
        if (dataType == RedisDataType.REDIS_PROTECTED) {
            throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is protected");
        }
        throw new RedisDataTypeMismatchException("The key name \"" + key + "\" is already used by a " + dataType.toString());
    }
}

