/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.wan.GatewayReceiverStats;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.beans.ServerBridge;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class GatewayReceiverMBeanBridge
extends ServerBridge {
    private final GatewayReceiver gatewayReceiver;
    private StatsRate createRequestRate;
    private StatsRate updateRequestRate;
    private StatsRate destroyRequestRate;
    private StatsRate eventsReceivedRate;

    @VisibleForTesting
    public GatewayReceiverMBeanBridge(GatewayReceiver gatewayReceiver) {
        this.gatewayReceiver = gatewayReceiver;
        this.initializeReceiverStats();
    }

    @Override
    public int getClientConnectionCount() {
        return !this.isRunning() ? 0 : this.getReceiverServer().getAcceptor().getClientServerConnectionCount();
    }

    @Override
    public void stopMonitor() {
        this.monitor.stopListener();
    }

    public void addGatewayReceiverStats(GatewayReceiverStats stats) {
        this.monitor.addStatisticsToMonitor(stats.getStats());
    }

    public String getBindAddress() {
        return this.gatewayReceiver.getBindAddress();
    }

    public int getPort() {
        return this.gatewayReceiver.getPort();
    }

    public int getSocketBufferSize() {
        return this.gatewayReceiver.getSocketBufferSize();
    }

    public boolean isRunning() {
        return this.gatewayReceiver.isRunning();
    }

    public void start() throws Exception {
        try {
            this.gatewayReceiver.start();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public void stop() throws Exception {
        try {
            this.gatewayReceiver.stop();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public int getEndPort() {
        return this.gatewayReceiver.getEndPort();
    }

    public String[] getGatewayTransportFilters() {
        List<GatewayTransportFilter> transportFilters = this.gatewayReceiver.getGatewayTransportFilters();
        String[] transportFiltersStringArray = null;
        if (transportFilters == null || transportFilters.isEmpty()) {
            return transportFiltersStringArray;
        }
        transportFiltersStringArray = new String[transportFilters.size()];
        int j = 0;
        for (GatewayTransportFilter filter : transportFilters) {
            transportFiltersStringArray[j] = filter.toString();
            ++j;
        }
        return transportFiltersStringArray;
    }

    public int getStartPort() {
        return this.gatewayReceiver.getStartPort();
    }

    public int getMaximumTimeBetweenPings() {
        return this.gatewayReceiver.getMaximumTimeBetweenPings();
    }

    public float getCreateRequestsRate() {
        return this.createRequestRate.getRate();
    }

    public float getDestroyRequestsRate() {
        return this.destroyRequestRate.getRate();
    }

    public int getDuplicateBatchesReceived() {
        return this.getStatistic("duplicateBatchesReceived").intValue();
    }

    public int getOutoforderBatchesReceived() {
        return this.getStatistic("outoforderBatchesReceived").intValue();
    }

    public float getUpdateRequestsRate() {
        return this.updateRequestRate.getRate();
    }

    public float getEventsReceivedRate() {
        return this.eventsReceivedRate.getRate();
    }

    protected void startServer() {
        this.addServer(this.getReceiverServer());
    }

    protected void stopServer() {
        this.removeServer();
    }

    void destroyServer() {
        this.removeServer();
    }

    public String[] getConnectedGatewaySenders() {
        Acceptor acceptor = this.getReceiverServer().getAcceptor();
        Set<ServerConnection> serverConnections = acceptor.getAllServerConnections();
        if (serverConnections == null || serverConnections.isEmpty()) {
            return new String[0];
        }
        return (String[])serverConnections.stream().map(ServerConnection::getMembershipID).toArray(String[]::new);
    }

    long getAverageBatchProcessingTime() {
        if (this.getStatistic("processBatchRequests").longValue() != 0L) {
            long processTimeInNano = this.getStatistic("processBatchTime").longValue() / this.getStatistic("processBatchRequests").longValue();
            return ManagementConstants.nanoSeconds.toMillis(processTimeInNano);
        }
        return 0L;
    }

    private void initializeReceiverStats() {
        this.createRequestRate = new StatsRate("createRequests", StatType.INT_TYPE, this.monitor);
        this.updateRequestRate = new StatsRate("updateRequest", StatType.INT_TYPE, this.monitor);
        this.destroyRequestRate = new StatsRate("destroyRequest", StatType.INT_TYPE, this.monitor);
        this.eventsReceivedRate = new StatsRate("eventsReceived", StatType.INT_TYPE, this.monitor);
    }

    private InternalCacheServer getReceiverServer() {
        return (InternalCacheServer)this.gatewayReceiver.getServer();
    }
}

