/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.DiskBackupStatus;

public class DiskBackupStatusImpl
implements DiskBackupStatus {
    private Map<String, String[]> backedUpDiskStores;
    private String[] offlineDiskStores;

    @Override
    public Map<String, String[]> getBackedUpDiskStores() {
        return this.backedUpDiskStores;
    }

    @Override
    public String[] getOfflineDiskStores() {
        return this.offlineDiskStores;
    }

    public void setBackedUpDiskStores(Map<String, String[]> backedUpDiskStores) {
        this.backedUpDiskStores = backedUpDiskStores;
    }

    public void setOfflineDiskStores(String[] offLineDiskStores) {
        this.offlineDiskStores = offLineDiskStores;
    }

    public void generateBackedUpDiskStores(Map<DistributedMember, Set<PersistentID>> backedUpDiskStores) {
        HashMap<String, String[]> diskStores = new HashMap<String, String[]>();
        backedUpDiskStores.entrySet().forEach(entry -> {
            DistributedMember member = (DistributedMember)entry.getKey();
            Set ids = (Set)entry.getValue();
            String[] setOfDiskStr = new String[ids.size()];
            ((Set)entry.getValue()).stream().map(id -> id.getDirectory()).collect(Collectors.toList()).toArray(setOfDiskStr);
            diskStores.put(member.getId(), setOfDiskStr);
        });
        this.setBackedUpDiskStores(diskStores);
    }

    public void generateOfflineDiskStores(Set<PersistentID> offLineDiskStores) {
        String[] diskStores = new String[offLineDiskStores.size()];
        offLineDiskStores.stream().map(id -> id.getDirectory()).collect(Collectors.toList()).toArray(diskStores);
        this.setOfflineDiskStores(diskStores);
    }
}

