/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.io.NotSerializableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.IncompatibleSystemException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SystemConnectException;
import org.apache.geode.SystemFailure;
import org.apache.geode.ToDataException;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.alerting.internal.api.AlertingService;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.AdminMessageType;
import org.apache.geode.distributed.internal.ClusterElderManager;
import org.apache.geode.distributed.internal.ClusterOperationExecutors;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.Distribution;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionImpl;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionMessageObserver;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.HealthMonitor;
import org.apache.geode.distributed.internal.HealthMonitorImpl;
import org.apache.geode.distributed.internal.HighPriorityAckedMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.MembershipTestHook;
import org.apache.geode.distributed.internal.OperationExecutors;
import org.apache.geode.distributed.internal.ShutdownMessage;
import org.apache.geode.distributed.internal.StartupMessage;
import org.apache.geode.distributed.internal.StartupOperation;
import org.apache.geode.distributed.internal.locks.ElderState;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.api.MemberData;
import org.apache.geode.distributed.internal.membership.api.MemberDisconnectedException;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifierFactory;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipView;
import org.apache.geode.distributed.internal.membership.api.Message;
import org.apache.geode.distributed.internal.membership.api.MessageListener;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.admin.remote.AdminConsoleDisconnectMessage;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.sequencelog.MembershipLogger;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.tcp.ReenteredConnectException;
import org.apache.geode.logging.internal.OSProcess;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.executors.LoggingUncaughtExceptionHandler;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClusterDistributionManager
implements DistributionManager {
    private static final Logger logger = LogService.getLogger();
    private static final boolean DEBUG_NO_ACKNOWLEDGEMENTS = Boolean.getBoolean("DistributionManager.DEBUG_NO_ACKNOWLEDGEMENTS");
    private static final int MAX_STOP_ATTEMPTS = 10;
    private static final boolean SYNC_EVENTS = Boolean.getBoolean("DistributionManager.syncEvents");
    public static final int NORMAL_DM_TYPE = 10;
    public static final int LOCATOR_DM_TYPE = 11;
    public static final int ADMIN_ONLY_DM_TYPE = 12;
    public static final int LONER_DM_TYPE = 13;
    @MakeNotStatic
    private static volatile boolean isDedicatedAdminVM = false;
    @MakeNotStatic
    private static final ThreadLocal<Boolean> isStartupThread = new ThreadLocal();
    private final Stopper stopper = new Stopper(this);
    private final InternalDistributedMember localAddress;
    private final int dmType;
    private final ConcurrentMap<MembershipListener, Boolean> membershipListeners;
    private final ClusterElderManager clusterElderManager = new ClusterElderManager(this);
    private Distribution distribution;
    private ClusterOperationExecutors executors;
    private List<MembershipTestHook> membershipTestHooks;
    private volatile Set<MembershipListener> allMembershipListeners = Collections.emptySet();
    private final Object allMembershipListenersLock = new Object();
    private final BlockingQueue<MemberEvent> membershipEventQueue = new LinkedBlockingQueue<MemberEvent>();
    private Thread memberEventThread;
    protected final String description;
    protected final DistributionStats stats;
    private boolean exceptionInThreads;
    private volatile boolean shutdownMsgSent = false;
    private volatile boolean closeInProgress = false;
    private volatile boolean receivedStartupResponse = false;
    private volatile String rejectionMessage = null;
    private Map<InternalDistributedMember, Collection<String>> hostedLocatorsAll = Collections.emptyMap();
    private Map<InternalDistributedMember, Collection<String>> hostedLocatorsWithSharedConfiguration = Collections.emptyMap();
    private volatile boolean readyForMessages = false;
    private volatile boolean readyToSendMsgs = false;
    private final Object readyToSendMsgsLock = new Object();
    private volatile boolean closed = false;
    private InternalDistributedSystem system;
    private RemoteTransportConfig transport;
    private volatile RemoteGfManagerAgent agent;
    private final Semaphore parallelGIIs = new Semaphore(InitialImageOperation.MAX_PARALLEL_GIIS);
    private final HashMap<InetAddress, Set<InetAddress>> equivalentHosts = new HashMap();
    private int distributedSystemId;
    private final Map<InternalDistributedMember, String> redundancyZones = Collections.synchronizedMap(new HashMap());
    private boolean enforceUniqueZone = false;
    private volatile Throwable rootCause = null;
    private final Object shutdownMutex = new Object();
    private final AlertingService alertingService;
    private Object membersLock = new Object();
    private volatile boolean shutdownInProgress = false;
    private final Object membershipViewIdGuard = new Object();
    private long membershipViewIdAcknowledged;
    private Set<InternalDistributedMember> unfinishedStartups = null;
    private final Object unfinishedStartupsLock = new Object();
    private final ConcurrentMap<InternalDistributedMember, HealthMonitor> hmMap = new ConcurrentHashMap<InternalDistributedMember, HealthMonitor>();
    private volatile InternalCache cache;

    static ClusterDistributionManager create(InternalDistributedSystem system, MembershipLocator<InternalDistributedMember> membershipLocator) {
        ClusterDistributionManager distributionManager = null;
        boolean beforeJoined = true;
        try {
            int vmKind = Boolean.getBoolean("Locator.forceLocatorDMType") ? 11 : (ClusterDistributionManager.isDedicatedAdminVM() ? 12 : 10);
            RemoteTransportConfig transport = new RemoteTransportConfig(system.getConfig(), vmKind);
            transport.setIsReconnectingDS(system.isReconnectingDS());
            transport.setOldDSMembershipInfo(system.oldDSMembershipInfo());
            long start = System.currentTimeMillis();
            distributionManager = new ClusterDistributionManager(system, transport, (AlertingService)system.getAlertingService(), membershipLocator);
            distributionManager.assertDistributionManagerType();
            beforeJoined = false;
            InternalDistributedMember id = distributionManager.getDistributionManagerId();
            if (!"".equals(id.getName())) {
                for (InternalDistributedMember m : distributionManager.getViewMembers()) {
                    if (m.equals(id)) break;
                    if (!id.getName().equals(m.getName()) || !distributionManager.getDistribution().verifyMember(m, "member is using the name of " + id)) continue;
                    throw new IncompatibleSystemException("Member " + id + " could not join this distributed system because the existing member " + m + " used the same name. Set the \"name\" gemfire property to a unique value.");
                }
            }
            distributionManager.addNewMember(id);
            StartupOperation op = new StartupOperation(distributionManager, transport);
            try {
                if (!distributionManager.sendStartupMessage(op)) {
                    if (distributionManager.getOtherDistributionManagerIds().size() == 0) {
                        logger.info("Did not hear back from any other system. I am the first one.");
                    } else if (transport.isMcastEnabled() && !distributionManager.testMulticast()) {
                        logger.warn("Did not receive a startup response but other members exist.  Multicast does not seem to be working.");
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new InternalGemFireException("Interrupted while waiting for first StartupResponseMessage", ex);
            }
            catch (IncompatibleSystemException ex) {
                logger.fatal(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            finally {
                distributionManager.readyToSendMsgs();
            }
            if (logger.isInfoEnabled()) {
                long delta = System.currentTimeMillis() - start;
                logger.info(LogMarker.DM_MARKER, "DistributionManager {} started on {}. There were {} other DMs. others: {} {} {}", (Object)distributionManager.getDistributionManagerId(), (Object)transport, (Object)distributionManager.getOtherDistributionManagerIds().size(), distributionManager.getOtherDistributionManagerIds(), (Object)(logger.isInfoEnabled(LogMarker.DM_MARKER) ? " (took " + delta + " ms)" : ""), (Object)(distributionManager.getDMType() == 12 ? " (admin only)" : (distributionManager.getDMType() == 11 ? " (locator)" : "")));
                MembershipLogger.logStartup(distributionManager.getDistributionManagerId());
            }
            return distributionManager;
        }
        catch (RuntimeException r) {
            if (distributionManager != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cleaning up incompletely started DistributionManager due to exception", (Throwable)r);
                }
                super.uncleanShutdown(beforeJoined);
            }
            throw r;
        }
    }

    @Override
    public OperationExecutors getExecutors() {
        return this.executors;
    }

    @Override
    public ThreadsMonitoring getThreadMonitoring() {
        return this.executors.getThreadMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterDistributionManager(RemoteTransportConfig transport, InternalDistributedSystem system, AlertingService alertingService, MembershipLocator<InternalDistributedMember> locator) {
        this.system = system;
        this.transport = transport;
        this.alertingService = alertingService;
        this.dmType = transport.getVmKind();
        this.membershipListeners = new ConcurrentHashMap<MembershipListener, Boolean>();
        this.distributedSystemId = system.getConfig().getDistributedSystemId();
        long statId = OSProcess.getId();
        this.stats = new DistributionStats(system, statId);
        DistributionStats.enableClockStats = system.getConfig().getEnableTimeStatistics();
        this.exceptionInThreads = false;
        boolean finishedConstructor = false;
        try {
            this.executors = new ClusterOperationExecutors(this.stats, system);
            if (!SYNC_EVENTS) {
                this.memberEventThread = new LoggingThread("DM-MemberEventInvoker", (Runnable)new MemberEventInvoker());
            }
            StringBuilder sb = new StringBuilder(" (took ");
            long start = System.currentTimeMillis();
            DMListener listener = new DMListener(this);
            this.distribution = DistributionImpl.createDistribution(this, transport, system, listener, (MessageListener<InternalDistributedMember>)((MessageListener)this::handleIncomingDMsg), locator);
            sb.append(System.currentTimeMillis() - start);
            this.localAddress = this.distribution.getLocalMember();
            sb.append(" ms)");
            logger.info("Starting DistributionManager {}. {}", new Object[]{this.localAddress, logger.isInfoEnabled(LogMarker.DM_MARKER) ? sb.toString() : ""});
            this.description = "Distribution manager on " + this.localAddress + " started at " + new Date(System.currentTimeMillis()).toString();
            finishedConstructor = true;
        }
        finally {
            if (!finishedConstructor && this.executors != null) {
                this.askThreadsToStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterDistributionManager(InternalDistributedSystem system, RemoteTransportConfig transport, AlertingService alertingService, MembershipLocator<InternalDistributedMember> membershipLocator) {
        this(transport, system, alertingService, membershipLocator);
        boolean finishedConstructor = false;
        try {
            ClusterDistributionManager.setIsStartupThread();
            this.startThreads();
            this.distribution.startEventProcessing();
            while (true) {
                this.getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.distribution.waitForEventProcessing();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            finishedConstructor = true;
        }
        finally {
            if (!finishedConstructor) {
                this.askThreadsToStop();
            }
        }
    }

    public static boolean isDedicatedAdminVM() {
        return isDedicatedAdminVM;
    }

    public static void setIsDedicatedAdminVM(boolean isDedicatedAdminVM) {
        ClusterDistributionManager.isDedicatedAdminVM = isDedicatedAdminVM;
    }

    private static Boolean isStartupThread() {
        return isStartupThread.get();
    }

    private static void setIsStartupThread() {
        isStartupThread.set(Boolean.TRUE);
    }

    @Override
    public boolean areOnEquivalentHost(InternalDistributedMember member1, InternalDistributedMember member2) {
        Set<InetAddress> equivalents1 = this.getEquivalents(member1.getInetAddress());
        return equivalents1.contains(member2.getInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEquivalentHosts(Set<InetAddress> equivs) {
        Iterator<InetAddress> it = equivs.iterator();
        HashMap<InetAddress, Set<InetAddress>> hashMap = this.equivalentHosts;
        synchronized (hashMap) {
            while (it.hasNext()) {
                this.equivalentHosts.put(it.next(), Collections.unmodifiableSet(equivs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InetAddress> getEquivalents(InetAddress in) {
        Set<InetAddress> result;
        HashMap<InetAddress, Set<InetAddress>> hashMap = this.equivalentHosts;
        synchronized (hashMap) {
            result = this.equivalentHosts.get(in);
        }
        if (result == null) {
            result = Collections.singleton(in);
        }
        return result;
    }

    void setRedundancyZone(InternalDistributedMember member, String redundancyZone) {
        if (redundancyZone != null && !redundancyZone.equals("")) {
            this.redundancyZones.put(member, redundancyZone);
        }
        if (member != this.getDistributionManagerId()) {
            String relationship = this.areInSameZone(this.getDistributionManagerId(), member) ? "" : "not ";
            Object[] logArgs = new Object[]{member, relationship};
            logger.info("Member {} is {} equivalent or in the same redundancy zone.", logArgs);
        }
    }

    void setEnforceUniqueZone(boolean enforceUniqueZone) {
        this.enforceUniqueZone |= enforceUniqueZone;
    }

    @Override
    public boolean enforceUniqueZone() {
        return this.enforceUniqueZone;
    }

    public String getRedundancyZone(InternalDistributedMember member) {
        return this.redundancyZones.get(member);
    }

    private void assertDistributionManagerType() {
        int theDmType = this.getDMType();
        switch (theDmType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                Assert.assertTrue(false, "unknown distribution manager type");
            }
        }
        InternalDistributedMember theId = this.getDistributionManagerId();
        int vmKind = theId.getVmKind();
        if (theDmType != vmKind) {
            Assert.assertTrue(false, "InternalDistributedMember has a vmKind of " + vmKind + " instead of " + theDmType);
        }
    }

    @Override
    public int getDMType() {
        return this.dmType;
    }

    @Override
    public List<InternalDistributedMember> getViewMembers() {
        return this.distribution.getView().getMembers();
    }

    private boolean testMulticast() {
        return this.distribution.testMulticast();
    }

    private void startThreads() {
        this.system.setDM(this);
        if (this.memberEventThread != null) {
            this.memberEventThread.start();
        }
        try {
            MembershipView<InternalDistributedMember> v = this.distribution.getView();
            logger.info("Initial (distribution manager) view, {}", (Object)String.valueOf(v));
            for (InternalDistributedMember internalDistributedMember : v.getMembers()) {
                this.addNewMember(internalDistributedMember);
            }
        }
        catch (Exception ex) {
            throw new InternalGemFireException("Could not process initial view", ex);
        }
        try {
            this.executors.getWaitingThreadPool().execute(() -> {
                ClusterDistributionManager.setIsStartupThread();
                this.readyForMessages();
            });
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.fatal("Uncaught exception calling readyForMessages", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyForMessages() {
        ClusterDistributionManager clusterDistributionManager = this;
        synchronized (clusterDistributionManager) {
            this.readyForMessages = true;
            this.notifyAll();
        }
        this.distribution.startEventProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilReadyForMessages() {
        if (this.readyForMessages) {
            return;
        }
        ClusterDistributionManager clusterDistributionManager = this;
        synchronized (clusterDistributionManager) {
            while (!this.readyForMessages) {
                this.stopper.checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.stopper.checkCancelInProgress(e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyToSendMsgs() {
        Object object = this.readyToSendMsgsLock;
        synchronized (object) {
            this.readyToSendMsgs = true;
            this.readyToSendMsgsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilReadyToSendMsgs(DistributionMessage msg) {
        if (this.readyToSendMsgs) {
            return;
        }
        if (msg instanceof AdminMessageType) {
            return;
        }
        if (ClusterDistributionManager.isStartupThread() == Boolean.TRUE) {
            return;
        }
        Object object = this.readyToSendMsgsLock;
        synchronized (object) {
            while (!this.readyToSendMsgs) {
                this.stopper.checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.readyToSendMsgsLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.stopper.checkCancelInProgress(e);
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
    }

    @Override
    public void forceUDPMessagingForCurrentThread() {
        this.distribution.forceUDPMessagingForCurrentThread();
    }

    @Override
    public void releaseUDPMessagingForCurrentThread() {
        this.distribution.releaseUDPMessagingForCurrentThread();
    }

    @Override
    public boolean exceptionInThreads() {
        return this.exceptionInThreads || LoggingUncaughtExceptionHandler.getUncaughtExceptionsCount() > 0;
    }

    @Override
    public void clearExceptionInThreads() {
        this.exceptionInThreads = false;
        LoggingUncaughtExceptionHandler.clearUncaughtExceptionsCount();
    }

    @Override
    public long cacheTimeMillis() {
        return this.system.getClock().cacheTimeMillis();
    }

    @Override
    public DistributedMember getMemberWithName(String name) {
        for (DistributedMember distributedMember : this.getViewMembers()) {
            if (!Objects.equals(distributedMember.getName(), name)) continue;
            return distributedMember;
        }
        if (Objects.equals(this.localAddress.getName(), name)) {
            return this.localAddress;
        }
        return null;
    }

    @Override
    public InternalDistributedMember getDistributionManagerId() {
        return this.localAddress;
    }

    @Override
    public Set<InternalDistributedMember> getDistributionManagerIds() {
        return this.distribution.getMembersNotShuttingDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHostedLocators(InternalDistributedMember member, Collection<String> locators, boolean isSharedConfigurationEnabled) {
        Object object = this.membersLock;
        synchronized (object) {
            if (locators == null || locators.isEmpty()) {
                throw new IllegalArgumentException("Cannot use empty collection of locators");
            }
            if (this.hostedLocatorsAll.isEmpty()) {
                this.hostedLocatorsAll = new HashMap<InternalDistributedMember, Collection<String>>();
            }
            Map<InternalDistributedMember, Collection<String>> tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsAll);
            tmp.remove(member);
            tmp.put(member, locators);
            tmp = Collections.unmodifiableMap(tmp);
            this.hostedLocatorsAll = tmp;
            if (isSharedConfigurationEnabled) {
                if (this.hostedLocatorsWithSharedConfiguration.isEmpty()) {
                    this.hostedLocatorsWithSharedConfiguration = new HashMap<InternalDistributedMember, Collection<String>>();
                }
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsWithSharedConfiguration);
                tmp.remove(member);
                tmp.put(member, locators);
                tmp = Collections.unmodifiableMap(tmp);
                this.hostedLocatorsWithSharedConfiguration = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHostedLocators(InternalDistributedMember member) {
        Object object = this.membersLock;
        synchronized (object) {
            Map<InternalDistributedMember, Collection<String>> tmp;
            if (this.hostedLocatorsAll.containsKey(member)) {
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsAll);
                tmp.remove(member);
                tmp = tmp.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tmp);
                this.hostedLocatorsAll = tmp;
            }
            if (this.hostedLocatorsWithSharedConfiguration.containsKey(member)) {
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsWithSharedConfiguration);
                tmp.remove(member);
                tmp = tmp.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tmp);
                this.hostedLocatorsWithSharedConfiguration = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getHostedLocators(InternalDistributedMember member) {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsAll.get(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocators() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsAll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocatorsWithSharedConfiguration() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsWithSharedConfiguration;
        }
    }

    @Override
    public Set<InternalDistributedMember> getDistributionManagerIdsIncludingAdmin() {
        return new HashSet<InternalDistributedMember>(this.getViewMembers());
    }

    @Override
    public Set<InternalDistributedMember> getOtherDistributionManagerIds() {
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>(this.getDistributionManagerIds());
        InternalDistributedMember me = this.getDistributionManagerId();
        result.remove(me);
        return result;
    }

    @Override
    public Set<InternalDistributedMember> getOtherNormalDistributionManagerIds() {
        HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>(this.getNormalDistributionManagerIds());
        InternalDistributedMember me = this.getDistributionManagerId();
        result.remove(me);
        return result;
    }

    @Override
    public InternalDistributedMember getCanonicalId(DistributedMember id) {
        Distribution m = this.distribution;
        if (m == null) {
            return (InternalDistributedMember)id;
        }
        return (InternalDistributedMember)m.getView().getCanonicalID((MemberIdentifier)((InternalDistributedMember)id));
    }

    @Override
    public Set<InternalDistributedMember> addMembershipListenerAndGetDistributionManagerIds(MembershipListener l) {
        return this.distribution.doWithViewLocked(() -> {
            this.addMembershipListener(l);
            return this.distribution.getMembersNotShuttingDown();
        });
    }

    private void addNewMember(InternalDistributedMember member) {
        int vmType = member.getVmKind();
        switch (vmType) {
            case 12: {
                this.handleConsoleStartup(member);
                break;
            }
            case 10: 
            case 11: {
                this.handleManagerStartup(member);
                break;
            }
            default: {
                throw new InternalGemFireError(String.format("Unknown member type: %s", vmType));
            }
        }
    }

    @Override
    public InternalDistributedMember getId() {
        return this.localAddress;
    }

    @Override
    public Set<InternalDistributedMember> putOutgoing(DistributionMessage msg) {
        try {
            DistributionMessageObserver observer = DistributionMessageObserver.getInstance();
            if (observer != null) {
                observer.beforeSendMessage(this, msg);
            }
            return this.sendMessage(msg);
        }
        catch (NotSerializableException e) {
            throw new InternalGemFireException(e);
        }
    }

    public String toString() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        block21: {
            Object object = this.shutdownMutex;
            synchronized (object) {
                if (this.closeInProgress) {
                    return;
                }
                this.closeInProgress = true;
                this.distribution.setCloseInProgress();
            }
            String exceptionStatus = this.exceptionInThreads() ? "At least one Exception occurred." : "";
            logger.info("Shutting down DistributionManager {}. {}", new Object[]{this.localAddress, exceptionStatus});
            long start = System.currentTimeMillis();
            try {
                if (this.rootCause instanceof ForcedDisconnectException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("inhibiting sending of shutdown message to other members due to forced-disconnect");
                    }
                    break block21;
                }
                Runnable r = () -> {
                    try {
                        ConnectionTable.threadWantsSharedResources();
                        this.sendShutdownMessage();
                    }
                    catch (CancelException e) {
                        logger.debug("Cancelled during shutdown message", (Throwable)e);
                    }
                };
                LoggingThread t = new LoggingThread(String.format("Shutdown Message Thread for %s", this.localAddress), false, r);
                t.start();
                boolean interrupted = Thread.interrupted();
                try {
                    t.join(5000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    t.interrupt();
                    logger.warn("Interrupted sending shutdown message to peers", (Throwable)e);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (t.isAlive()) {
                    t.interrupt();
                    logger.warn("Failed sending shutdown message to peers (timeout)");
                }
            }
            finally {
                this.shutdownMsgSent = true;
                try {
                    this.uncleanShutdown(false);
                }
                finally {
                    Long delta = System.currentTimeMillis() - start;
                    logger.info("DistributionManager stopped in {}ms.", (Object)delta);
                }
            }
        }
    }

    private void askThreadsToStop() {
        this.executors.askThreadsToStop();
        Thread th = this.memberEventThread;
        if (th != null) {
            th.interrupt();
        }
    }

    private void waitForThreadsToStop(long timeInMillis) throws InterruptedException {
        long start = System.currentTimeMillis();
        this.executors.waitForThreadsToStop(timeInMillis);
        long remaining = timeInMillis - (System.currentTimeMillis() - start);
        if (remaining <= 0L) {
            return;
        }
        Thread th = this.memberEventThread;
        if (th != null) {
            th.interrupt();
            th.join(remaining);
        }
    }

    private void clobberThread(Thread t) {
        if (t == null) {
            return;
        }
        if (t.isAlive()) {
            logger.warn("Forcing thread stop on < {} >", (Object)t);
            t.interrupt();
            try {
                for (int i = 0; i < 10 && t.isAlive(); ++i) {
                    t.join(1000L);
                    t.interrupt();
                }
            }
            catch (InterruptedException ex) {
                logger.debug("Interrupted while attempting to terminate threads.");
                Thread.currentThread().interrupt();
            }
            if (t.isAlive()) {
                logger.warn("Thread refused to die: {}", (Object)t);
            }
        }
    }

    private void forceThreadsToStop() {
        this.executors.forceThreadsToStop();
        Thread th = this.memberEventThread;
        if (th != null) {
            this.clobberThread(th);
        }
    }

    @Override
    public boolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    /*
     * Exception decompiling
     */
    private void uncleanShutdown(boolean beforeJoined) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.system;
    }

    @Override
    public AlertingService getAlertingService() {
        return this.alertingService;
    }

    RemoteTransportConfig getTransport() {
        return this.transport;
    }

    @Override
    public void addMembershipListener(MembershipListener l) {
        this.membershipListeners.putIfAbsent(l, Boolean.TRUE);
    }

    @Override
    public void removeMembershipListener(MembershipListener l) {
        this.membershipListeners.remove(l);
    }

    @Override
    public Collection<MembershipListener> getMembershipListeners() {
        return Collections.unmodifiableSet(this.membershipListeners.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllMembershipListener(MembershipListener l) {
        Object object = this.allMembershipListenersLock;
        synchronized (object) {
            HashSet<MembershipListener> newAllMembershipListeners = new HashSet<MembershipListener>(this.allMembershipListeners);
            newAllMembershipListeners.add(l);
            this.allMembershipListeners = newAllMembershipListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMembershipListener(MembershipListener l) {
        Object object = this.allMembershipListenersLock;
        synchronized (object) {
            HashSet<MembershipListener> newAllMembershipListeners = new HashSet<MembershipListener>(this.allMembershipListeners);
            if (!newAllMembershipListeners.remove(l)) {
                // empty if block
            }
            this.allMembershipListeners = newAllMembershipListeners;
        }
    }

    private boolean shouldInhibitMembershipWarnings() {
        if (this.isCloseInProgress()) {
            return true;
        }
        InternalDistributedSystem ds = this.getSystem();
        return ds != null && ds.isDisconnecting();
    }

    public boolean isCloseInProgress() {
        return this.closeInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewInstalledEvent(ViewInstalledEvent ev) {
        Object object = this.membershipViewIdGuard;
        synchronized (object) {
            this.membershipViewIdAcknowledged = ev.getViewId();
            this.membershipViewIdGuard.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForViewInstallation(long id) throws InterruptedException {
        if (id <= this.membershipViewIdAcknowledged) {
            return;
        }
        Object object = this.membershipViewIdGuard;
        synchronized (object) {
            while (this.membershipViewIdAcknowledged < id && !this.stopper.isCancelInProgress()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting for view {}.  Current DM view processed by all listeners is {}", (Object)id, (Object)this.membershipViewIdAcknowledged);
                }
                this.membershipViewIdGuard.wait();
            }
        }
    }

    private void handleMemberEvent(MemberEvent ev) {
        ev.handleEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberEvent(MemberEvent ev) {
        if (SYNC_EVENTS) {
            this.handleMemberEvent(ev);
        } else {
            this.stopper.checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                this.membershipEventQueue.put(ev);
            }
            catch (InterruptedException ex) {
                interrupted = true;
                this.stopper.checkCancelInProgress(ex);
                this.handleMemberEvent(ev);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.shutdown();
            logger.info("Marking DistributionManager {} as closed.", (Object)this.localAddress);
            MembershipLogger.logShutdown(this.localAddress);
            this.closed = true;
        }
    }

    @Override
    public void throwIfDistributionStopped() {
        if (this.shutdownMsgSent) {
            throw new DistributedSystemDisconnectedException("Message distribution has terminated", this.getRootCause());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void addAdminConsole(InternalDistributedMember theId) {
    }

    @Override
    public DMStats getStats() {
        return this.stats;
    }

    @Override
    public DistributionConfig getConfig() {
        DistributionConfig result = null;
        InternalDistributedSystem sys = this.getSystem();
        if (sys != null) {
            result = this.system.getConfig();
        }
        return result;
    }

    @Override
    public Set<InternalDistributedMember> getAllOtherMembers() {
        Set<InternalDistributedMember> result = this.getDistributionManagerIdsIncludingAdmin();
        result.remove(this.getDistributionManagerId());
        return result;
    }

    @Override
    public void retainMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        members.removeIf(id -> id.getVersionOrdinalObject().compareTo((Object)version) < 0);
    }

    @Override
    public void removeMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        members.removeIf(id -> id.getVersionOrdinalObject().compareTo((Object)version) >= 0);
    }

    @Override
    public Set<InternalDistributedMember> addAllMembershipListenerAndGetAllIds(MembershipListener l) {
        return this.distribution.doWithViewLocked(() -> {
            this.addAllMembershipListener(l);
            return this.distribution.getMembersNotShuttingDown();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendStartupMessage(StartupOperation startupOperation) throws InterruptedException {
        boolean ok;
        Set<InetAddress> equivs;
        block24: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.receivedStartupResponse = false;
            equivs = StartupMessage.getMyAddresses(this);
            if (equivs == null || equivs.size() == 0) {
                equivs = new HashSet<InetAddress>();
                try {
                    equivs.add(LocalHostUtil.getLocalHost());
                }
                catch (UnknownHostException e) {
                    if (this.getViewMembers().size() <= 1) break block24;
                    throw new SystemConnectException("Unable to examine network cards and other members exist");
                }
            }
        }
        this.setEquivalentHosts(equivs);
        this.setEnforceUniqueZone(this.getConfig().getEnforceUniqueHost());
        String redundancyZone = this.getConfig().getRedundancyZone();
        if (redundancyZone != null && !redundancyZone.equals("")) {
            this.setEnforceUniqueZone(true);
        }
        this.setRedundancyZone(this.getDistributionManagerId(), redundancyZone);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Equivalent IPs for this host: ");
            Iterator<InetAddress> it = equivs.iterator();
            while (it.hasNext()) {
                InetAddress in = it.next();
                sb.append(in.toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            logger.debug((CharSequence)sb);
        }
        HashSet<InternalDistributedMember> allOthers = new HashSet<InternalDistributedMember>(this.getViewMembers());
        allOthers.remove(this.getDistributionManagerId());
        if (allOthers.isEmpty()) {
            return false;
        }
        try {
            ok = startupOperation.sendStartupMessage(allOthers, equivs, redundancyZone, this.enforceUniqueZone());
        }
        catch (Exception re) {
            throw new SystemConnectException("One or more peers generated exceptions during connection attempt", re);
        }
        if (this.rejectionMessage != null) {
            throw new IncompatibleSystemException(this.rejectionMessage);
        }
        boolean receivedAny = this.receivedStartupResponse;
        if (!ok) {
            Object object = this.unfinishedStartupsLock;
            synchronized (object) {
                int unresponsiveCount = this.unfinishedStartups == null ? 0 : this.unfinishedStartups.size();
                if (unresponsiveCount != 0 && Boolean.getBoolean("DistributionManager.requireAllStartupResponses")) {
                    throw new SystemConnectException(String.format("No startup replies from: %s", this.unfinishedStartups));
                }
            }
            if (allOthers.size() != 0 && !receivedAny) {
                StringBuilder sb = new StringBuilder();
                Iterator itt = allOthers.iterator();
                while (itt.hasNext()) {
                    Object m = itt.next();
                    sb.append(m.toString());
                    if (!itt.hasNext()) continue;
                    sb.append(", ");
                }
                if (DEBUG_NO_ACKNOWLEDGEMENTS) {
                    this.printStacks(allOthers, false);
                }
                throw new SystemConnectException(String.format("Received no connection acknowledgments from any of the %s senior cache members: %s", Integer.toString(allOthers.size()), sb.toString()));
            }
            InternalDistributedMember e = this.clusterElderManager.getElderId();
            if (e != null) {
                boolean unresponsiveElder;
                Object object2 = this.unfinishedStartupsLock;
                synchronized (object2) {
                    unresponsiveElder = this.unfinishedStartups == null ? false : this.unfinishedStartups.contains(e);
                }
                if (unresponsiveElder) {
                    logger.warn("Forcing an elder join event since a startup response was not received from elder {}.", (Object)e);
                    this.handleManagerStartup(e);
                }
            }
        }
        return receivedAny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnfinishedStartups(Collection<InternalDistributedMember> s) {
        Object object = this.unfinishedStartupsLock;
        synchronized (object) {
            Assert.assertTrue(this.unfinishedStartups == null, "Set unfinished startups twice");
            this.unfinishedStartups = new HashSet<InternalDistributedMember>(s);
            Iterator<InternalDistributedMember> it = this.unfinishedStartups.iterator();
            Object object2 = this.membersLock;
            synchronized (object2) {
                while (it.hasNext()) {
                    InternalDistributedMember m = it.next();
                    if (this.isCurrentMember(m)) continue;
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnfinishedStartup(InternalDistributedMember m, boolean departed) {
        Object object = this.unfinishedStartupsLock;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("removeUnfinishedStartup for {} wtih {}", (Object)m, this.unfinishedStartups);
            }
            if (this.unfinishedStartups == null) {
                return;
            }
            if (!this.unfinishedStartups.remove(m)) {
                return;
            }
            String msg = departed ? "Stopped waiting for startup reply from <{}> because the peer departed the view." : "Stopped waiting for startup reply from <{}> because the reply was finally received.";
            logger.info(msg, (Object)m);
            int numLeft = this.unfinishedStartups.size();
            if (numLeft != 0) {
                logger.info("Still awaiting {} response(s) from: {}.", new Object[]{numLeft, this.unfinishedStartups});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStartupResponse(InternalDistributedMember sender, String theRejectionMessage) {
        this.removeUnfinishedStartup(sender, false);
        ClusterDistributionManager clusterDistributionManager = this;
        synchronized (clusterDistributionManager) {
            if (!this.receivedStartupResponse) {
                this.receivedStartupResponse = true;
            }
            if (theRejectionMessage != null && this.rejectionMessage == null) {
                this.rejectionMessage = theRejectionMessage;
            }
        }
    }

    private String prettifyReason(String r) {
        String str = "java.io.IOException:";
        if (r.startsWith("java.io.IOException:")) {
            return r.substring("java.io.IOException:".length());
        }
        return r;
    }

    private void handleManagerStartup(InternalDistributedMember theId) {
        if (theId.getVmKind() != 11) {
            this.stats.incNodes(1);
        }
        this.addMemberEvent(new MemberJoinedEvent(theId));
    }

    @Override
    public boolean isCurrentMember(DistributedMember id) {
        return this.distribution.getView().contains((MemberIdentifier)((InternalDistributedMember)id));
    }

    private void handleConsoleStartup(InternalDistributedMember theId) {
        for (MembershipListener listener : this.allMembershipListeners) {
            listener.memberJoined(this, theId);
        }
        logger.info("DMMembership: Admitting new administration member < {} >.", (Object)theId);
    }

    private void handleIncomingDMsg(Message message) {
        this.stats.incReceivedMessages(1L);
        this.stats.incReceivedBytes(message.getBytesRead());
        this.stats.incMessageChannelTime(message.resetTimestamp());
        if (logger.isDebugEnabled()) {
            logger.debug("Received message '{}' from <{}>", (Object)message, (Object)message.getSender());
        }
        this.scheduleIncomingMessage((DistributionMessage)message);
    }

    public void handleConsoleShutdown(InternalDistributedMember theId, boolean crashed, String reason) {
        this.removeHostedLocators(theId);
        for (MembershipListener listener : this.allMembershipListeners) {
            listener.memberDeparted(this, theId, crashed);
        }
        this.redundancyZones.remove(theId);
    }

    void shutdownMessageReceived(InternalDistributedMember theId, String reason) {
        this.removeHostedLocators(theId);
        this.distribution.shutdownMessageReceived(theId, reason);
        this.handleManagerDeparture(theId, false, reason);
    }

    @Override
    public void handleManagerDeparture(InternalDistributedMember theId, boolean memberCrashed, String reason) {
        String msg;
        this.alertingService.removeAlertListener(theId);
        this.removeUnfinishedStartup(theId, true);
        int vmType = theId.getVmKind();
        if (vmType == 12) {
            this.handleConsoleShutdown(theId, memberCrashed, reason);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DistributionManager: removing member <{}>; crashed {}; reason = {}", (Object)theId, (Object)memberCrashed, (Object)this.prettifyReason(reason));
        }
        this.removeHostedLocators(theId);
        this.redundancyZones.remove(theId);
        if (theId.getVmKind() != 11) {
            this.stats.incNodes(-1);
        }
        if (memberCrashed && !this.shouldInhibitMembershipWarnings()) {
            msg = "Member at {} unexpectedly left the distributed cache: {}";
            this.addMemberEvent(new MemberCrashedEvent(theId, reason));
        } else {
            msg = "Member at {} gracefully left the distributed cache: {}";
            this.addMemberEvent(new MemberDepartedEvent(theId, reason));
        }
        logger.info(msg, new Object[]{theId, this.prettifyReason(reason)});
        this.executors.handleManagerDeparture(theId);
    }

    private void handleManagerSuspect(InternalDistributedMember suspect, InternalDistributedMember whoSuspected, String reason) {
        if (!this.isCurrentMember(suspect)) {
            return;
        }
        int vmType = suspect.getVmKind();
        if (vmType == 12) {
            return;
        }
        this.addMemberEvent(new MemberSuspectEvent(suspect, whoSuspected, reason));
    }

    private void handleViewInstalled(MembershipView view) {
        this.addMemberEvent(new ViewInstalledEvent(view));
    }

    private void handleQuorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        this.addMemberEvent(new QuorumLostEvent(failures, remaining));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendShutdownMessage() {
        if (this.getDMType() == 12 && Locator.getLocators().size() == 0) {
            return;
        }
        ShutdownMessage m = new ShutdownMessage();
        InternalDistributedMember theId = this.getDistributionManagerId();
        m.setDistributionManagerId(theId);
        HashSet<InternalDistributedMember> allOthers = new HashSet<InternalDistributedMember>(this.getViewMembers());
        allOthers.remove(this.getDistributionManagerId());
        m.setRecipients(allOthers);
        if (logger.isTraceEnabled()) {
            logger.trace("{} Sending {} to {}", (Object)this.getDistributionManagerId(), (Object)m, (Object)m.getRecipientsDescription());
        }
        try {
            long startTime = DistributionStats.getStatTime();
            this.sendViaMembershipManager(m.getRecipients(), m, this, this.stats);
            this.stats.incSentMessages(1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incSentMessagesTime(DistributionStats.getStatTime() - startTime);
            }
        }
        catch (CancelException e) {
            logger.debug(String.format("CancelException caught sending shutdown: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception ex2) {
            logger.fatal("While sending shutdown message", (Throwable)ex2);
        }
        finally {
            this.shutdownMsgSent = true;
        }
    }

    Set<InternalDistributedMember> sendOutgoing(DistributionMessage message) throws NotSerializableException {
        boolean sentToAll;
        long startTime = DistributionStats.getStatTime();
        Set<InternalDistributedMember> result = this.sendViaMembershipManager(message.getRecipients(), message, this, this.stats);
        long endTime = 0L;
        if (DistributionStats.enableClockStats) {
            endTime = NanoTimer.getTime();
        }
        if (sentToAll = message.forAll()) {
            this.stats.incBroadcastMessages(1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incBroadcastMessagesTime(endTime - startTime);
            }
        }
        this.stats.incSentMessages(1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incSentMessagesTime(endTime - startTime);
            this.stats.incDistributeMessageTime(endTime - message.getTimestamp());
        }
        return result;
    }

    private Set<InternalDistributedMember> sendMessage(DistributionMessage message) throws NotSerializableException {
        try {
            this.stopper.checkCancelInProgress(null);
            this.waitUntilReadyToSendMsgs(message);
            return this.sendOutgoing(message);
        }
        catch (NotSerializableException | CancelException | InvalidDeltaException | ToDataException | ReenteredConnectException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.exceptionInThreads = true;
            String receiver = "NULL";
            if (message != null) {
                receiver = message.getRecipientsDescription();
            }
            logger.fatal(String.format("While pushing message <%s> to %s", message, receiver), (Throwable)ex);
            if (message == null || message.forAll()) {
                return null;
            }
            return new HashSet<InternalDistributedMember>(message.getRecipients());
        }
    }

    private Set<InternalDistributedMember> sendViaMembershipManager(List<InternalDistributedMember> destinations, DistributionMessage content, ClusterDistributionManager dm, DistributionStats stats) throws NotSerializableException {
        if (this.distribution == null) {
            logger.warn("Attempting a send to a disconnected DistributionManager");
            if (destinations.size() == 1 && destinations.get(0) == Message.ALL_RECIPIENTS) {
                return null;
            }
            return new HashSet<InternalDistributedMember>(destinations);
        }
        return this.distribution.send(destinations, content);
    }

    private void scheduleIncomingMessage(DistributionMessage message) {
        this.waitUntilReadyForMessages();
        message.schedule(this);
    }

    @Override
    public InternalDistributedMember getElderId() throws DistributedSystemDisconnectedException {
        return this.clusterElderManager.getElderId();
    }

    @Override
    public boolean isElder() {
        return this.clusterElderManager.isElder();
    }

    @Override
    public boolean isLoner() {
        return false;
    }

    @Override
    public ElderState getElderState(boolean waitToBecomeElder) throws InterruptedException {
        return this.clusterElderManager.getElderState(waitToBecomeElder);
    }

    public boolean waitForElder(InternalDistributedMember desiredElder) throws InterruptedException {
        return this.clusterElderManager.waitForElder(desiredElder);
    }

    public void setAgent(RemoteGfManagerAgent agent) {
        if (agent != null) {
            if (this.agent != null) {
                throw new IllegalStateException("There is already an Admin Agent associated with this distribution manager.");
            }
        } else if (this.agent == null) {
            throw new IllegalStateException("There was never an Admin Agent associated with this distribution manager.");
        }
        this.agent = agent;
    }

    public RemoteGfManagerAgent getAgent() {
        return this.agent;
    }

    public String getDistributionConfigDescription() {
        if (this.agent == null) {
            return null;
        }
        return this.agent.getTransport().toString();
    }

    @Override
    public HealthMonitor getHealthMonitor(InternalDistributedMember owner) {
        return (HealthMonitor)this.hmMap.get(owner);
    }

    @Override
    public void createHealthMonitor(InternalDistributedMember owner, GemFireHealthConfig cfg) {
        if (this.closeInProgress) {
            return;
        }
        HealthMonitor hm = this.getHealthMonitor(owner);
        if (hm != null) {
            hm.stop();
            this.hmMap.remove(owner);
        }
        HealthMonitorImpl newHm = new HealthMonitorImpl(owner, cfg, this);
        newHm.start();
        this.hmMap.put(owner, newHm);
    }

    @Override
    public void removeHealthMonitor(InternalDistributedMember owner, int theId) {
        HealthMonitor hm = this.getHealthMonitor(owner);
        if (hm != null && hm.getId() == theId) {
            hm.stop();
            this.hmMap.remove(owner);
        }
    }

    private void removeAllHealthMonitors() {
        Iterator it = this.hmMap.values().iterator();
        while (it.hasNext()) {
            HealthMonitor hm = (HealthMonitor)it.next();
            hm.stop();
            it.remove();
        }
    }

    private List<MembershipTestHook> getMembershipTestHooks() {
        return this.membershipTestHooks;
    }

    @Override
    public Set<InternalDistributedMember> getAdminMemberSet() {
        return this.distribution.getView().getMembers().stream().filter(id -> id.getVmKind() == 12).collect(Collectors.toSet());
    }

    @Override
    public int getRoleCount(Role role) {
        int count = 0;
        Set<InternalDistributedMember> mbrs = this.getDistributionManagerIds();
        block0: for (InternalDistributedMember mbr : mbrs) {
            Set<Role> roles = mbr.getRoles();
            for (Role mbrRole : roles) {
                if (!mbrRole.equals(role)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Override
    public boolean isRolePresent(Role role) {
        Set<InternalDistributedMember> mbrs = this.getDistributionManagerIds();
        for (InternalDistributedMember mbr : mbrs) {
            Set<Role> roles = mbr.getRoles();
            for (Role mbrRole : roles) {
                if (!mbrRole.equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Role> getAllRoles() {
        HashSet<Role> allRoles = new HashSet<Role>();
        Set<InternalDistributedMember> mbrs = this.getDistributionManagerIds();
        for (InternalDistributedMember mbr : mbrs) {
            allRoles.addAll(mbr.getRoles());
        }
        return allRoles;
    }

    @Override
    public Distribution getDistribution() {
        return this.distribution;
    }

    @Override
    public Throwable getRootCause() {
        return this.rootCause;
    }

    @Override
    public void setRootCause(Throwable t) {
        this.rootCause = t;
    }

    @Override
    public Set<InternalDistributedMember> getMembersInThisZone() {
        return this.getMembersInSameZone(this.getDistributionManagerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> getMembersInSameZone(InternalDistributedMember targetMember) {
        HashSet<InternalDistributedMember> buddyMembers = new HashSet<InternalDistributedMember>();
        if (!this.redundancyZones.isEmpty()) {
            Map<InternalDistributedMember, String> map = this.redundancyZones;
            synchronized (map) {
                String targetZone = this.redundancyZones.get(targetMember);
                for (Map.Entry<InternalDistributedMember, String> entry : this.redundancyZones.entrySet()) {
                    if (!entry.getValue().equals(targetZone)) continue;
                    buddyMembers.add(entry.getKey());
                }
            }
        } else {
            buddyMembers.add(targetMember);
            Set<InetAddress> targetAddrs = this.getEquivalents(targetMember.getInetAddress());
            for (InternalDistributedMember o : this.getDistributionManagerIds()) {
                if (Collections.disjoint(targetAddrs, this.getEquivalents(o.getInetAddress()))) continue;
                buddyMembers.add(o);
            }
        }
        return buddyMembers;
    }

    @Override
    public boolean areInSameZone(InternalDistributedMember member1, InternalDistributedMember member2) {
        if (!this.redundancyZones.isEmpty()) {
            String zone1 = this.redundancyZones.get(member1);
            String zone2 = this.redundancyZones.get(member2);
            return zone1 != null && zone1.equals(zone2);
        }
        return this.areOnEquivalentHost(member1, member2);
    }

    @Override
    public void acquireGIIPermitUninterruptibly() {
        this.parallelGIIs.acquireUninterruptibly();
        this.stats.incInitialImageRequestsInProgress(1);
    }

    @Override
    public void releaseGIIPermit() {
        this.stats.incInitialImageRequestsInProgress(-1);
        this.parallelGIIs.release();
    }

    public void setDistributedSystemId(int distributedSystemId) {
        if (distributedSystemId != -1) {
            this.distributedSystemId = distributedSystemId;
        }
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    @Override
    public void registerTestHook(MembershipTestHook mth) {
        this.getDistribution().doWithViewLocked(() -> {
            if (this.membershipTestHooks == null) {
                this.membershipTestHooks = Collections.singletonList(mth);
            } else {
                ArrayList<MembershipTestHook> l = new ArrayList<MembershipTestHook>(this.membershipTestHooks);
                l.add(mth);
                this.membershipTestHooks = l;
            }
            return null;
        });
    }

    @Override
    public void unregisterTestHook(MembershipTestHook mth) {
        this.getDistribution().doWithViewLocked(() -> {
            if (this.membershipTestHooks != null) {
                if (this.membershipTestHooks.size() == 1) {
                    this.membershipTestHooks = null;
                } else {
                    ArrayList<MembershipTestHook> l = new ArrayList<MembershipTestHook>(this.membershipTestHooks);
                    l.remove(mth);
                    this.membershipTestHooks = l;
                }
            }
            return null;
        });
    }

    public void printStacks(Collection<InternalDistributedMember> ids, boolean useNative) {
        HashSet<InternalDistributedMember> requiresMessage = new HashSet<InternalDistributedMember>();
        if (ids.contains(this.localAddress)) {
            OSProcess.printStacks((int)0, (boolean)useNative);
        }
        if (useNative) {
            requiresMessage.addAll(ids);
            ids.remove(this.localAddress);
        } else {
            for (InternalDistributedMember mbr : ids) {
                if (mbr.getProcessId() > 0 && mbr.getInetAddress().equals(this.localAddress.getInetAddress())) {
                    if (mbr.equals(this.localAddress) || OSProcess.printStacks((int)mbr.getProcessId(), (boolean)false)) continue;
                    requiresMessage.add(mbr);
                    continue;
                }
                requiresMessage.add(mbr);
            }
        }
        if (requiresMessage.size() > 0) {
            HighPriorityAckedMessage msg = new HighPriorityAckedMessage();
            msg.dumpStacks(requiresMessage, useNative, false);
        }
    }

    @Override
    public Set<DistributedMember> getGroupMembers(String group) {
        HashSet<DistributedMember> result = null;
        for (DistributedMember distributedMember : this.getDistributionManagerIdsIncludingAdmin()) {
            if (!distributedMember.getGroups().contains(group)) continue;
            if (result == null) {
                result = new HashSet<DistributedMember>();
            }
            result.add(distributedMember);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public Set<InternalDistributedMember> getNormalDistributionManagerIds() {
        return this.distribution.getMembersNotShuttingDown().stream().filter(id -> id.getVmKind() != 11).collect(Collectors.toSet());
    }

    public Set<InternalDistributedMember> getLocatorDistributionManagerIds() {
        return this.distribution.getMembersNotShuttingDown().stream().filter(id -> id.getVmKind() == 11).collect(Collectors.toSet());
    }

    @Override
    public void setCache(InternalCache instance) {
        this.cache = instance;
    }

    @Override
    public InternalCache getCache() {
        return this.cache;
    }

    @Override
    public InternalCache getExistingCache() {
        InternalCache result = this.cache;
        if (result == null) {
            throw new CacheClosedException("A cache has not yet been created.");
        }
        result.getCancelCriterion().checkCancelInProgress(null);
        if (result.isClosed()) {
            throw result.getCacheClosedException("The cache has been closed.", null);
        }
        return result;
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    static class ClusterDistributionManagerIDFactory
    implements MemberIdentifierFactory<InternalDistributedMember> {
        @Immutable
        private static final Comparator<InternalDistributedMember> idComparator = InternalDistributedMember::compareTo;

        ClusterDistributionManagerIDFactory() {
        }

        public InternalDistributedMember create(MemberData memberInfo) {
            return new InternalDistributedMember(memberInfo);
        }

        public Comparator<InternalDistributedMember> getComparator() {
            return idComparator;
        }
    }

    private static class Stopper
    extends CancelCriterion {
        private ClusterDistributionManager dm;

        Stopper(ClusterDistributionManager dm) {
            this.dm = dm;
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            if (this.dm.shutdownMsgSent) {
                return String.format("%s: Message distribution has terminated", this.dm.toString());
            }
            if (this.dm.rootCause != null) {
                return this.dm.toString() + ": " + this.dm.rootCause.getMessage();
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            Throwable rc = this.dm.rootCause;
            if (rc == null) {
                return new DistributedSystemDisconnectedException(reason, e);
            }
            if (e == null) {
                if (rc instanceof MemberDisconnectedException) {
                    rc = new ForcedDisconnectException(rc.getMessage());
                }
                return new DistributedSystemDisconnectedException(reason, rc);
            }
            Throwable nt = e;
            while (nt.getCause() != null) {
                nt = nt.getCause();
            }
            if (nt == rc) {
                return new DistributedSystemDisconnectedException(reason, e);
            }
            try {
                nt.initCause(rc);
                return new DistributedSystemDisconnectedException(reason, e);
            }
            catch (IllegalStateException e2) {
                return new DistributedSystemDisconnectedException(reason, rc);
            }
        }
    }

    private static class QuorumLostEvent
    extends MemberEvent {
        Set<InternalDistributedMember> failures;
        List<InternalDistributedMember> remaining;

        QuorumLostEvent(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            super(null);
            this.failures = failures;
            this.remaining = remaining;
        }

        public Set<InternalDistributedMember> getFailures() {
            return this.failures;
        }

        public List<InternalDistributedMember> getRemaining() {
            return this.remaining;
        }

        public String toString() {
            return "quorum lost.  failures=" + this.failures + "; remaining=" + this.remaining;
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.quorumLost(manager, this.getFailures(), this.getRemaining());
        }
    }

    private static class ViewInstalledEvent
    extends MemberEvent {
        MembershipView view;

        ViewInstalledEvent(MembershipView view) {
            super(null);
            this.view = view;
        }

        public long getViewId() {
            return this.view.getViewId();
        }

        public String toString() {
            return "view installed: " + this.view;
        }

        @Override
        public void handleEvent(ClusterDistributionManager manager) {
            manager.handleViewInstalledEvent(this);
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MemberSuspectEvent
    extends MemberEvent {
        InternalDistributedMember whoSuspected;
        String reason;

        MemberSuspectEvent(InternalDistributedMember suspect, InternalDistributedMember whoSuspected, String reason) {
            super(suspect);
            this.whoSuspected = whoSuspected;
            this.reason = reason;
        }

        public InternalDistributedMember whoSuspected() {
            return this.whoSuspected;
        }

        public String getReason() {
            return this.reason;
        }

        public String toString() {
            return "member " + this.getId() + " suspected by: " + this.whoSuspected + " reason: " + this.reason;
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberSuspect(manager, this.getId(), this.whoSuspected(), this.reason);
        }
    }

    private static class MemberCrashedEvent
    extends MemberEvent {
        String reason;

        MemberCrashedEvent(InternalDistributedMember id, String r) {
            super(id);
            this.reason = r;
        }

        public String toString() {
            return "member " + this.getId() + " crashed: " + this.reason;
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberDeparted(manager, this.getId(), true);
        }
    }

    private static class MemberDepartedEvent
    extends MemberEvent {
        String reason;

        MemberDepartedEvent(InternalDistributedMember id, String r) {
            super(id);
            this.reason = r;
        }

        public String toString() {
            return "member " + this.getId() + " departed (" + this.reason + ")";
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberDeparted(manager, this.getId(), false);
        }
    }

    private static class MemberJoinedEvent
    extends MemberEvent {
        MemberJoinedEvent(InternalDistributedMember id) {
            super(id);
        }

        public String toString() {
            return "member " + this.getId() + " joined";
        }

        @Override
        protected void handleEvent(ClusterDistributionManager manager, MembershipListener listener) {
            listener.memberJoined(manager, this.getId());
        }
    }

    private static abstract class MemberEvent {
        private InternalDistributedMember id;

        MemberEvent(InternalDistributedMember id) {
            this.id = id;
        }

        public InternalDistributedMember getId() {
            return this.id;
        }

        void handleEvent(ClusterDistributionManager manager) {
            this.handleEvent(manager, manager.membershipListeners.keySet());
            this.handleEvent(manager, manager.allMembershipListeners);
        }

        protected abstract void handleEvent(ClusterDistributionManager var1, MembershipListener var2);

        private void handleEvent(ClusterDistributionManager manager, Set<MembershipListener> membershipListeners) {
            for (MembershipListener listener : membershipListeners) {
                try {
                    this.handleEvent(manager, listener);
                }
                catch (CancelException e) {
                    if (manager.shouldInhibitMembershipWarnings()) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: cancelled");
                        break;
                    }
                    logger.warn("Unexpected cancellation", (Throwable)e);
                    break;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn(String.format("Exception while calling membership listener for event: %s", this), t);
                }
            }
        }
    }

    static class DMListener
    implements org.apache.geode.distributed.internal.membership.api.MembershipListener<InternalDistributedMember> {
        ClusterDistributionManager dm;

        DMListener(ClusterDistributionManager dm) {
            this.dm = dm;
        }

        public void membershipFailure(String reason, Throwable t) {
            this.dm.exceptionInThreads = true;
            Throwable cause = t;
            if (cause != null && !(cause instanceof ForcedDisconnectException)) {
                logger.info("cluster membership failed due to ", cause);
                cause = new ForcedDisconnectException(cause.getMessage());
            }
            this.dm.setRootCause(cause);
            try {
                List testHooks = this.dm.getMembershipTestHooks();
                if (testHooks != null) {
                    for (MembershipTestHook testHook : testHooks) {
                        testHook.beforeMembershipFailure(reason, cause);
                    }
                }
                this.dm.getSystem().disconnect(reason, true);
                testHooks = this.dm.getMembershipTestHooks();
                if (testHooks != null) {
                    for (MembershipTestHook testHook : testHooks) {
                        testHook.afterMembershipFailure(reason, cause);
                    }
                }
            }
            catch (RuntimeException re) {
                logger.warn("Exception caught while shutting down", (Throwable)re);
            }
        }

        public void newMemberConnected(InternalDistributedMember member) {
            try {
                this.dm.addNewMember(member);
            }
            catch (VirtualMachineError err) {
                throw err;
            }
            catch (DistributedSystemDisconnectedException err) {
            }
            catch (Throwable t) {
                logger.info(String.format("Membership: Fault while processing view addition of %s", member), t);
            }
        }

        public void memberDeparted(InternalDistributedMember theId, boolean crashed, String reason) {
            try {
                boolean wasAdmin = this.dm.getAdminMemberSet().contains(theId);
                if (wasAdmin) {
                    AdminConsoleDisconnectMessage message = new AdminConsoleDisconnectMessage();
                    message.setSender(theId);
                    message.setCrashed(crashed);
                    message.setAlertListenerExpected(true);
                    message.setIgnoreAlertListenerRemovalFailure(true);
                    message.setRecipient(this.dm.getDistributionManagerId());
                    message.setReason(reason);
                    this.dm.handleIncomingDMsg(message);
                }
                this.dm.handleManagerDeparture(theId, crashed, reason);
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }

        public void memberSuspect(InternalDistributedMember suspect, InternalDistributedMember whoSuspected, String reason) {
            try {
                this.dm.handleManagerSuspect(suspect, whoSuspected, reason);
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }

        public void viewInstalled(MembershipView view) {
            try {
                this.dm.handleViewInstalled(view);
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }

        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            this.dm.handleQuorumLost(failures, remaining);
        }

        public void saveConfig() {
            if (!this.dm.getConfig().getDisableAutoReconnect()) {
                this.dm.getCache().saveCacheXmlForReconnect();
            }
        }
    }

    protected class MemberEventInvoker
    implements Runnable {
        protected MemberEventInvoker() {
        }

        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (!((ClusterDistributionManager)ClusterDistributionManager.this).system.isConnected && ClusterDistributionManager.this.isClosed()) break;
                try {
                    MemberEvent ev = (MemberEvent)ClusterDistributionManager.this.membershipEventQueue.take();
                    ClusterDistributionManager.this.handleMemberEvent(ev);
                    continue;
                }
                catch (InterruptedException e) {
                    if (ClusterDistributionManager.this.shouldInhibitMembershipWarnings()) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: InterruptedException during shutdown");
                        break;
                    }
                    logger.warn("Unexpected InterruptedException", (Throwable)e);
                }
                catch (DistributedSystemDisconnectedException e) {
                }
                catch (CancelException e) {
                    if (ClusterDistributionManager.this.shouldInhibitMembershipWarnings()) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: cancelled");
                        break;
                    }
                    logger.warn("Unexpected cancellation", (Throwable)e);
                }
                catch (Exception e) {
                    logger.fatal("Uncaught exception processing member event", (Throwable)e);
                    continue;
                }
                break;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("MemberEventInvoker on {} stopped", (Object)ClusterDistributionManager.this);
            }
        }
    }
}

