/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexConcurrentHashSet;
import org.apache.geode.cache.query.internal.index.IndexElemArray;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexStore;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;

public class MemoryIndexStore
implements IndexStore {
    final ConcurrentNavigableMap valueToEntriesMap = new ConcurrentSkipListMap(TypeUtils.getExtendedNumericComparator());
    private final AtomicInteger numIndexKeys = new AtomicInteger(0);
    private ConcurrentMap entryToValuesMap;
    private final AbstractIndex.InternalIndexStatistics internalIndexStats;
    private final InternalCache cache;
    private final Region region;
    private boolean indexOnRegionKeys;
    private boolean indexOnValues;
    private final Object TRANSITIONING_TOKEN = new IndexElemArray(1);

    MemoryIndexStore(Region region, AbstractIndex.InternalIndexStatistics internalIndexStats, InternalCache cache) {
        this.region = region;
        RegionAttributes ra = region.getAttributes();
        if (IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap = new ConcurrentHashMap(ra.getInitialCapacity(), ra.getLoadFactor(), ra.getConcurrencyLevel());
        }
        this.internalIndexStats = internalIndexStats;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMapping(Object indexKey, Object oldKey, RegionEntry re, Object oldValue) throws IMQException {
        try {
            Object targetObject;
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.BEFORE_ADD_OR_UPDATE_MAPPING_OR_DESERIALIZING_NTH_STREAMINGOPERATION, null, null);
            }
            if (IndexManager.isObjectModificationInplace()) {
                if (this.entryToValuesMap.containsKey(re)) {
                    oldKey = this.entryToValuesMap.get(re);
                }
            } else if (oldValue != null && oldValue == this.getTargetObjectInVM(re)) {
                oldKey = this.getOldKey(indexKey, re);
            }
            if (oldKey != null && oldKey.equals(TypeUtils.indexKeyFor(indexKey))) {
                return;
            }
            boolean retry = false;
            if ((indexKey = TypeUtils.indexKeyFor(indexKey)).equals(QueryService.UNDEFINED) && Token.isInvalidOrRemoved(targetObject = this.getTargetObjectForUpdate(re))) {
                if (oldKey != null) {
                    this.basicRemoveMapping(oldKey, re, false);
                }
                return;
            }
            do {
                Object elemArray;
                retry = false;
                RegionEntry regionEntries = this.valueToEntriesMap.putIfAbsent(indexKey, re);
                if (regionEntries == this.TRANSITIONING_TOKEN) {
                    retry = true;
                    continue;
                }
                if (regionEntries == null) {
                    this.internalIndexStats.incNumKeys(1L);
                    this.numIndexKeys.incrementAndGet();
                } else if (regionEntries instanceof RegionEntry) {
                    elemArray = new IndexElemArray();
                    if (DefaultQuery.testHook != null) {
                        DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.BEGIN_TRANSITION_FROM_REGION_ENTRY_TO_ELEMARRAY, null, null);
                    }
                    ((IndexElemArray)elemArray).add(regionEntries);
                    ((IndexElemArray)elemArray).add(re);
                    if (!this.valueToEntriesMap.replace(indexKey, regionEntries, elemArray)) {
                        retry = true;
                    }
                    if (DefaultQuery.testHook != null) {
                        DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.TRANSITIONED_FROM_REGION_ENTRY_TO_ELEMARRAY, null, null);
                    }
                    if (DefaultQuery.testHook != null) {
                        DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.COMPLETE_TRANSITION_FROM_REGION_ENTRY_TO_ELEMARRAY, null, null);
                    }
                } else if (regionEntries instanceof IndexConcurrentHashSet) {
                    elemArray = regionEntries;
                    synchronized (elemArray) {
                        ((IndexConcurrentHashSet)((Object)regionEntries)).add(re);
                    }
                    if (regionEntries != this.valueToEntriesMap.get(indexKey)) {
                        retry = true;
                    }
                } else {
                    Object object = elemArray = (IndexElemArray)((Object)regionEntries);
                    synchronized (object) {
                        if (((IndexElemArray)elemArray).size() >= IndexManager.INDEX_ELEMARRAY_THRESHOLD) {
                            IndexConcurrentHashSet set = new IndexConcurrentHashSet(IndexManager.INDEX_ELEMARRAY_THRESHOLD + 20, 0.75f, 1);
                            if (DefaultQuery.testHook != null) {
                                DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.BEGIN_TRANSITION_FROM_ELEMARRAY_TO_CONCURRENT_HASH_SET, null, null);
                            }
                            if (!this.valueToEntriesMap.replace(indexKey, regionEntries, this.TRANSITIONING_TOKEN)) {
                                retry = true;
                            } else {
                                if (DefaultQuery.testHook != null) {
                                    DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.TRANSITIONED_FROM_ELEMARRAY_TO_TOKEN, null, null);
                                }
                                set.add(re);
                                set.addAll(elemArray);
                                if (!this.valueToEntriesMap.replace(indexKey, this.TRANSITIONING_TOKEN, set)) {
                                    this.region.getCache().getLogger().warning("Unable to transition from index elem to concurrent hash set.  Index needs to be recreated");
                                    throw new IndexMaintenanceException("Unable to transition from index elem to concurrent hash set.  Index needs to be recreated");
                                }
                                if (DefaultQuery.testHook != null) {
                                    DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.COMPLETE_TRANSITION_FROM_ELEMARRAY_TO_CONCURRENT_HASH_SET, null, null);
                                }
                            }
                        } else {
                            ((IndexElemArray)elemArray).add(re);
                            if (regionEntries != this.valueToEntriesMap.get(indexKey)) {
                                retry = true;
                            }
                        }
                    }
                }
                if (retry) continue;
                if (oldKey != null) {
                    this.basicRemoveMapping(oldKey, re, false);
                }
                if (!IndexManager.isObjectModificationInplace()) continue;
                this.entryToValuesMap.put(re, indexKey);
            } while (retry);
        }
        catch (TypeMismatchException ex) {
            throw new IMQException("Could not add object of type " + indexKey.getClass().getName(), ex);
        }
        this.internalIndexStats.incNumValues(1);
    }

    private Object getOldKey(Object newKey, RegionEntry entry) throws TypeMismatchException {
        for (Map.Entry mapEntry : this.valueToEntriesMap.entrySet()) {
            Collection coll;
            Object regionEntries = mapEntry.getValue();
            Object indexKey = mapEntry.getKey();
            if (!TypeUtils.compare(indexKey, newKey, 20).equals(Boolean.TRUE)) continue;
            if (regionEntries instanceof RegionEntry && regionEntries.equals(entry)) {
                return indexKey;
            }
            if (!(regionEntries instanceof Collection) || !(coll = (Collection)regionEntries).contains(entry)) continue;
            return indexKey;
        }
        return newKey;
    }

    @Override
    public void addMapping(Object indexKey, RegionEntry re) throws IMQException {
        this.updateMapping(indexKey, null, re, null);
    }

    @Override
    public void removeMapping(Object indexKey, RegionEntry re) throws IMQException {
        boolean found = this.basicRemoveMapping(indexKey, re, true);
        if (found && IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap.remove(re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean basicRemoveMapping(Object key, RegionEntry entry, boolean findOldKey) throws IMQException {
        boolean found = false;
        boolean possiblyAlreadyRemoved = false;
        try {
            Object newKey = this.convertToIndexKey(key, entry);
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.ATTEMPT_REMOVE, null, null);
            }
            boolean retry = false;
            do {
                retry = false;
                Object regionEntries = this.valueToEntriesMap.get(newKey);
                if (regionEntries == this.TRANSITIONING_TOKEN) {
                    if (DefaultQuery.testHook != null) {
                        DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.ATTEMPT_RETRY, null, null);
                    }
                    retry = true;
                    continue;
                }
                if (regionEntries == null) continue;
                if (regionEntries instanceof RegionEntry) {
                    boolean bl = found = regionEntries == entry;
                    if (!found) continue;
                    if (this.valueToEntriesMap.remove(newKey, regionEntries)) {
                        this.numIndexKeys.decrementAndGet();
                        this.internalIndexStats.incNumKeys(-1L);
                        continue;
                    }
                    retry = true;
                    continue;
                }
                Collection entries = (Collection)regionEntries;
                if (DefaultQuery.testHook != null) {
                    DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.BEGIN_REMOVE_FROM_ELEM_ARRAY, null, null);
                }
                found = entries.remove(entry);
                if (DefaultQuery.testHook != null) {
                    DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.REMOVE_CALLED_FROM_ELEM_ARRAY, null, null);
                }
                if (entries instanceof IndexElemArray && !this.valueToEntriesMap.replace(newKey, entries, entries)) {
                    retry = true;
                    possiblyAlreadyRemoved = found;
                    continue;
                }
                if (entries.isEmpty()) {
                    Collection collection = entries;
                    synchronized (collection) {
                        if (entries.isEmpty() && this.valueToEntriesMap.remove(newKey, entries)) {
                            this.numIndexKeys.decrementAndGet();
                            this.internalIndexStats.incNumKeys(-1L);
                        }
                    }
                }
                if (DefaultQuery.testHook == null) continue;
                DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.COMPLETE_REMOVE_FROM_ELEM_ARRAY, null, null);
            } while (retry);
        }
        catch (TypeMismatchException ex) {
            throw new IMQException("Could not add object of type " + key.getClass().getName(), ex);
        }
        if (found) {
            this.internalIndexStats.incNumValues(-1);
        } else if (!found && !possiblyAlreadyRemoved && !IndexManager.isObjectModificationInplace() && key != null && findOldKey) {
            try {
                Object oldKey = this.getOldKey(key, entry);
                found = this.basicRemoveMapping(oldKey, entry, false);
            }
            catch (TypeMismatchException e) {
                throw new IMQException("Could not find old key: " + key.getClass().getName(), e);
            }
        }
        return found;
    }

    private Object convertToIndexKey(Object key, RegionEntry entry) throws TypeMismatchException {
        Object newKey = IndexManager.isObjectModificationInplace() && this.entryToValuesMap.containsKey(entry) ? this.entryToValuesMap.get(entry) : TypeUtils.indexKeyFor(key);
        return newKey;
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> get(Object indexKey) {
        return new MemoryIndexStoreIterator(this.valueToEntriesMap.subMap(indexKey, true, indexKey, true), indexKey, null);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Object start, boolean startInclusive, Object end, boolean endInclusive, Collection keysToRemove) {
        if (start == null) {
            return new MemoryIndexStoreIterator(this.valueToEntriesMap.headMap(end, endInclusive), null, keysToRemove);
        }
        return new MemoryIndexStoreIterator(this.valueToEntriesMap.subMap(start, startInclusive, end, endInclusive), null, keysToRemove);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Object start, boolean startInclusive, Collection keysToRemove) {
        return new MemoryIndexStoreIterator(this.valueToEntriesMap.tailMap(start, startInclusive), null, keysToRemove);
    }

    public Iterator<IndexStore.IndexStoreEntry> getKeysIterator() {
        return new MemoryIndexStoreKeyIterator(this.valueToEntriesMap);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Collection keysToRemove) {
        return new MemoryIndexStoreIterator(this.valueToEntriesMap, null, keysToRemove);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator(Object start, boolean startInclusive, Object end, boolean endInclusive, Collection keysToRemove) {
        if (start == null) {
            return new MemoryIndexStoreIterator(this.valueToEntriesMap.headMap(end, endInclusive).descendingMap(), null, keysToRemove);
        }
        return new MemoryIndexStoreIterator(this.valueToEntriesMap.subMap(start, startInclusive, end, endInclusive).descendingMap(), null, keysToRemove);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator(Object start, boolean startInclusive, Collection keysToRemove) {
        return new MemoryIndexStoreIterator(this.valueToEntriesMap.tailMap(start, startInclusive).descendingMap(), null, keysToRemove);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator(Collection keysToRemove) {
        return new MemoryIndexStoreIterator(this.valueToEntriesMap.descendingMap(), null, keysToRemove);
    }

    @Override
    public boolean isIndexOnRegionKeys() {
        return this.indexOnRegionKeys;
    }

    @Override
    public void setIndexOnRegionKeys(boolean indexOnRegionKeys) {
        this.indexOnRegionKeys = indexOnRegionKeys;
    }

    @Override
    public boolean isIndexOnValues() {
        return this.indexOnValues;
    }

    @Override
    public void setIndexOnValues(boolean indexOnValues) {
        this.indexOnValues = indexOnValues;
    }

    @Override
    public Object getTargetObject(RegionEntry entry) {
        if (this.indexOnValues) {
            Object o = entry.getValue((LocalRegion)this.region);
            try {
                if (o == Token.INVALID) {
                    return null;
                }
                if (o instanceof CachedDeserializable) {
                    return ((CachedDeserializable)o).getDeserializedValue(this.region, entry);
                }
            }
            catch (EntryDestroyedException ignore) {
                return null;
            }
            return o;
        }
        if (this.indexOnRegionKeys) {
            return entry.getKey();
        }
        return new CachedEntryWrapper(new NonTXEntry((LocalRegion)this.region, entry));
    }

    @Override
    public Object getTargetObjectInVM(RegionEntry entry) {
        if (this.indexOnValues) {
            Object o = entry.getValueInVM((LocalRegion)this.region);
            try {
                if (o == Token.INVALID) {
                    return null;
                }
                if (o instanceof CachedDeserializable) {
                    return ((CachedDeserializable)o).getDeserializedValue(this.region, entry);
                }
            }
            catch (EntryDestroyedException ede) {
                return null;
            }
            return o;
        }
        if (this.indexOnRegionKeys) {
            return entry.getKey();
        }
        return new NonTXEntry((LocalRegion)this.region, entry);
    }

    private Object getTargetObjectForUpdate(RegionEntry entry) {
        if (this.indexOnValues) {
            Object o = entry.getValue((LocalRegion)this.region);
            try {
                if (o == Token.INVALID) {
                    return Token.INVALID;
                }
                if (o instanceof CachedDeserializable) {
                    return ((CachedDeserializable)o).getDeserializedValue(this.region, entry);
                }
            }
            catch (EntryDestroyedException ede) {
                return Token.INVALID;
            }
            return o;
        }
        if (this.indexOnRegionKeys) {
            return entry.getKey();
        }
        return new NonTXEntry((LocalRegion)this.region, entry);
    }

    @Override
    public boolean clear() {
        this.valueToEntriesMap.clear();
        if (IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap.clear();
        }
        this.numIndexKeys.set(0);
        return true;
    }

    @Override
    public int size(Object key) {
        Object obj = this.valueToEntriesMap.get(key);
        if (obj != null) {
            return obj instanceof RegionEntry ? 1 : ((Collection)obj).size();
        }
        return 0;
    }

    @Override
    public int size() {
        return this.numIndexKeys.get();
    }

    @Override
    public String printAll() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry mapEntry : this.valueToEntriesMap.entrySet()) {
            sb.append("Key: " + mapEntry.getKey());
            Object value = mapEntry.getValue();
            if (value instanceof Collection) {
                Iterator entriesIterator = ((Collection)value).iterator();
                while (entriesIterator.hasNext()) {
                    sb.append(" Value:" + this.getTargetObject((RegionEntry)entriesIterator.next()));
                }
            } else {
                sb.append(" Value:" + this.getTargetObject((RegionEntry)value));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    class CachedEntryWrapper {
        private Object key;
        private Object value;

        public CachedEntryWrapper(NonTXEntry entry) {
            if (IndexManager.testHook != null) {
                IndexManager.testHook.hook(201);
            }
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "CachedEntryWrapper@" + Integer.toHexString(System.identityHashCode(this)) + ' ' + this.key + ' ' + this.value;
        }
    }

    class MemoryIndexStoreEntry
    implements IndexStore.IndexStoreEntry {
        private Object deserializedIndexKey;
        private RegionEntry regionEntry;
        private boolean updateInProgress;
        private Object value;
        private long iteratorStartTime;

        private MemoryIndexStoreEntry(long iteratorStartTime) {
            this.iteratorStartTime = iteratorStartTime;
        }

        public void setMemoryIndexStoreEntry(Object deserializedIndexKey, RegionEntry regionEntry) {
            this.deserializedIndexKey = deserializedIndexKey;
            this.regionEntry = regionEntry;
            this.updateInProgress = regionEntry.isUpdateInProgress();
            this.value = MemoryIndexStore.this.getTargetObject(regionEntry);
        }

        @Override
        public Object getDeserializedKey() {
            return this.deserializedIndexKey;
        }

        @Override
        public Object getDeserializedValue() {
            return this.value;
        }

        @Override
        public Object getDeserializedRegionKey() {
            return this.regionEntry.getKey();
        }

        public RegionEntry getRegionEntry() {
            return this.regionEntry;
        }

        @Override
        public boolean isUpdateInProgress() {
            return this.updateInProgress || this.regionEntry.isUpdateInProgress() || IndexManager.needsRecalculation(this.iteratorStartTime, this.regionEntry.getLastModified());
        }
    }

    class MemoryIndexStoreKey
    implements IndexStore.IndexStoreEntry {
        private Object indexKey;

        public MemoryIndexStoreKey(Object indexKey) {
            this.indexKey = indexKey;
        }

        @Override
        public Object getDeserializedKey() {
            return this.indexKey;
        }

        @Override
        public Object getDeserializedValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getDeserializedRegionKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isUpdateInProgress() {
            throw new UnsupportedOperationException();
        }
    }

    private class MemoryIndexStoreIterator
    implements CloseableIterator<IndexStore.IndexStoreEntry> {
        final Map map;
        Object indexKey;
        Collection keysToRemove;
        Iterator<Map.Entry> mapIterator;
        Iterator valuesIterator;
        Object currKey;
        Object currValue;
        final long iteratorStartTime;
        MemoryIndexStoreEntry currentEntry;

        MemoryIndexStoreIterator(Map submap, Object indexKey, Collection keysToRemove) {
            this(submap, indexKey, keysToRemove, memoryIndexStore.cache.cacheTimeMillis());
        }

        private MemoryIndexStoreIterator(Map submap, Object indexKey, Collection keysToRemove, long iteratorStartTime) {
            this.map = submap;
            this.indexKey = indexKey;
            this.keysToRemove = keysToRemove == null ? null : new HashSet(keysToRemove);
            this.iteratorStartTime = iteratorStartTime;
            this.currentEntry = new MemoryIndexStoreEntry(iteratorStartTime);
        }

        @Override
        public boolean hasNext() {
            if (this.valuesIterator != null && this.valuesIterator.hasNext()) {
                return true;
            }
            if (this.mapIterator == null) {
                this.mapIterator = this.map.entrySet().iterator();
            }
            if (this.mapIterator.hasNext()) {
                Map.Entry currentMapEntry = this.mapIterator.next();
                this.currKey = currentMapEntry.getKey();
                if (this.currKey != this.indexKey && (this.currKey == QueryService.UNDEFINED || this.currKey == IndexManager.NULL || this.keysToRemove != null && this.removeFromKeysToRemove(this.keysToRemove, this.currKey))) {
                    return this.hasNext();
                }
                Object values = currentMapEntry.getValue();
                if (values instanceof Collection) {
                    this.valuesIterator = ((Collection)values).iterator();
                } else {
                    this.valuesIterator = null;
                    this.currValue = values;
                }
                return values != null && (values instanceof RegionEntry || this.valuesIterator.hasNext());
            }
            this.currKey = null;
            return false;
        }

        @Override
        public MemoryIndexStoreEntry next() {
            if (this.valuesIterator == null) {
                this.currentEntry.setMemoryIndexStoreEntry(this.currKey, (RegionEntry)this.currValue);
                return this.currentEntry;
            }
            RegionEntry re = (RegionEntry)this.valuesIterator.next();
            if (re == null) {
                throw new NoSuchElementException();
            }
            this.currentEntry.setMemoryIndexStoreEntry(this.currKey, re);
            return this.currentEntry;
        }

        @Override
        public void remove() {
            this.mapIterator.remove();
        }

        @Override
        public void close() {
        }

        public boolean removeFromKeysToRemove(Collection keysToRemove, Object key) {
            Iterator iterator = keysToRemove.iterator();
            while (iterator.hasNext()) {
                try {
                    if (!TypeUtils.compare(key, iterator.next(), 13).equals(Boolean.TRUE)) continue;
                    iterator.remove();
                    return true;
                }
                catch (TypeMismatchException typeMismatchException) {
                }
            }
            return false;
        }
    }

    private class MemoryIndexStoreKeyIterator
    implements Iterator<IndexStore.IndexStoreEntry> {
        private final Map valuesToEntriesMap;
        private Object currKey;
        private Iterator<Map.Entry> mapIterator;

        public MemoryIndexStoreKeyIterator(Map valuesToEntriesMap) {
            this.valuesToEntriesMap = valuesToEntriesMap;
        }

        @Override
        public boolean hasNext() {
            if (this.mapIterator == null) {
                this.mapIterator = this.valuesToEntriesMap.entrySet().iterator();
            }
            if (this.mapIterator.hasNext()) {
                Map.Entry currentEntry = this.mapIterator.next();
                this.currKey = currentEntry.getKey();
                if (this.currKey == IndexManager.NULL || this.currKey == QueryService.UNDEFINED) {
                    return this.hasNext();
                }
                return this.currKey != null;
            }
            return false;
        }

        @Override
        public MemoryIndexStoreKey next() {
            return new MemoryIndexStoreKey(this.currKey);
        }
    }
}

