/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package org.apache.geode.internal.admin;

import org.apache.geode.admin.GemFireHealth;

/**
 * Interface for those who want to be alerted of a change in a GemFireVM's health.
 *
 * @see org.apache.geode.admin.GemFireHealthConfig
 *
 * @since GemFire 3.5
 */
public interface HealthListener {

  /**
   * Called by a GemFireVM whenever a health status change is detected.
   *
   * @param member The member whose health has changed
   * @param status the new health status
   */
  void healthChanged(GemFireVM member, GemFireHealth.Health status);

}
