/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.functions.ImportDataFunction;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ImportDataCommand
extends GfshCommand {
    private final ImportDataFunction importDataFunction = new ImportDataFunction();

    @CliCommand(value={"import data"}, help="Import user data from a file to a region.")
    @CliMetaData(relatedTopic={"Data", "Region"})
    public ResultModel importData(@CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", mandatory=true, help="Region into which data will be imported.") String regionName, @CliOption(key={"file"}, help="File from which the imported data will be read. The file must have an extension of \".gfd\". Cannot be specified at the same time as \"dir\"") String filePath, @CliOption(key={"dir"}, help="Directory from which all data files (\".gfd\") will be read. Required if parallel set to true. Cannot be specified at the same time as \"file\"") String dirPath, @CliOption(key={"member"}, mandatory=true, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of a member which hosts the region. The data will be imported from the specified file on the host where the member is running.") String memberNameOrId, @CliOption(key={"invoke-callbacks"}, unspecifiedDefaultValue="false", help="Whether callbacks should be invoked") boolean invokeCallbacks, @CliOption(key={"parallel"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Import data from given directory on all members. Used to import data from a parallel export. Available for partitioned regions only") boolean parallel) {
        ResultModel result;
        this.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
        DistributedMember targetMember = this.getMember(memberNameOrId);
        Optional<ResultModel> validationResult = this.validatePath(filePath, dirPath, parallel);
        if (validationResult.isPresent()) {
            return validationResult.get();
        }
        try {
            String path = dirPath != null ? dirPath : filePath;
            Object[] args = new Object[]{regionName, path, invokeCallbacks, parallel};
            ResultCollector<?, ?> rc = this.executeFunction((Function)this.importDataFunction, (Object)args, targetMember);
            result = ResultModel.createMemberStatusResult((List)rc.getResult());
        }
        catch (CacheClosedException e) {
            result = ResultModel.createError(e.getMessage());
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultModel.createError(CliStrings.format((String)"Error occurred while executing : {0}", (Object)"import data"));
        }
        return result;
    }

    private Optional<ResultModel> validatePath(String filePath, String dirPath, boolean parallel) {
        if (filePath == null && dirPath == null) {
            return Optional.of(ResultModel.createError("Must specify a location to load snapshot from"));
        }
        if (filePath != null && dirPath != null) {
            return Optional.of(ResultModel.createError("Options \"file\" and \"dir\" cannot be specified at the same time"));
        }
        if (parallel && dirPath == null) {
            return Optional.of(ResultModel.createError("Must specify a directory to load snapshot files from"));
        }
        if (dirPath == null && !filePath.endsWith(".gfd")) {
            return Optional.of(ResultModel.createError(CliStrings.format((String)"Invalid file type, the file extension must be \"{0}\"", (Object)".gfd")));
        }
        return Optional.empty();
    }
}

