/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.geode.connectors.jdbc.internal.ColumnData;
import org.apache.geode.connectors.jdbc.internal.EntryColumnData;

class SqlStatementFactory {
    private final String quote;

    public SqlStatementFactory(String identifierQuoteString) {
        this.quote = identifierQuoteString;
    }

    String createSelectQueryString(String quotedTablePath, EntryColumnData entryColumnData) {
        return this.addKeyColumnsToQuery(entryColumnData, new StringBuilder("SELECT * FROM ").append(quotedTablePath));
    }

    String createDestroySqlString(String quotedTablePath, EntryColumnData entryColumnData) {
        return this.addKeyColumnsToQuery(entryColumnData, new StringBuilder("DELETE FROM ").append(quotedTablePath));
    }

    private String addKeyColumnsToQuery(EntryColumnData entryColumnData, StringBuilder queryBuilder) {
        queryBuilder.append(" WHERE ");
        Iterator<ColumnData> iterator = entryColumnData.getEntryKeyColumnData().iterator();
        while (iterator.hasNext()) {
            ColumnData keyColumn = iterator.next();
            boolean onLastColumn = !iterator.hasNext();
            queryBuilder.append(this.quote).append(keyColumn.getColumnName()).append(this.quote).append(" = ?");
            if (onLastColumn) continue;
            queryBuilder.append(" AND ");
        }
        return queryBuilder.toString();
    }

    String createUpdateSqlString(String quotedTablePath, EntryColumnData entryColumnData) {
        StringBuilder query = new StringBuilder("UPDATE ").append(quotedTablePath).append(" SET ");
        int idx = 0;
        for (ColumnData column : entryColumnData.getEntryValueColumnData()) {
            if (++idx > 1) {
                query.append(", ");
            }
            query.append(this.quote).append(column.getColumnName()).append(this.quote);
            query.append(" = ?");
        }
        return this.addKeyColumnsToQuery(entryColumnData, query);
    }

    String createInsertSqlString(String quotedTablePath, EntryColumnData entryColumnData) {
        StringBuilder columnNames = new StringBuilder("INSERT INTO ").append(quotedTablePath).append(" (");
        StringBuilder columnValues = new StringBuilder(" VALUES (");
        this.addColumnDataToSqlString(entryColumnData, columnNames, columnValues);
        columnNames.append(')');
        columnValues.append(')');
        return columnNames.append((CharSequence)columnValues).toString();
    }

    private void addColumnDataToSqlString(EntryColumnData entryColumnData, StringBuilder columnNames, StringBuilder columnValues) {
        Stream values = entryColumnData.getEntryValueColumnData().stream();
        Stream keys = entryColumnData.getEntryKeyColumnData().stream();
        Stream columnDataStream = Stream.concat(values, keys);
        boolean[] firstTime = new boolean[]{true};
        columnDataStream.forEachOrdered(column -> {
            if (!firstTime[0]) {
                columnNames.append(',');
                columnValues.append(',');
            } else {
                firstTime[0] = false;
            }
            columnNames.append(this.quote).append(column.getColumnName()).append(this.quote);
            columnValues.append('?');
        });
    }
}

