/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class BitPosExecutor
extends StringExecutor {
    private final String ERROR_NOT_INT = "The numbers provided must be numeric values";
    private final String ERROR_BIT = "The bit must either be a 0 or 1";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int bit;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the BITOPS command is \"BITPOS key bit [start] [end]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper string = (ByteArrayWrapper)r.get((Object)key);
        int bitPosition = -1;
        boolean endSet = false;
        try {
            byte[] bitAr = commandElems.get(2);
            bit = Coder.bytesToInt(bitAr);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The numbers provided must be numeric values"));
            return;
        }
        if (bit != 0 && bit != 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The bit must either be a 0 or 1"));
            return;
        }
        if (string == null || string.length() == 0) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), -bit));
            return;
        }
        byte[] bytes = string.toBytes();
        int start = 0;
        int end = bytes.length - 1;
        if (commandElems.size() > 3) {
            try {
                byte[] startAr = commandElems.get(3);
                start = Coder.bytesToInt(startAr);
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The numbers provided must be numeric values"));
                return;
            }
        }
        if (commandElems.size() > 4) {
            try {
                byte[] endAr = commandElems.get(4);
                end = Coder.bytesToInt(endAr);
                endSet = true;
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The numbers provided must be numeric values"));
                return;
            }
        }
        if (start < 0) {
            start += bytes.length;
        }
        if (end < 0) {
            end += bytes.length;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start > bytes.length) {
            start = bytes.length - 1;
        }
        if (end > bytes.length) {
            end = bytes.length - 1;
        }
        if (end < start) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), -1));
            return;
        }
        block6: for (int i = start; i <= end; ++i) {
            byte cByte = bytes[i];
            for (int j = 0; j < 8; ++j) {
                int cBit = (cByte & 128 >> j) >> 7 - j;
                if (cBit != bit) continue;
                bitPosition = 8 * i + j;
                break block6;
            }
        }
        if (bit == 0 && bitPosition == -1 && !endSet) {
            bitPosition = bytes.length * 8;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), bitPosition));
    }
}

