/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.set.SInterExecutor;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public abstract class SetOpExecutor
extends SetExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int setsStartIndex;
        List<byte[]> commandElems = command.getProcessedCommand();
        int n = setsStartIndex = this.isStorage() ? 2 : 1;
        if (commandElems.size() < setsStartIndex + 1) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        RegionProvider rC = context.getRegionProvider();
        ByteArrayWrapper destination = null;
        if (this.isStorage()) {
            destination = command.getKey();
        }
        ByteArrayWrapper firstSetKey = new ByteArrayWrapper(commandElems.get(setsStartIndex++));
        if (!this.isStorage()) {
            this.checkDataType(firstSetKey, RedisDataType.REDIS_SET, context);
        }
        Region<?, ?> region = rC.getRegion(firstSetKey);
        HashSet<ByteArrayWrapper> firstSet = null;
        if (region != null) {
            firstSet = new HashSet<ByteArrayWrapper>(region.keySet());
        }
        ArrayList<Set<ByteArrayWrapper>> setList = new ArrayList<Set<ByteArrayWrapper>>();
        for (int i = setsStartIndex; i < commandElems.size(); ++i) {
            ByteArrayWrapper key = new ByteArrayWrapper(commandElems.get(i));
            this.checkDataType(key, RedisDataType.REDIS_SET, context);
            region = rC.getRegion(key);
            if (region != null) {
                setList.add(region.keySet());
                continue;
            }
            if (!(this instanceof SInterExecutor)) continue;
            setList.add(null);
        }
        if (setList.isEmpty()) {
            if (this.isStorage()) {
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
                context.getRegionProvider().removeKey(destination);
            } else {
                this.respondBulkStrings(command, context, firstSet);
            }
            return;
        }
        Set<ByteArrayWrapper> resultSet = this.setOp(firstSet, setList);
        if (this.isStorage()) {
            Region<?, ?> newRegion = null;
            rC.removeKey(destination);
            if (resultSet != null) {
                HashMap<ByteArrayWrapper, Boolean> map = new HashMap<ByteArrayWrapper, Boolean>();
                for (ByteArrayWrapper entry : resultSet) {
                    map.put(entry, Boolean.TRUE);
                }
                if (!map.isEmpty()) {
                    newRegion = rC.getOrCreateRegion(destination, RedisDataType.REDIS_SET, context);
                    newRegion.putAll(map);
                }
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), resultSet.size()));
            } else {
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            }
        } else if (resultSet == null || resultSet.isEmpty()) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            this.respondBulkStrings(command, context, resultSet);
        }
    }

    protected abstract boolean isStorage();

    protected abstract Set<ByteArrayWrapper> setOp(Set<ByteArrayWrapper> var1, List<Set<ByteArrayWrapper>> var2);
}

