/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.list.ListExecutor;
import org.apache.geode.redis.internal.executor.list.PushXExecutor;

public abstract class PushExecutor
extends PushXExecutor
implements Extendable {
    private final int START_VALUES_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<Integer, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_LIST);
        this.pushElements(key, commandElems, 2, commandElems.size(), keyRegion, this.pushType(), context);
        int listSize = keyRegion.size() - 2;
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), listSize));
    }

    @Override
    protected abstract ListExecutor.ListDirection pushType();
}

