/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Executor;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RegionProvider;

public abstract class AbstractExecutor
implements Executor {
    public static final int NUM_DEFAULT_REGIONS = 3;
    protected static final Integer INFINITY_LIMIT = Integer.MAX_VALUE;
    protected static final int millisInSecond = 1000;

    protected Region<?, ?> getOrCreateRegion(ExecutionHandlerContext context, ByteArrayWrapper key, RedisDataType type) {
        return context.getRegionProvider().getOrCreateRegion(key, type, context);
    }

    protected void checkDataType(ByteArrayWrapper key, RedisDataType expectedDataType, ExecutionHandlerContext context) {
        context.getKeyRegistrar().validate(key, expectedDataType);
    }

    protected Query getQuery(ByteArrayWrapper key, Enum<?> type, ExecutionHandlerContext context) {
        return context.getRegionProvider().getQuery(key, type);
    }

    protected boolean removeEntry(ByteArrayWrapper key, RedisDataType type, ExecutionHandlerContext context) {
        if (type == null || type == RedisDataType.REDIS_PROTECTED) {
            return false;
        }
        RegionProvider rC = context.getRegionProvider();
        return rC.removeKey(key, type);
    }

    protected int getBoundedStartIndex(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size < 0, really?");
        }
        if (index >= 0) {
            return Math.min(index, size);
        }
        return Math.max(index + size, 0);
    }

    protected int getBoundedEndIndex(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size < 0, really?");
        }
        if (index >= 0) {
            return Math.min(index, size);
        }
        return Math.max(index + size, -1);
    }

    protected long getBoundedStartIndex(long index, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size < 0, really?");
        }
        if (index >= 0L) {
            return Math.min(index, size);
        }
        return Math.max(index + size, 0L);
    }

    protected long getBoundedEndIndex(long index, long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size < 0, really?");
        }
        if (index >= 0L) {
            return Math.min(index, size);
        }
        return Math.max(index + size, -1L);
    }

    protected void respondBulkStrings(Command command, ExecutionHandlerContext context, Object message) {
        ByteBuf rsp;
        try {
            rsp = message instanceof Collection ? Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), (Collection)message) : Coder.getBulkStringResponse(context.getByteBufAllocator(), message);
        }
        catch (CoderException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The server had an internal error please try again"));
            return;
        }
        command.setResponse(rsp);
    }
}

