/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.geode.annotations.internal.MakeImmutable;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.DoubleWrapper;

public class Coder {
    public static final byte BULK_STRING_ID = 36;
    public static final byte ARRAY_ID = 42;
    public static final byte ERROR_ID = 45;
    public static final byte INTEGER_ID = 58;
    public static final byte OPEN_BRACE_ID = 40;
    public static final byte OPEN_BRACKET_ID = 91;
    public static final byte HYPHEN_ID = 45;
    public static final byte PLUS_ID = 43;
    public static final byte NUMBER_1_BYTE = 49;
    public static final byte SIMPLE_STRING_ID = 43;
    public static final String CRLF = "\r\n";
    @MakeImmutable
    public static final byte[] CRLFar = Coder.stringToBytes("\r\n");
    @MakeImmutable
    public static final byte[] bNIL = Coder.stringToBytes("$-1\r\n");
    @MakeImmutable
    public static final byte[] bEMPTY_ARRAY = Coder.stringToBytes("*0\r\n");
    @MakeImmutable
    public static final byte[] err = Coder.stringToBytes("ERR ");
    @MakeImmutable
    public static final byte[] noAuth = Coder.stringToBytes("NOAUTH ");
    @MakeImmutable
    public static final byte[] wrongType = Coder.stringToBytes("WRONGTYPE ");
    public static final String CHARSET = "UTF-8";
    @MakeImmutable
    protected static final DecimalFormat decimalFormatter = new DecimalFormat("#");
    public static final String P_INF = "+inf";
    public static final String N_INF = "-inf";

    public static ByteBuf getBulkStringResponse(ByteBufAllocator alloc, Object v) throws CoderException {
        byte[] toWrite;
        ByteBuf response;
        if (v == null) {
            ByteBuf response2 = alloc.buffer();
            response2.writeBytes(bNIL);
            return response2;
        }
        if (v instanceof byte[]) {
            byte[] value = (byte[])v;
            response = alloc.buffer(value.length + 20);
            toWrite = value;
        } else if (v instanceof ByteArrayWrapper) {
            byte[] value = ((ByteArrayWrapper)v).toBytes();
            response = alloc.buffer(value.length + 20);
            toWrite = value;
        } else if (v instanceof Double) {
            response = alloc.buffer();
            toWrite = Coder.doubleToBytes((Double)v);
        } else if (v instanceof String) {
            String value = (String)v;
            response = alloc.buffer(value.length() + 20);
            toWrite = Coder.stringToBytes(value);
        } else {
            throw new CoderException();
        }
        response.writeByte(36);
        response.writeBytes(Coder.intToBytes(toWrite.length));
        response.writeBytes(CRLFar);
        response.writeBytes(toWrite);
        response.writeBytes(CRLFar);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf getBulkStringArrayResponse(ByteBufAllocator alloc, Collection<?> items) throws CoderException {
        ByteBuf response = alloc.buffer();
        response.writeByte(42);
        response.writeBytes(Coder.intToBytes(items.size()));
        response.writeBytes(CRLFar);
        for (Object next : items) {
            ReferenceCounted tmp = null;
            try {
                if (next instanceof Collection) {
                    Collection nextItems = (Collection)next;
                    tmp = Coder.getBulkStringArrayResponse(alloc, nextItems);
                    response.writeBytes((ByteBuf)tmp);
                    continue;
                }
                tmp = Coder.getBulkStringResponse(alloc, next);
                response.writeBytes((ByteBuf)tmp);
            }
            finally {
                if (tmp == null) continue;
                tmp.release();
            }
        }
        return response;
    }

    public static ByteBuf getKeyValArrayResponse(ByteBufAllocator alloc, Collection<Map.Entry<ByteArrayWrapper, ByteArrayWrapper>> items) {
        ByteBuf response = alloc.buffer();
        response.writeByte(42);
        int size = 0;
        ByteBuf tmp = alloc.buffer();
        for (Map.Entry<ByteArrayWrapper, ByteArrayWrapper> next : items) {
            byte[] nextByteArray;
            byte[] key;
            try {
                key = next.getKey().toBytes();
                nextByteArray = next.getValue().toBytes();
            }
            catch (EntryDestroyedException e) {
                continue;
            }
            tmp.writeByte(36);
            tmp.writeBytes(Coder.intToBytes(key.length));
            tmp.writeBytes(CRLFar);
            tmp.writeBytes(key);
            tmp.writeBytes(CRLFar);
            tmp.writeByte(36);
            tmp.writeBytes(Coder.intToBytes(nextByteArray.length));
            tmp.writeBytes(CRLFar);
            tmp.writeBytes(nextByteArray);
            tmp.writeBytes(CRLFar);
            ++size;
        }
        response.writeBytes(Coder.intToBytes(size * 2));
        response.writeBytes(CRLFar);
        response.writeBytes(tmp);
        tmp.release();
        return response;
    }

    public static ByteBuf getScanResponse(ByteBufAllocator alloc, List<?> items) {
        ByteBuf response = alloc.buffer();
        response.writeByte(42);
        response.writeBytes(Coder.intToBytes(2));
        response.writeBytes(CRLFar);
        response.writeByte(36);
        byte[] cursor = Coder.stringToBytes((String)items.get(0));
        response.writeBytes(Coder.intToBytes(cursor.length));
        response.writeBytes(CRLFar);
        response.writeBytes(cursor);
        response.writeBytes(CRLFar);
        items = items.subList(1, items.size());
        response.writeByte(42);
        response.writeBytes(Coder.intToBytes(items.size()));
        response.writeBytes(CRLFar);
        for (Object nextObject : items) {
            Object next;
            if (nextObject instanceof String) {
                next = (String)nextObject;
                response.writeByte(36);
                response.writeBytes(Coder.intToBytes(((String)next).length()));
                response.writeBytes(CRLFar);
                response.writeBytes(Coder.stringToBytes((String)next));
                response.writeBytes(CRLFar);
                continue;
            }
            if (!(nextObject instanceof ByteArrayWrapper)) continue;
            next = ((ByteArrayWrapper)nextObject).toBytes();
            response.writeByte(36);
            response.writeBytes(Coder.intToBytes(((Object)next).length));
            response.writeBytes(CRLFar);
            response.writeBytes((byte[])next);
            response.writeBytes(CRLFar);
        }
        return response;
    }

    public static ByteBuf getEmptyArrayResponse(ByteBufAllocator alloc) {
        ByteBuf buf = alloc.buffer().writeBytes(bEMPTY_ARRAY);
        return buf;
    }

    public static ByteBuf getSimpleStringResponse(ByteBufAllocator alloc, String string) {
        byte[] simpAr = Coder.stringToBytes(string);
        ByteBuf response = alloc.buffer(simpAr.length + 20);
        response.writeByte(43);
        response.writeBytes(simpAr);
        response.writeBytes(CRLFar);
        return response;
    }

    public static ByteBuf getErrorResponse(ByteBufAllocator alloc, String error) {
        byte[] errorAr = Coder.stringToBytes(error);
        ByteBuf response = alloc.buffer(errorAr.length + 25);
        response.writeByte(45);
        response.writeBytes(err);
        response.writeBytes(errorAr);
        response.writeBytes(CRLFar);
        return response;
    }

    public static ByteBuf getNoAuthResponse(ByteBufAllocator alloc, String error) {
        byte[] errorAr = Coder.stringToBytes(error);
        ByteBuf response = alloc.buffer(errorAr.length + 25);
        response.writeByte(45);
        response.writeBytes(noAuth);
        response.writeBytes(errorAr);
        response.writeBytes(CRLFar);
        return response;
    }

    public static ByteBuf getWrongTypeResponse(ByteBufAllocator alloc, String error) {
        byte[] errorAr = Coder.stringToBytes(error);
        ByteBuf response = alloc.buffer(errorAr.length + 31);
        response.writeByte(45);
        response.writeBytes(wrongType);
        response.writeBytes(errorAr);
        response.writeBytes(CRLFar);
        return response;
    }

    public static ByteBuf getIntegerResponse(ByteBufAllocator alloc, int integer) {
        ByteBuf response = alloc.buffer(15);
        response.writeByte(58);
        response.writeBytes(Coder.intToBytes(integer));
        response.writeBytes(CRLFar);
        return response;
    }

    public static ByteBuf getIntegerResponse(ByteBufAllocator alloc, long l) {
        ByteBuf response = alloc.buffer(25);
        response.writeByte(58);
        response.writeBytes(Coder.longToBytes(l));
        response.writeBytes(CRLFar);
        return response;
    }

    public static ByteBuf getNilResponse(ByteBufAllocator alloc) {
        ByteBuf buf = alloc.buffer().writeBytes(bNIL);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf getBulkStringArrayResponseOfValues(ByteBufAllocator alloc, Collection<?> items) {
        ByteBuf response = alloc.buffer();
        response.writeByte(42);
        ByteBuf tmp = alloc.buffer();
        int size = 0;
        try {
            for (Object next : items) {
                ByteArrayWrapper nextWrapper;
                block10: {
                    nextWrapper = null;
                    if (next instanceof Map.Entry) {
                        try {
                            nextWrapper = (ByteArrayWrapper)((Map.Entry)next).getValue();
                            break block10;
                        }
                        catch (EntryDestroyedException e) {
                            continue;
                        }
                    }
                    if (next instanceof Struct) {
                        nextWrapper = (ByteArrayWrapper)((Struct)next).getFieldValues()[1];
                    }
                }
                if (nextWrapper != null) {
                    tmp.writeByte(36);
                    tmp.writeBytes(Coder.intToBytes(nextWrapper.length()));
                    tmp.writeBytes(CRLFar);
                    tmp.writeBytes(nextWrapper.toBytes());
                    tmp.writeBytes(CRLFar);
                } else {
                    tmp.writeBytes(bNIL);
                }
                ++size;
            }
            response.writeBytes(Coder.intToBytes(size));
            response.writeBytes(CRLFar);
            response.writeBytes(tmp);
        }
        finally {
            tmp.release();
        }
        return response;
    }

    public static ByteBuf zRangeResponse(ByteBufAllocator alloc, Collection<?> list, boolean withScores) {
        if (list.isEmpty()) {
            return Coder.getEmptyArrayResponse(alloc);
        }
        ByteBuf buffer = alloc.buffer();
        buffer.writeByte(42);
        ByteBuf tmp = alloc.buffer();
        int size = 0;
        for (Object entry : list) {
            DoubleWrapper score;
            ByteArrayWrapper key;
            block5: {
                if (entry instanceof Map.Entry) {
                    try {
                        key = (ByteArrayWrapper)((Map.Entry)entry).getKey();
                        score = (DoubleWrapper)((Map.Entry)entry).getValue();
                        break block5;
                    }
                    catch (EntryDestroyedException e) {
                        continue;
                    }
                }
                Object[] fieldVals = ((Struct)entry).getFieldValues();
                key = (ByteArrayWrapper)fieldVals[0];
                score = (DoubleWrapper)fieldVals[1];
            }
            byte[] byteAr = key.toBytes();
            tmp.writeByte(36);
            tmp.writeBytes(Coder.intToBytes(byteAr.length));
            tmp.writeBytes(CRLFar);
            tmp.writeBytes(byteAr);
            tmp.writeBytes(CRLFar);
            ++size;
            if (!withScores) continue;
            String scoreString = score.toString();
            byte[] scoreAr = Coder.stringToBytes(scoreString);
            tmp.writeByte(36);
            tmp.writeBytes(Coder.intToBytes(scoreString.length()));
            tmp.writeBytes(CRLFar);
            tmp.writeBytes(scoreAr);
            tmp.writeBytes(CRLFar);
            ++size;
        }
        buffer.writeBytes(Coder.intToBytes(size));
        buffer.writeBytes(CRLFar);
        buffer.writeBytes(tmp);
        tmp.release();
        return buffer;
    }

    public static ByteBuf getArrayOfNils(ByteBufAllocator alloc, int length) {
        ByteBuf response = alloc.buffer();
        response.writeByte(42);
        response.writeBytes(Coder.intToBytes(length));
        response.writeBytes(CRLFar);
        for (int i = 0; i < length; ++i) {
            response.writeBytes(bNIL);
        }
        return response;
    }

    public static String bytesToString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, CHARSET).intern();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String doubleToString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        return String.valueOf(d);
    }

    public static byte[] stringToBytes(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            return string.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteArrayWrapper stringToByteArrayWrapper(String s) {
        return new ByteArrayWrapper(Coder.stringToBytes(s));
    }

    public static byte[] intToBytes(int i) {
        return Coder.stringToBytes(String.valueOf(i));
    }

    public static byte[] longToBytes(long l) {
        return Coder.stringToBytes(String.valueOf(l));
    }

    public static byte[] doubleToBytes(double d) {
        return Coder.stringToBytes(Coder.doubleToString(d));
    }

    public static int bytesToInt(byte[] bytes) {
        return Integer.parseInt(Coder.bytesToString(bytes));
    }

    public static long bytesToLong(byte[] bytes) {
        return Long.parseLong(Coder.bytesToString(bytes));
    }

    public static double bytesToDouble(byte[] bytes) {
        return Coder.stringToDouble(Coder.bytesToString(bytes));
    }

    public static double stringToDouble(String d) {
        if (d.equalsIgnoreCase(P_INF)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d.equalsIgnoreCase(N_INF)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.parseDouble(d);
    }

    public static ByteArrayWrapper stringToByteWrapper(String s) {
        return new ByteArrayWrapper(Coder.stringToBytes(s));
    }

    static {
        decimalFormatter.setMaximumFractionDigits(10);
    }
}

