/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.EntryExpiryTask;
import org.apache.geode.internal.cache.ExpiryTask;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ExpirationScheduler {
    private static final Logger logger = LogService.getLogger();
    private final SystemTimer timer;
    private final AtomicInteger pendingCancels = new AtomicInteger();
    private static final int MAX_PENDING_CANCELS = Integer.getInteger("gemfire.MAX_PENDING_CANCELS", 10000);

    public ExpirationScheduler(InternalDistributedSystem ds) {
        this.timer = new SystemTimer(ds);
    }

    public void forcePurge() {
        this.pendingCancels.getAndSet(0);
        this.timer.timerPurge();
    }

    public void incCancels() {
        int pc = this.pendingCancels.incrementAndGet();
        if (pc > MAX_PENDING_CANCELS) {
            pc = this.pendingCancels.getAndSet(0);
            if (pc > MAX_PENDING_CANCELS) {
                this.timer.timerPurge();
            } else {
                this.pendingCancels.addAndGet(pc);
            }
        }
    }

    public ExpiryTask addExpiryTask(ExpiryTask task) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Scheduling  {}  to fire in  {}  ms", new Object[]{task, task.getExpiryMillis()});
            }
            this.timer.schedule((SystemTimer.SystemTimerTask)task, task.getExpiryMillis());
        }
        catch (EntryNotFoundException e) {
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
        return task;
    }

    public boolean addEntryExpiryTask(EntryExpiryTask task) {
        return this.addExpiryTask(task) != null;
    }

    public void cancel() {
        this.timer.cancel();
    }
}

