/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;

public class MembershipView<ID extends MemberIdentifier> {
    private int viewId;
    private List<ID> members;
    private Set<ID> shutdownMembers;
    private Set<ID> crashedMembers;
    private ID creator;
    private Set<ID> hashedMembers;
    private volatile boolean unmodifiable;

    public MembershipView() {
        this.viewId = -1;
        this.members = new ArrayList<ID>(0);
        this.hashedMembers = new HashSet<ID>(this.members);
        this.shutdownMembers = Collections.emptySet();
        this.crashedMembers = new HashSet<ID>();
        this.creator = null;
    }

    public MembershipView(ID creator, int viewId, List<ID> members) {
        this.viewId = viewId;
        this.members = new ArrayList<ID>(members);
        this.hashedMembers = new HashSet<ID>(this.members);
        this.shutdownMembers = new HashSet<ID>();
        this.crashedMembers = Collections.emptySet();
        this.creator = creator;
    }

    public MembershipView(MembershipView<ID> other, int viewId) {
        this.creator = other.creator;
        this.viewId = viewId;
        this.members = new ArrayList<ID>(other.members);
        this.hashedMembers = new HashSet<ID>(other.members);
        this.shutdownMembers = new HashSet<ID>(other.shutdownMembers);
        this.crashedMembers = new HashSet<ID>(other.crashedMembers);
    }

    public MembershipView(ID creator, int viewId, List<ID> mbrs, Set<ID> shutdowns, Set<ID> crashes) {
        this.creator = creator;
        this.viewId = viewId;
        this.members = mbrs;
        this.hashedMembers = new HashSet<ID>(mbrs);
        this.shutdownMembers = shutdowns;
        this.crashedMembers = crashes;
    }

    public void makeUnmodifiable() {
        this.unmodifiable = true;
    }

    public int getViewId() {
        return this.viewId;
    }

    public ID getCreator() {
        return this.creator;
    }

    public void setCreator(ID creator) {
        this.creator = creator;
    }

    public void setViewId(int viewId) {
        this.viewId = viewId;
    }

    public List<ID> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public List<ID> getNewMembers(MembershipView<ID> olderView) {
        ArrayList<ID> result = new ArrayList<ID>(this.members);
        result.removeAll(olderView.getMembers());
        return result;
    }

    public Object get(int i) {
        return this.members.get(i);
    }

    public void add(ID mbr) {
        if (this.unmodifiable) {
            throw new IllegalStateException("this membership view is not modifiable");
        }
        this.hashedMembers.add(mbr);
        this.members.add(mbr);
    }

    public boolean remove(ID mbr) {
        if (this.unmodifiable) {
            throw new IllegalStateException("this membership view is not modifiable");
        }
        this.hashedMembers.remove(mbr);
        return this.members.remove(mbr);
    }

    public void removeAll(Collection<ID> ids) {
        if (this.unmodifiable) {
            throw new IllegalStateException("this membership view is not modifiable");
        }
        this.hashedMembers.removeAll(ids);
        ids.forEach(this::remove);
    }

    public boolean contains(MemberIdentifier mbr) {
        return this.hashedMembers.contains(mbr);
    }

    public int size() {
        return this.members.size();
    }

    public ID getLeadMember() {
        for (MemberIdentifier mbr : this.members) {
            if (mbr.getVmKind() != 10) continue;
            return (ID)mbr;
        }
        return null;
    }

    public synchronized ID getCanonicalID(ID id) {
        if (this.hashedMembers.contains(id)) {
            for (MemberIdentifier m : this.members) {
                if (!id.equals(m)) continue;
                return (ID)m;
            }
        }
        return id;
    }

    public ID getCoordinator() {
        for (MemberIdentifier addr : this.members) {
            if (!addr.preferredForCoordinator()) continue;
            return (ID)addr;
        }
        if (this.members.size() > 0) {
            return (ID)((MemberIdentifier)this.members.get(0));
        }
        return null;
    }

    public Set<ID> getShutdownMembers() {
        return this.shutdownMembers;
    }

    public Set<ID> getCrashedMembers() {
        return this.crashedMembers;
    }

    public String toString() {
        ID lead = this.getLeadMember();
        StringBuilder sb = new StringBuilder(200);
        sb.append("View[").append(this.creator).append('|').append(this.viewId).append("] members: [");
        boolean first = true;
        for (MemberIdentifier mbr : this.members) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(mbr);
            if (mbr == lead) {
                sb.append("{lead}");
            }
            first = false;
        }
        if (!this.shutdownMembers.isEmpty()) {
            sb.append("]  shutdown: [");
            first = true;
            for (MemberIdentifier mbr : this.shutdownMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        if (!this.crashedMembers.isEmpty()) {
            sb.append("]  crashed: [");
            first = true;
            for (MemberIdentifier mbr : this.crashedMembers) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(mbr);
                first = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public synchronized boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MembershipView) {
            return this.members.equals(((MembershipView)other).getMembers());
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.members.hashCode();
    }
}

