/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class GetRangeExecutor
extends StringExecutor {
    private final String ERROR_NOT_INT = "The indexes provided must be numeric values";
    private final int startIndex = 2;
    private final int stopIndex = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        byte[] returnRange;
        long end;
        long start;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GETRANGE command is \"GETRANGE key start end\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_STRING, context);
        ByteArrayWrapper valueWrapper = (ByteArrayWrapper)r.get((Object)key);
        if (valueWrapper == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        byte[] value = valueWrapper.toBytes();
        int length = value.length;
        try {
            byte[] startI = commandElems.get(2);
            byte[] stopI = commandElems.get(3);
            start = Coder.bytesToLong(startI);
            end = Coder.bytesToLong(stopI);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The indexes provided must be numeric values"));
            return;
        }
        start = this.getBoundedStartIndex(start, (long)length);
        end = this.getBoundedEndIndex(end, (long)length);
        if (start > end || start == (long)length) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        if (end != (long)length) {
            ++end;
        }
        if ((returnRange = Arrays.copyOfRange(value, (int)start, (int)end)) == null || returnRange.length == 0) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        this.respondBulkStrings(command, context, returnRange);
    }
}

