/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.ListQuery;
import org.apache.geode.redis.internal.executor.list.ListExecutor;

public class LSetExecutor
extends ListExecutor {
    private final String ERROR_NOT_NUMERIC = "The index provided is not numeric";
    private final String ERROR_INDEX = "The index provided is not within range of this list or the key does not exist";
    private final String SUCCESS = "OK";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        Integer indexKey;
        int index;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the LSET command is \"LSET key index value\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] indexArray = commandElems.get(2);
        byte[] value = commandElems.get(3);
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Integer, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not within range of this list or the key does not exist"));
            return;
        }
        try {
            index = Coder.bytesToInt(indexArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not numeric"));
            return;
        }
        int listSize = keyRegion.size() - 2;
        if (index < 0) {
            index += listSize;
        }
        if (index < 0 || index > listSize) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not within range of this list or the key does not exist"));
            return;
        }
        try {
            indexKey = this.getIndexKey(context, key, index);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (indexKey == null) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not within range of this list or the key does not exist"));
            return;
        }
        if (index == listSize) {
            Integer n = indexKey;
            Integer n2 = indexKey = Integer.valueOf(indexKey + 1);
        }
        keyRegion.put((Object)indexKey, (Object)new ByteArrayWrapper(value));
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }

    private Integer getIndexKey(ExecutionHandlerContext context, ByteArrayWrapper key, int index) throws Exception {
        Query query = this.getQuery(key, ListQuery.LSET, context);
        Object[] params = new Object[]{index + 1};
        SelectResults results = (SelectResults)query.execute(params);
        int size = results.size();
        if (results == null || size == 0) {
            return null;
        }
        return (Integer)results.asList().get(size - 1);
    }
}

