/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class ExpireExecutor
extends AbstractExecutor
implements Extendable {
    private final String ERROR_SECONDS_NOT_USABLE = "The number of seconds specified must be numeric";
    private final int SECONDS_INDEX = 2;
    private final int SET = 1;
    private final int NOT_SET = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long delay;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper wKey = command.getKey();
        RegionProvider rC = context.getRegionProvider();
        byte[] delayByteArray = commandElems.get(2);
        try {
            delay = Coder.bytesToLong(delayByteArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number of seconds specified must be numeric"));
            return;
        }
        if (delay <= 0L) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        if (!this.timeUnitMillis()) {
            delay *= 1000L;
        }
        boolean expirationSet = false;
        expirationSet = rC.hasExpiration(wKey) ? rC.modifyExpiration(wKey, delay) : rC.setExpiration(wKey, delay);
        if (expirationSet) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }

    protected boolean timeUnitMillis() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the EXPIRE command is \"EXPIRE key seconds\"";
    }
}

