/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.redis.internal.Coder;

public class ByteArrayWrapper
implements DataSerializable,
Comparable<ByteArrayWrapper> {
    private static final long serialVersionUID = 9066391742266642992L;
    private byte[] value;
    private transient int hashCode;
    private transient String toString;

    public ByteArrayWrapper() {
    }

    public ByteArrayWrapper(byte[] value) {
        this.value = value;
        this.hashCode = Arrays.hashCode(value);
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeByteArray((byte[])this.value, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.value = DataSerializer.readByteArray((DataInput)in);
        this.hashCode = Arrays.hashCode(this.value);
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = Coder.bytesToString(this.value);
        }
        return this.toString;
    }

    public byte[] toBytes() {
        return this.value;
    }

    public void setBytes(byte[] bytes) {
        this.value = bytes;
        this.toString = null;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public int length() {
        return this.value.length;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other instanceof ByteArrayWrapper) {
            return Arrays.equals(this.value, ((ByteArrayWrapper)other).value);
        }
        if (other instanceof String) {
            return Arrays.equals(this.value, Coder.stringToBytes((String)other));
        }
        return false;
    }

    @Override
    public int compareTo(ByteArrayWrapper other) {
        return this.arrayCmp(this.value, other.value);
    }

    private int arrayCmp(byte[] A, byte[] B) {
        if (A == B) {
            return 0;
        }
        if (A == null) {
            return -1;
        }
        if (B == null) {
            return 1;
        }
        int len = Math.min(A.length, B.length);
        for (int i = 0; i < len; ++i) {
            byte a = A[i];
            byte b = B[i];
            int diff = a - b;
            if (diff > 0) {
                return 1;
            }
            if (diff >= 0) continue;
            return -1;
        }
        if (A.length > B.length) {
            return 1;
        }
        if (B.length > A.length) {
            return -1;
        }
        return 0;
    }
}

