/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.tcpserver;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.geode.distributed.internal.tcpserver.ConnectionWatcher;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;

public class TcpSocketCreatorImpl
implements TcpSocketCreator {
    public static final boolean ENABLE_TCP_KEEP_ALIVE;

    @Override
    public boolean useSSL() {
        return false;
    }

    @Override
    public final ServerSocket createServerSocket(int nport, int backlog) throws IOException {
        return this.createServerSocket(nport, backlog, null, -1, this.useSSL());
    }

    @Override
    public final ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr) throws IOException {
        return this.createServerSocket(nport, backlog, bindAddr, -1, this.useSSL());
    }

    @Override
    public final ServerSocket createServerSocketUsingPortRange(InetAddress ba, int backlog, boolean isBindAddress, boolean useNIO, int tcpBufferSize, int[] tcpPortRange, boolean sslConnection) throws IOException {
        try {
            int startingPort;
            int localPort = startingPort = tcpPortRange[0] + ThreadLocalRandom.current().nextInt(tcpPortRange[1] - tcpPortRange[0] + 1);
            int portLimit = tcpPortRange[1];
            while (true) {
                if (localPort > portLimit) {
                    if (startingPort != 0) {
                        localPort = tcpPortRange[0];
                        portLimit = startingPort - 1;
                        startingPort = 0;
                    } else {
                        throw this.noFreePortException(String.format("Unable to find a free port in the membership-port-range: [%d,%d]", tcpPortRange[0], tcpPortRange[1]));
                    }
                }
                ServerSocket socket = null;
                try {
                    if (useNIO) {
                        ServerSocketChannel channel = ServerSocketChannel.open();
                        socket = channel.socket();
                        InetSocketAddress address = new InetSocketAddress(isBindAddress ? ba : null, localPort);
                        socket.bind(address, backlog);
                    } else {
                        socket = this.createServerSocket(localPort, backlog, isBindAddress ? ba : null, tcpBufferSize, sslConnection);
                    }
                    return socket;
                }
                catch (SocketException ex) {
                    if (socket != null && !socket.isClosed()) {
                        socket.close();
                    }
                    ++localPort;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw this.problemCreatingSocketInPortRangeException("unable to create a socket in the membership-port range", e);
        }
    }

    protected RuntimeException problemCreatingSocketInPortRangeException(String s, IOException e) {
        return new RuntimeException(s, e);
    }

    protected RuntimeException noFreePortException(String reason) {
        return new RuntimeException(reason);
    }

    protected ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, int socketBufferSize, boolean sslConnection) throws IOException {
        if (sslConnection) {
            throw new UnsupportedOperationException();
        }
        ServerSocket result = new ServerSocket();
        result.setReuseAddress(true);
        if (socketBufferSize != -1) {
            result.setReceiveBufferSize(socketBufferSize);
        }
        try {
            result.bind(new InetSocketAddress(bindAddr, nport), backlog);
        }
        catch (BindException e) {
            BindException throwMe = new BindException(String.format("Failed to create server socket on %s[%s]", bindAddr == null ? InetAddress.getLocalHost().getHostAddress() : bindAddr, String.valueOf(nport)));
            throwMe.initCause(e);
            throw throwMe;
        }
        return result;
    }

    @Override
    public final Socket connect(InetAddress inetadd, int port, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide) throws IOException {
        return this.connect(inetadd, port, timeout, optionalWatcher, clientSide, -1, this.useSSL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket connect(InetAddress inetadd, int port, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide, int socketBufferSize, boolean sslConnection) throws IOException {
        if (sslConnection) {
            throw new IllegalArgumentException();
        }
        Socket socket = null;
        if (clientSide) {
            socket = this.createCustomClientSocket(inetadd, port);
        }
        if (socket == null) {
            socket = new Socket();
            socket.setKeepAlive(ENABLE_TCP_KEEP_ALIVE);
            if (socketBufferSize != -1) {
                socket.setReceiveBufferSize(socketBufferSize);
            }
            if (optionalWatcher != null) {
                optionalWatcher.beforeConnect(socket);
            }
            try {
                socket.connect(new InetSocketAddress(inetadd, port), Math.max(timeout, 0));
            }
            finally {
                if (optionalWatcher != null) {
                    optionalWatcher.afterConnect(socket);
                }
            }
        }
        return socket;
    }

    protected Socket createCustomClientSocket(InetAddress inetaddr, int port) throws IOException {
        throw new UnsupportedOperationException("custom client socket factory is not supported by this socket creator");
    }

    @Override
    public void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        if (this.useSSL()) {
            throw new IllegalStateException("Handshake on SSL connections is not supported");
        }
    }

    static {
        String str = System.getProperty("gemfire.setTcpKeepAlive");
        ENABLE_TCP_KEEP_ALIVE = str != null ? Boolean.valueOf(str) : true;
    }
}

