/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mx4j.tools.adaptor.http.HttpInputStream;
import mx4j.tools.adaptor.http.HttpUtil;

public class HttpOutputStream
extends BufferedOutputStream {
    protected int code = 200;
    protected boolean sendHeaders;
    protected Map headers = new HashMap(7);

    public HttpOutputStream(OutputStream out, HttpInputStream in) {
        super(out);
        this.setHeader("Server", "MX4J-HTTPD/1.0");
        this.sendHeaders = (double)in.getVersion() >= 1.0;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setHeader(String attr, String value) {
        this.headers.put(attr, value);
    }

    public boolean sendHeaders() throws IOException {
        if (this.sendHeaders) {
            StringBuffer buffer = new StringBuffer(512);
            buffer.append("HTTP/1.0 ");
            buffer.append(this.code);
            buffer.append(" ");
            buffer.append(HttpUtil.getCodeMessage(this.code));
            buffer.append("\r\n");
            Iterator attrs = this.headers.keySet().iterator();
            int size = this.headers.size();
            for (int i = 0; i < size; ++i) {
                String attr = (String)attrs.next();
                buffer.append(attr);
                buffer.append(": ");
                buffer.append(this.headers.get(attr));
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            this.write(buffer.toString());
        }
        return this.sendHeaders;
    }

    public void write(String msg) throws IOException {
        this.write(msg.getBytes("latin1"));
    }

    public void write(InputStream in) throws IOException {
        int n;
        int length = this.buf.length;
        while ((n = in.read(this.buf, this.count, length - this.count)) >= 0) {
            if ((this.count += n) < length) continue;
            this.count = 0;
            this.out.write(this.buf, 0, length);
        }
    }
}

