/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import java.io.InputStream;
import org.apache.commons.lang3.Validate;
import org.apache.geode.internal.process.BlockingProcessStreamReader;
import org.apache.geode.internal.process.NonBlockingProcessStreamReader;
import org.apache.geode.logging.internal.executors.LoggingThread;

public abstract class ProcessStreamReader
implements Runnable {
    private static final int DEFAULT_PROCESS_OUTPUT_WAIT_TIME_MILLIS = 5000;
    protected final Process process;
    protected final InputStream inputStream;
    protected final InputListener inputListener;
    private Thread thread;

    protected ProcessStreamReader(Builder builder) {
        Validate.notNull((Object)builder, (String)("Invalid builder '" + builder + "' specified"), (Object[])new Object[0]);
        this.process = builder.process;
        this.inputStream = builder.inputStream;
        this.inputListener = builder.inputListener == null ? new InputListener(){

            @Override
            public void notifyInputLine(String line) {
            }

            public String toString() {
                return "NullInputListener";
            }
        } : builder.inputListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader start() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null) {
                if (this.thread.isAlive()) {
                    throw new IllegalStateException(this + " has already started");
                }
                throw new IllegalStateException(this + " was stopped and cannot be restarted");
            }
            this.thread = new LoggingThread(this.createThreadName(), (Runnable)this);
            this.thread.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader stop() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
        }
        return this;
    }

    public ProcessStreamReader stopAsync(long delayMillis) {
        Runnable delayedStop = () -> {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.stop();
            }
        };
        String threadName = this.getClass().getSimpleName() + " stopAfterDelay Thread @" + Integer.toHexString(this.hashCode());
        LoggingThread thread = new LoggingThread(threadName, delayedStop);
        thread.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            if (this.thread != null) {
                return this.thread.isAlive();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader join() throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader join(long millis) throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join(millis);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStreamReader join(long millis, int nanos) throws InterruptedException {
        Thread thread;
        ProcessStreamReader processStreamReader = this;
        synchronized (processStreamReader) {
            thread = this.thread;
        }
        if (thread != null) {
            thread.join(millis, nanos);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" Thread").append(" #").append(System.identityHashCode(this));
        sb.append(" alive=").append(this.isRunning());
        sb.append(" listener=").append(this.inputListener);
        return sb.toString();
    }

    private String createThreadName() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    private static String waitAndCaptureProcessStandardOutputStream(Process process, long waitTimeMilliseconds) {
        Validate.notNull((Object)process, (String)("Invalid process '" + process + "' specified"), (Object[])new Object[0]);
        return ProcessStreamReader.waitAndCaptureProcessStream(process, process.getInputStream(), waitTimeMilliseconds);
    }

    public static String waitAndCaptureProcessStandardErrorStream(Process process) {
        return ProcessStreamReader.waitAndCaptureProcessStandardErrorStream(process, 5000L);
    }

    public static String waitAndCaptureProcessStandardErrorStream(Process process, long waitTimeMilliseconds) {
        return ProcessStreamReader.waitAndCaptureProcessStream(process, process.getErrorStream(), waitTimeMilliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String waitAndCaptureProcessStream(Process process, InputStream processInputStream, long waitTimeMilliseconds) {
        StringBuffer buffer = new StringBuffer();
        InputListener inputListener = line -> {
            buffer.append(line);
            buffer.append(System.lineSeparator());
        };
        ProcessStreamReader reader = new Builder(process).inputStream(processInputStream).inputListener(inputListener).build();
        try {
            reader.start();
            long endTime = System.currentTimeMillis() + waitTimeMilliseconds;
            while (System.currentTimeMillis() < endTime) {
                try {
                    reader.join(waitTimeMilliseconds);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            reader.stop();
        }
        return buffer.toString();
    }

    public static class Builder {
        private final Process process;
        private InputStream inputStream;
        private InputListener inputListener;
        private long continueReadingMillis;
        private ReadingMode readingMode = ReadingMode.BLOCKING;

        public Builder(Process process) {
            this.process = process;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder inputListener(InputListener inputListener) {
            this.inputListener = inputListener;
            return this;
        }

        public Builder continueReadingMillis(long continueReadingMillis) {
            this.continueReadingMillis = continueReadingMillis;
            return this;
        }

        public Builder readingMode(ReadingMode readingMode) {
            this.readingMode = readingMode;
            return this;
        }

        public ProcessStreamReader build() {
            Validate.notNull((Object)this.process, (String)("Invalid process '" + this.process + "' specified"), (Object[])new Object[0]);
            Validate.notNull((Object)this.inputStream, (String)("Invalid inputStream '" + this.inputStream + "' specified"), (Object[])new Object[0]);
            Validate.isTrue((this.continueReadingMillis >= 0L ? 1 : 0) != 0, (String)("Invalid continueReadingMillis '" + this.continueReadingMillis + "' specified"), (Object[])new Object[0]);
            switch (this.readingMode) {
                case NON_BLOCKING: {
                    return new NonBlockingProcessStreamReader(this);
                }
            }
            return new BlockingProcessStreamReader(this);
        }

        public long getContinueReadingMillis() {
            return this.continueReadingMillis;
        }
    }

    public static enum ReadingMode {
        BLOCKING,
        NON_BLOCKING;

    }

    public static interface InputListener {
        public void notifyInputLine(String var1);
    }
}

