/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.Collection;
import java.util.Iterator;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.index.IndexStore;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;
import org.apache.geode.internal.cache.persistence.query.IndexMap;

public class MapIndexStore
implements IndexStore {
    IndexMap indexMap;
    Region region;
    private boolean indexOnValues = false;
    private boolean indexOnRegionKeys = false;
    @MakeNotStatic(value="Is this a bug that this is even static?")
    private static boolean needToCallHasNext = true;

    public MapIndexStore(IndexMap indexMap, Region region) {
        this.indexMap = indexMap;
        this.region = region;
    }

    @Override
    public void addMapping(Object indexKey, RegionEntry re) {
        this.indexMap.put(indexKey, re.getKey(), "STUB");
    }

    @Override
    public void updateMapping(Object indexKey, Object oldKey, RegionEntry re, Object oldValue) {
        this.addMapping(indexKey, re);
    }

    @Override
    public void removeMapping(Object indexKey, RegionEntry re) {
        this.indexMap.remove(indexKey, re.getKey());
    }

    @Override
    public String printAll() {
        return "";
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> get(Object key) {
        return new MapIndexStoreIterator(this.indexMap.get(key), this.indexOnValues, this.indexOnRegionKeys);
    }

    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Object start, boolean startInclusive, Object end, boolean endInclusive) {
        return this.iterator(start, startInclusive, end, endInclusive, null);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Object start, boolean startInclusive, Object end, boolean endInclusive, Collection keysToRemove) {
        if (start == null) {
            return this.descendingIterator(end, endInclusive, keysToRemove);
        }
        if (end == null) {
            return this.iterator(start, startInclusive, keysToRemove);
        }
        return new MapIndexStoreIterator(this.indexMap.iterator(start, startInclusive, end, endInclusive), keysToRemove, this.indexOnValues, this.indexOnRegionKeys);
    }

    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Object start, boolean startInclusive) {
        return this.iterator(start, startInclusive, null);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Object start, boolean startInclusive, Collection keysToRemove) {
        return new MapIndexStoreIterator(this.indexMap.iterator(start, startInclusive), keysToRemove, this.indexOnValues, this.indexOnRegionKeys);
    }

    public CloseableIterator<IndexStore.IndexStoreEntry> iterator() {
        return this.iterator(null);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> iterator(Collection keysToRemove) {
        return new MapIndexStoreIterator(this.indexMap.iterator(), keysToRemove, this.indexOnValues, this.indexOnRegionKeys);
    }

    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator(Object end, boolean endInclusive) {
        return this.descendingIterator(end, endInclusive, null);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator(Object end, boolean endInclusive, Collection keysToRemove) {
        return new MapIndexStoreIterator(this.indexMap.descendingIterator(end, endInclusive), keysToRemove, this.indexOnValues, this.indexOnRegionKeys);
    }

    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator() {
        return this.descendingIterator(null);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator(Collection keysToRemove) {
        return new MapIndexStoreIterator(this.indexMap.descendingIterator(), keysToRemove, this.indexOnValues, this.indexOnRegionKeys);
    }

    @Override
    public CloseableIterator<IndexStore.IndexStoreEntry> descendingIterator(Object start, boolean startInclusive, Object end, boolean endInclusive, Collection keysToRemove) {
        return new MapIndexStoreIterator(this.indexMap.iterator(start, startInclusive, end, endInclusive), keysToRemove, this.indexOnValues, this.indexOnRegionKeys);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int size(Object key) {
        return 1;
    }

    @Override
    public boolean clear() {
        this.indexMap.destroy();
        return true;
    }

    @Override
    public boolean isIndexOnRegionKeys() {
        return this.indexOnRegionKeys;
    }

    @Override
    public void setIndexOnRegionKeys(boolean indexOnRegionKeys) {
        this.indexOnRegionKeys = indexOnRegionKeys;
    }

    @Override
    public boolean isIndexOnValues() {
        return this.indexOnValues;
    }

    @Override
    public void setIndexOnValues(boolean indexOnValues) {
        this.indexOnValues = indexOnValues;
    }

    @Override
    public Object getTargetObject(RegionEntry entry) {
        if (this.indexOnValues) {
            Object o = entry.getValue((LocalRegion)this.region);
            if (o instanceof CachedDeserializable) {
                return ((CachedDeserializable)o).getDeserializedValue(this.region, entry);
            }
            return o;
        }
        if (this.indexOnRegionKeys) {
            return entry.getKey();
        }
        return new NonTXEntry((LocalRegion)this.region, entry);
    }

    @Override
    public Object getTargetObjectInVM(RegionEntry entry) {
        if (this.indexOnValues) {
            Object o = entry.getValueInVM((LocalRegion)this.region);
            if (o instanceof CachedDeserializable) {
                return ((CachedDeserializable)o).getDeserializedValue(this.region, entry);
            }
            return o;
        }
        if (this.indexOnRegionKeys) {
            return entry.getKey();
        }
        return new NonTXEntry((LocalRegion)this.region, entry);
    }

    private static class EntrySet {
        public Object key;
        public Object value;

        private EntrySet(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private class MapIndexStoreEntry
    implements IndexStore.IndexStoreEntry {
        IndexMap.IndexEntry entry;

        private MapIndexStoreEntry() {
        }

        void setIndexEntry(IndexMap.IndexEntry entry) {
            this.entry = entry;
        }

        @Override
        public Object getDeserializedKey() {
            return this.entry.getKey().getDeserializedForReading();
        }

        @Override
        public Object getDeserializedValue() {
            if (MapIndexStore.this.indexOnValues) {
                return MapIndexStore.this.region.get(this.entry.getRegionKey().getDeserializedForReading());
            }
            if (MapIndexStore.this.indexOnRegionKeys) {
                return this.getDeserializedRegionKey();
            }
            return new EntrySet(this.getDeserializedRegionKey(), MapIndexStore.this.region.get(this.entry.getRegionKey().getDeserializedForReading()));
        }

        @Override
        public Object getDeserializedRegionKey() {
            return this.entry.getRegionKey().getDeserializedForReading();
        }

        @Override
        public boolean isUpdateInProgress() {
            return false;
        }
    }

    private class MapIndexStoreIterator
    implements CloseableIterator<IndexStore.IndexStoreEntry> {
        final CloseableIterator<IndexMap.IndexEntry> iterator;
        final MapIndexStoreEntry nextEntry;
        final Collection keysToRemove;
        final boolean indexOnRegionKeys;
        final boolean indexOnValues;

        private MapIndexStoreIterator(CloseableIterator<IndexMap.IndexEntry> iterator, Collection keysToRemove, boolean indexOnValues, boolean indexOnRegionKeys) {
            this.nextEntry = new MapIndexStoreEntry();
            this.iterator = iterator;
            this.keysToRemove = keysToRemove;
            this.indexOnRegionKeys = indexOnRegionKeys;
            this.indexOnValues = indexOnValues;
        }

        private MapIndexStoreIterator(CloseableIterator<IndexMap.IndexEntry> iterator, boolean indexOnValues, boolean indexOnRegionKeys) {
            this(iterator, null, indexOnValues, indexOnRegionKeys);
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                IndexMap.IndexEntry indexEntry = (IndexMap.IndexEntry)this.iterator.next();
                this.nextEntry.setIndexEntry(indexEntry);
                needToCallHasNext = false;
                if (this.keysToRemove != null) {
                    Iterator keysToRemoveIterator = this.keysToRemove.iterator();
                    while (keysToRemoveIterator.hasNext()) {
                        try {
                            if (!TypeUtils.compare(this.nextEntry.getDeserializedValue(), keysToRemoveIterator.next(), 13).equals(Boolean.TRUE)) continue;
                            return this.hasNext();
                        }
                        catch (TypeMismatchException typeMismatchException) {
                        }
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public IndexStore.IndexStoreEntry next() {
            if (needToCallHasNext) {
                this.hasNext();
            }
            needToCallHasNext = true;
            return this.nextEntry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
            this.iterator.close();
            this.nextEntry.setIndexEntry(null);
        }
    }
}

