/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.util.Optional;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.configuration.EnumActionDestroyOverflow;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.cache.EvictionAttributesImpl;

public abstract class EvictionAttributes {
    public static final int DEFAULT_ENTRIES_MAXIMUM = 900;
    public static final int DEFAULT_MEMORY_MAXIMUM = 10;

    public static EvictionAttributes createLRUEntryAttributes() {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setMaximum(900);
    }

    public static EvictionAttributes createLRUEntryAttributes(int maximumEntries) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setMaximum(maximumEntries);
    }

    public static EvictionAttributes createLRUEntryAttributes(EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(evictionAction).setMaximum(900);
    }

    public static EvictionAttributes createLRUEntryAttributes(int maximumEntries, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_ENTRY).setAction(evictionAction).setMaximum(maximumEntries);
    }

    public static EvictionAttributes createLRUHeapAttributes() {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_HEAP).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setObjectSizer(ObjectSizer.DEFAULT);
    }

    public static EvictionAttributes createLRUHeapAttributes(ObjectSizer sizer) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_HEAP).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUHeapAttributes(ObjectSizer sizer, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_HEAP).setAction(evictionAction).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUMemoryAttributes() {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setMaximum(10).setObjectSizer(ObjectSizer.DEFAULT);
    }

    public static EvictionAttributes createLRUMemoryAttributes(int maximumMegabytes) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setMaximum(maximumMegabytes).setObjectSizer(null);
    }

    public static EvictionAttributes createLRUMemoryAttributes(int maximumMegabytes, ObjectSizer sizer) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setMaximum(maximumMegabytes).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUMemoryAttributes(int maximumMegabytes, ObjectSizer sizer, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(evictionAction).setMaximum(maximumMegabytes).setObjectSizer(sizer);
    }

    public static EvictionAttributes createLRUMemoryAttributes(ObjectSizer sizer) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(EvictionAction.DEFAULT_EVICTION_ACTION).setObjectSizer(sizer).setMaximum(10);
    }

    public static EvictionAttributes createLRUMemoryAttributes(ObjectSizer sizer, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LRU_MEMORY).setAction(evictionAction).setObjectSizer(sizer).setMaximum(10);
    }

    public abstract ObjectSizer getObjectSizer();

    public abstract EvictionAlgorithm getAlgorithm();

    public abstract int getMaximum();

    public abstract EvictionAction getAction();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EvictionAttributes)) {
            return false;
        }
        EvictionAttributes other = (EvictionAttributes)obj;
        if (!this.getAlgorithm().equals(other.getAlgorithm())) {
            return false;
        }
        if (!this.getAction().equals(other.getAction())) {
            return false;
        }
        return this.getMaximum() == other.getMaximum();
    }

    public int hashCode() {
        return this.getAlgorithm().hashCode() ^ this.getMaximum();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(" algorithm=").append(this.getAlgorithm());
        if (!this.getAlgorithm().isNone()) {
            buffer.append("; action=").append(this.getAction());
            if (!this.getAlgorithm().isLRUHeap()) {
                buffer.append("; maximum=").append(this.getMaximum());
            }
            if (this.getObjectSizer() != null) {
                buffer.append("; sizer=").append(this.getObjectSizer());
            }
        }
        return buffer.toString();
    }

    public static EvictionAttributes createLIFOEntryAttributes(int maximumEntries, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LIFO_ENTRY).setAction(evictionAction).setMaximum(maximumEntries);
    }

    public static EvictionAttributes createLIFOMemoryAttributes(int maximumMegabytes, EvictionAction evictionAction) {
        return new EvictionAttributesImpl().setAlgorithm(EvictionAlgorithm.LIFO_MEMORY).setAction(evictionAction).setMaximum(maximumMegabytes).setObjectSizer(null);
    }

    public RegionAttributesType.EvictionAttributes convertToConfigEvictionAttributes() {
        RegionAttributesType.EvictionAttributes configAttributes = new RegionAttributesType.EvictionAttributes();
        EnumActionDestroyOverflow action = EnumActionDestroyOverflow.fromValue(this.getAction().toString());
        EvictionAlgorithm algorithm = this.getAlgorithm();
        Optional<String> objectSizerClass = Optional.ofNullable(this.getObjectSizer()).map(c -> c.getClass().toString());
        Integer maximum = this.getMaximum();
        if (algorithm.isLRUHeap()) {
            RegionAttributesType.EvictionAttributes.LruHeapPercentage heapPercentage = new RegionAttributesType.EvictionAttributes.LruHeapPercentage();
            heapPercentage.setAction(action);
            objectSizerClass.ifPresent(o -> heapPercentage.setClassName((String)o));
            configAttributes.setLruHeapPercentage(heapPercentage);
        } else if (algorithm.isLRUMemory()) {
            RegionAttributesType.EvictionAttributes.LruMemorySize memorySize = new RegionAttributesType.EvictionAttributes.LruMemorySize();
            memorySize.setAction(action);
            objectSizerClass.ifPresent(o -> memorySize.setClassName((String)o));
            memorySize.setMaximum(maximum.toString());
            configAttributes.setLruMemorySize(memorySize);
        } else {
            RegionAttributesType.EvictionAttributes.LruEntryCount entryCount = new RegionAttributesType.EvictionAttributes.LruEntryCount();
            entryCount.setAction(action);
            entryCount.setMaximum(maximum.toString());
            configAttributes.setLruEntryCount(entryCount);
        }
        return configAttributes;
    }

    public boolean isNoEviction() {
        return this.getAction() == EvictionAction.NONE;
    }
}

