/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class StrlenExecutor
extends StringExecutor {
    private final int KEY_DOES_NOT_EXIST = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the STRELEN command is \"STRLEN key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_STRING, context);
        ByteArrayWrapper valueWrapper = (ByteArrayWrapper)r.get((Object)key);
        if (valueWrapper == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), valueWrapper.toBytes().length));
        }
    }
}

