/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZRangeByLexExecutor
extends SortedSetExecutor {
    private final String ERROR_NOT_NUMERIC = "The index provided is not numeric";
    private final String ERROR_ILLEGAL_SYNTAX = "The min and max strings must either start with a (, [ or be - or +";
    private final String ERROR_LIMIT = "The offset and count cannot be negative";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZRANGEBYLEX command is \"ZRANGEBYLEX key min max [LIMIT offset count]\""));
            return;
        }
        boolean existsLimit = false;
        if (commandElems.size() >= 7) {
            byte[] fifthElem = commandElems.get(4);
            existsLimit = Coder.bytesToString(fifthElem).equalsIgnoreCase("LIMIT");
        }
        int offset = 0;
        int limit = 0;
        if (existsLimit) {
            try {
                byte[] offsetArray = commandElems.get(5);
                byte[] limitArray = commandElems.get(6);
                offset = Coder.bytesToInt(offsetArray);
                limit = Coder.bytesToInt(limitArray);
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not numeric"));
                return;
            }
        }
        if (offset < 0 || limit < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The offset and count cannot be negative"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_SORTEDSET);
        if (keyRegion == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        boolean minInclusive = false;
        boolean maxInclusive = false;
        byte[] minArray = commandElems.get(2);
        byte[] maxArray = commandElems.get(3);
        String startString = Coder.bytesToString(minArray);
        String stopString = Coder.bytesToString(maxArray);
        if (minArray[0] == 40) {
            startString = startString.substring(1);
            minInclusive = false;
        } else if (minArray[0] == 91) {
            startString = startString.substring(1);
            minInclusive = true;
        } else if (minArray[0] != 45) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The min and max strings must either start with a (, [ or be - or +"));
            return;
        }
        if (maxArray[0] == 40) {
            stopString = stopString.substring(1);
            maxInclusive = false;
        } else if (maxArray[0] == 91) {
            stopString = stopString.substring(1);
            maxInclusive = true;
        } else if (maxArray[0] != 43) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The min and max strings must either start with a (, [ or be - or +"));
            return;
        }
        List<ByteArrayWrapper> list = null;
        if (!existsLimit || limit != 0) {
            try {
                list = this.getRange(key, keyRegion, context, Coder.stringToByteArrayWrapper(startString), Coder.stringToByteArrayWrapper(stopString), minInclusive, maxInclusive, offset, limit);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (list == null) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(this.getCustomBulkStringArrayResponse(list, context));
        }
    }

    private List<ByteArrayWrapper> getRange(ByteArrayWrapper key, Region<ByteArrayWrapper, DoubleWrapper> keyRegion, ExecutionHandlerContext context, ByteArrayWrapper start, ByteArrayWrapper stop, boolean startInclusive, boolean stopInclusive, int offset, int limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object[] params;
        Query query;
        if (start.equals(this.minus) && stop.equals(this.plus)) {
            ArrayList<ByteArrayWrapper> l = new ArrayList(keyRegion.keySet());
            int size = l.size();
            Collections.sort(l);
            if (limit == 0) {
                limit += size;
            }
            l = l.subList(Math.min(size, offset), Math.min(offset + limit, size));
            return l;
        }
        if (start.equals(this.plus) || stop.equals(this.minus)) {
            return null;
        }
        if (start.equals(this.minus)) {
            query = stopInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXNINFI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEXNINF, context);
            params = new Object[]{stop, INFINITY_LIMIT};
        } else if (stop.equals(this.plus)) {
            query = startInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXPINFI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEXPINF, context);
            params = new Object[]{start, INFINITY_LIMIT};
        } else {
            query = startInclusive ? (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXSTISI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEXSTI, context)) : (stopInclusive ? this.getQuery(key, SortedSetQuery.ZRANGEBYLEXSI, context) : this.getQuery(key, SortedSetQuery.ZRANGEBYLEX, context));
            params = new Object[]{start, stop, INFINITY_LIMIT};
        }
        if (limit > 0) {
            params[params.length - 1] = limit + offset;
        }
        SelectResults results = (SelectResults)query.execute(params);
        List list = results.asList();
        int size = list.size();
        return list.subList(Math.min(size, offset), size);
    }

    private ByteBuf getCustomBulkStringArrayResponse(Collection<ByteArrayWrapper> items, ExecutionHandlerContext context) {
        Iterator<ByteArrayWrapper> it = items.iterator();
        ByteBuf response = context.getByteBufAllocator().buffer();
        response.writeByte(42);
        response.writeBytes(Coder.intToBytes(items.size()));
        response.writeBytes(Coder.CRLFar);
        while (it.hasNext()) {
            ByteArrayWrapper next = it.next();
            byte[] byteAr = next.toBytes();
            response.writeByte(36);
            response.writeBytes(Coder.intToBytes(byteAr.length));
            response.writeBytes(Coder.CRLFar);
            response.writeBytes(byteAr);
            response.writeBytes(Coder.CRLFar);
        }
        return response;
    }
}

