/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZLexCountExecutor
extends SortedSetExecutor {
    private final String ERROR_ILLEGAL_SYNTAX = "The min and max strings must either start with a (, [ or be - or +";
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int count;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZLEXCOUNT command is \"ZLEXCOUNT key min max\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        boolean minInclusive = false;
        boolean maxInclusive = false;
        byte[] minArray = commandElems.get(2);
        byte[] maxArray = commandElems.get(3);
        String startString = Coder.bytesToString(minArray);
        String stopString = Coder.bytesToString(maxArray);
        if (minArray[0] == 40) {
            startString = startString.substring(1);
            minInclusive = false;
        } else if (minArray[0] == 91) {
            startString = startString.substring(1);
            minInclusive = true;
        } else if (minArray[0] != 45) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The min and max strings must either start with a (, [ or be - or +"));
            return;
        }
        if (maxArray[0] == 40) {
            stopString = stopString.substring(1);
            maxInclusive = false;
        } else if (maxArray[0] == 91) {
            stopString = stopString.substring(1);
            maxInclusive = true;
        } else if (maxArray[0] != 43) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The min and max strings must either start with a (, [ or be - or +"));
            return;
        }
        try {
            count = this.getCount(key, keyRegion, context, Coder.stringToByteArrayWrapper(startString), Coder.stringToByteArrayWrapper(stopString), minInclusive, maxInclusive);
        }
        catch (Exception e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), e.toString()));
            return;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), count));
    }

    private int getCount(ByteArrayWrapper key, Region<ByteArrayWrapper, DoubleWrapper> keyRegion, ExecutionHandlerContext context, ByteArrayWrapper start, ByteArrayWrapper stop, boolean startInclusive, boolean stopInclusive) throws Exception {
        Object[] params;
        Query query;
        if (start.equals(this.minus) && stop.equals(this.plus)) {
            return keyRegion.size();
        }
        if (start.equals(this.plus) || stop.equals(this.minus)) {
            return 0;
        }
        if (start.equals(this.minus)) {
            query = stopInclusive ? this.getQuery(key, SortedSetQuery.ZLEXCOUNTNINFI, context) : this.getQuery(key, SortedSetQuery.ZLEXCOUNTNINF, context);
            params = new Object[]{stop};
        } else if (stop.equals(this.plus)) {
            query = startInclusive ? this.getQuery(key, SortedSetQuery.ZLEXCOUNTPINFI, context) : this.getQuery(key, SortedSetQuery.ZLEXCOUNTPINF, context);
            params = new Object[]{start};
        } else {
            query = startInclusive ? (stopInclusive ? this.getQuery(key, SortedSetQuery.ZLEXCOUNTSTISI, context) : this.getQuery(key, SortedSetQuery.ZLEXCOUNTSTI, context)) : (stopInclusive ? this.getQuery(key, SortedSetQuery.ZLEXCOUNTSI, context) : this.getQuery(key, SortedSetQuery.ZLEXCOUNT, context));
            params = new Object[]{start, stop};
        }
        SelectResults results = (SelectResults)query.execute(params);
        return (Integer)results.asList().get(0);
    }
}

