/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SMoveExecutor
extends SetExecutor {
    private final int MOVED = 1;
    private final int NOT_MOVED = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SMOVE command is \"SMOVE source destination member\""));
            return;
        }
        ByteArrayWrapper source = command.getKey();
        ByteArrayWrapper destination = new ByteArrayWrapper(commandElems.get(2));
        ByteArrayWrapper mem = new ByteArrayWrapper(commandElems.get(3));
        this.checkDataType(source, RedisDataType.REDIS_SET, context);
        this.checkDataType(destination, RedisDataType.REDIS_SET, context);
        Region<?, ?> sourceRegion = context.getRegionProvider().getRegion(source);
        if (sourceRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        Object oldVal = sourceRegion.get((Object)mem);
        sourceRegion.remove((Object)mem);
        if (oldVal == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        Region<?, ?> destinationRegion = this.getOrCreateRegion(context, destination, RedisDataType.REDIS_SET);
        destinationRegion.put((Object)mem, (Object)true);
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
    }
}

