/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.set.SetExecutor;

public class SIsMemberExecutor
extends SetExecutor {
    private final int EXISTS = 1;
    private final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SISMEMBER command is \"SISMEMBER key member\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        ByteArrayWrapper member = new ByteArrayWrapper(commandElems.get(2));
        this.checkDataType(key, RedisDataType.REDIS_SET, context);
        Region<?, ?> keyRegion = context.getRegionProvider().getRegion(key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        if (keyRegion.containsKey((Object)member)) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

