/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HSetExecutor
extends HashExecutor
implements Extendable {
    private final int EXISTING_FIELD = 0;
    private final int NEW_FIELD = 1;
    private final int VALUE_INDEX = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_HASH);
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        byte[] value = commandElems.get(3);
        Object oldValue = this.onlySetOnAbsent() ? keyRegion.putIfAbsent((Object)field, (Object)new ByteArrayWrapper(value)) : keyRegion.put((Object)field, (Object)new ByteArrayWrapper(value));
        if (oldValue == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }

    protected boolean onlySetOnAbsent() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the HSET command is \"HSET key field value\"";
    }
}

