/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HIncrByExecutor
extends HashExecutor {
    private final String ERROR_FIELD_NOT_USABLE = "The value at this field is not an integer";
    private final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be numeric";
    private final String ERROR_OVERFLOW = "This incrementation cannot be performed due to overflow";
    private final int FIELD_INDEX = 2;
    private final int INCREMENT_INDEX = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long value;
        long increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HINCRBY command is \"HINCRBY key field increment\""));
            return;
        }
        byte[] incrArray = commandElems.get(3);
        try {
            increment = Coder.bytesToLong(incrArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The increment on this key must be numeric"));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getOrCreateRegion(context, key, RedisDataType.REDIS_HASH);
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        ByteArrayWrapper oldValue = (ByteArrayWrapper)keyRegion.get((Object)field);
        if (oldValue == null) {
            keyRegion.put((Object)field, (Object)new ByteArrayWrapper(incrArray));
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), increment));
            return;
        }
        try {
            value = Long.parseLong(oldValue.toString());
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The value at this field is not an integer"));
            return;
        }
        if (value >= 0L && increment > Long.MAX_VALUE - value || value <= 0L && increment < Long.MIN_VALUE - value) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "This incrementation cannot be performed due to overflow"));
            return;
        }
        keyRegion.put((Object)field, (Object)new ByteArrayWrapper(Coder.longToBytes(value += increment)));
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

