/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HDelExecutor
extends HashExecutor {
    private final int START_FIELDS_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HDEL command is \"HDEL key field [field ...]\""));
            return;
        }
        int numDeleted = 0;
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_HASH, context);
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numDeleted));
            return;
        }
        for (int i = 2; i < commandElems.size(); ++i) {
            ByteArrayWrapper field = new ByteArrayWrapper(commandElems.get(i));
            Object oldValue = keyRegion.remove((Object)field);
            if (oldValue == null) continue;
            ++numDeleted;
        }
        if (keyRegion.isEmpty()) {
            context.getRegionProvider().removeKey(key, RedisDataType.REDIS_HASH);
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numDeleted));
    }
}

