/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.cache.xmlcache.CacheXmlParser;
import org.apache.geode.management.internal.configuration.domain.CacheElement;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Document createDocumentFromReader(Reader reader) throws SAXException, ParserConfigurationException, IOException {
        InputSource inputSource = new InputSource(reader);
        Document doc = XmlUtils.getDocumentBuilder().parse(inputSource);
        return doc;
    }

    public static NodeList query(Node node, String searchString) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (NodeList)xpath.evaluate(searchString, node, XPathConstants.NODESET);
    }

    public static NodeList query(Node node, String searchString, XPathContext xpathcontext) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(xpathcontext);
        return (NodeList)xpath.evaluate(searchString, node, XPathConstants.NODESET);
    }

    public static Element querySingleElement(Node node, String searchString, XPathContext xPathContext) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(xPathContext);
        Object result = xpath.evaluate(searchString, node, XPathConstants.NODE);
        try {
            return (Element)result;
        }
        catch (ClassCastException e) {
            throw new XPathExpressionException("Not an org.w3c.dom.Element: " + result);
        }
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new CacheXmlParser());
        return builder;
    }

    public static void addNewNode(Document doc, XmlEntity xmlEntity) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        LinkedHashMap<String, CacheElement> elementOrderMap = CacheElement.buildElementMap(doc);
        Node newNode = XmlUtils.createNode(doc, xmlEntity.getXmlDefinition());
        Element root = doc.getDocumentElement();
        int incomingElementOrder = XmlUtils.getElementOrder(elementOrderMap, xmlEntity.getNamespace(), xmlEntity.getType());
        boolean nodeAdded = false;
        NodeList nodes = root.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String type = childElement.getLocalName();
            String namespace = childElement.getNamespaceURI();
            if (namespace.equals(xmlEntity.getNamespace()) && type.equals(xmlEntity.getType())) {
                String nameOrId = XmlUtils.getAttribute(childElement, "name");
                if (nameOrId == null) {
                    nameOrId = XmlUtils.getAttribute(childElement, "id");
                }
                if (nameOrId != null) {
                    if (!nameOrId.equals(xmlEntity.getNameOrId())) continue;
                    root.replaceChild(newNode, node);
                    nodeAdded = true;
                    break;
                }
                if (XmlUtils.isMultiple(elementOrderMap, namespace, type)) continue;
                root.replaceChild(newNode, node);
                nodeAdded = true;
                break;
            }
            if (incomingElementOrder >= XmlUtils.getElementOrder(elementOrderMap, namespace, type)) continue;
            root.insertBefore(newNode, node);
            nodeAdded = true;
            break;
        }
        if (!nodeAdded) {
            root.appendChild(newNode);
        }
    }

    private static boolean isMultiple(LinkedHashMap<String, CacheElement> elementOrderMap, String namespace, String type) {
        CacheElement cacheElement;
        if ("http://geode.apache.org/schema/cache".equals(namespace) && null != (cacheElement = elementOrderMap.get(type))) {
            return cacheElement.isMultiple();
        }
        return false;
    }

    private static int getElementOrder(LinkedHashMap<String, CacheElement> elementOrderMap, String namespace, String type) {
        CacheElement cacheElement;
        if ("http://geode.apache.org/schema/cache".equals(namespace) && null != (cacheElement = elementOrderMap.get(type))) {
            return cacheElement.getOrder();
        }
        return Integer.MAX_VALUE;
    }

    private static Node createNode(Document owner, String xmlDefinition) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = new InputSource(new StringReader(xmlDefinition));
        Document document = XmlUtils.getDocumentBuilder().parse(inputSource);
        Element newNode = document.getDocumentElement();
        return owner.importNode(newNode, true);
    }

    public static String getAttribute(Node node, String name) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attributeNode = node.getAttributes().getNamedItem(name);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getTextContent();
    }

    public static String getAttribute(Node node, String localName, String namespaceURI) {
        Node attributeNode = node.getAttributes().getNamedItemNS(namespaceURI, localName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getTextContent();
    }

    public static Map<String, String> buildSchemaLocationMap(String schemaLocation) {
        HashMap<String, String> schemaLocationMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)schemaLocation)) {
            return schemaLocationMap;
        }
        StringTokenizer st = new StringTokenizer(schemaLocation, " \n\t\r");
        while (st.hasMoreElements()) {
            String ns = st.nextToken();
            String loc = st.nextToken();
            schemaLocationMap.put(ns, loc);
        }
        return schemaLocationMap;
    }

    public static void deleteNode(Document doc, XmlEntity xmlEntity) throws Exception {
        NodeList nodes = XmlUtils.getNodes(doc, xmlEntity);
        if (nodes != null) {
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                node.getParentNode().removeChild(node);
            }
        }
    }

    public static NodeList getNodes(Document doc, XmlEntity xmlEntity) throws XPathExpressionException {
        XPathContext context = new XPathContext();
        context.addNamespace(xmlEntity.getPrefix(), xmlEntity.getNamespace());
        if (xmlEntity.getChildPrefix() != null) {
            context.addNamespace(xmlEntity.getChildPrefix(), xmlEntity.getChildNamespace());
        }
        return XmlUtils.query(doc, xmlEntity.getSearchString(), context);
    }

    public static String prettyXml(Node doc) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        return XmlUtils.transform(transformer, doc);
    }

    public static String elementToString(Node element) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        return XmlUtils.transform(transformer, element);
    }

    private static String transform(Transformer transformer, Node element) throws TransformerException {
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(element);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static String prettyXml(String xmlContent) throws IOException, TransformerFactoryConfigurationError, TransformerException, SAXException, ParserConfigurationException {
        Document doc = XmlUtils.createDocumentFromXml(xmlContent);
        return XmlUtils.prettyXml(doc);
    }

    public static Document createDocumentFromXml(String xmlContent) throws SAXException, ParserConfigurationException, IOException {
        return XmlUtils.createDocumentFromReader(new StringReader(xmlContent));
    }

    public static Document createAndUpgradeDocumentFromXml(String xmlContent) throws SAXException, ParserConfigurationException, IOException, XPathExpressionException {
        Document doc = XmlUtils.createDocumentFromXml(xmlContent);
        if (!"1.0".equals(XmlUtils.getAttribute(doc.getDocumentElement(), "version", "http://geode.apache.org/schema/cache"))) {
            doc = XmlUtils.upgradeSchema(doc, "http://geode.apache.org/schema/cache", "http://geode.apache.org/schema/cache/cache-1.0.xsd", "1.0");
        }
        return doc;
    }

    public static Document upgradeSchema(Document document, String namespaceUri, String schemaLocation, String schemaVersion) throws XPathExpressionException, ParserConfigurationException {
        String oldNamespaceUri;
        Element root;
        if (StringUtils.isBlank((CharSequence)namespaceUri)) {
            throw new IllegalArgumentException("namespaceUri");
        }
        if (StringUtils.isBlank((CharSequence)schemaLocation)) {
            throw new IllegalArgumentException("schemaLocation");
        }
        if (StringUtils.isBlank((CharSequence)schemaVersion)) {
            throw new IllegalArgumentException("schemaVersion");
        }
        if (null != document.getDoctype()) {
            root = document.getDocumentElement();
            Document copiedDocument = XmlUtils.getDocumentBuilder().newDocument();
            Node copiedRoot = copiedDocument.importNode(root, true);
            copiedDocument.appendChild(copiedRoot);
            document = copiedDocument;
        }
        if (!namespaceUri.equals(oldNamespaceUri = (root = document.getDocumentElement()).getNamespaceURI())) {
            XmlUtils.changeNamespace(root, oldNamespaceUri, namespaceUri);
        }
        root.setAttribute("version", schemaVersion);
        Attr schemaLocationAttr = root.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        String xsiPrefix = XmlUtils.findPrefix(root, "http://www.w3.org/2001/XMLSchema-instance");
        Map<Object, Object> uriToLocation = new HashMap();
        if (schemaLocationAttr != null) {
            uriToLocation = XmlUtils.buildSchemaLocationMap(schemaLocationAttr.getNodeValue());
        } else if (xsiPrefix == null) {
            xsiPrefix = "xsi";
            root.setAttribute("xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        uriToLocation.remove(oldNamespaceUri);
        uriToLocation.put(namespaceUri, schemaLocation);
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", xsiPrefix + ":" + "schemaLocation", XmlUtils.getSchemaLocationValue(uriToLocation));
        return document;
    }

    private static String getSchemaLocationValue(Map<String, String> schemaLocationMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : schemaLocationMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(entry.getKey()).append(' ').append(entry.getValue());
        }
        return sb.toString();
    }

    static String findPrefix(Element root, String namespaceUri) {
        NamedNodeMap attributes = root.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            if (!item.getNodeName().startsWith("xmlns") || !item.getNodeValue().equals(namespaceUri)) continue;
            String[] splitName = item.getNodeName().split(":");
            if (splitName.length > 1) {
                return splitName[1];
            }
            return "";
        }
        return null;
    }

    static Node changeNamespace(Node node, String oldNamespaceUri, String newNamespaceUri) throws XPathExpressionException {
        Node result = null;
        NodeList nodes = XmlUtils.query(node, "//*");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node element = nodes.item(i);
            if (element.getNamespaceURI() != null && !element.getNamespaceURI().equals(oldNamespaceUri)) continue;
            Node renamed = node.getOwnerDocument().renameNode(element, newNamespaceUri, element.getNodeName());
            if (element != node) continue;
            result = renamed;
        }
        return result;
    }

    public static void modifyRootAttributes(Document doc, XmlEntity xmlEntity) {
        if (xmlEntity == null || xmlEntity.getAttributes() == null) {
            return;
        }
        String type = xmlEntity.getType();
        Map<String, String> attributes = xmlEntity.getAttributes();
        Element root = doc.getDocumentElement();
        if (root.getLocalName().equals(type)) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                String attributeValue = entry.getValue();
                String rootAttribute = XmlUtils.getAttribute(root, attributeName);
                if (null != rootAttribute) {
                    root.removeAttribute(rootAttribute);
                }
                root.setAttribute(attributeName, attributeValue);
            }
        }
    }

    public static class XPathContext
    implements NamespaceContext {
        private HashMap<String, String> prefixToUri = new HashMap();
        private HashMap<String, String> uriToPrefix = new HashMap();

        public XPathContext() {
        }

        public XPathContext(String prefix, String uri) {
            this.addNamespace(prefix, uri);
        }

        public void addNamespace(String prefix, String uri) {
            this.prefixToUri.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.prefixToUri.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.uriToPrefix.get(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
        }
    }
}

