/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.backup.BackupInspector;
import org.apache.geode.internal.cache.backup.IncrementalBackupLocation;
import org.apache.geode.internal.util.TransformUtils;

class FileSystemIncrementalBackupLocation
implements IncrementalBackupLocation {
    private static final String INCOMPLETE_BACKUP_FILE = "INCOMPLETE_BACKUP_FILE";
    private final Path memberBackupLocationDir;

    FileSystemIncrementalBackupLocation(File backupLocationDir, String memberId) {
        this.memberBackupLocationDir = new File(backupLocationDir, memberId).toPath();
    }

    Path getMemberBackupLocationDir() {
        return this.memberBackupLocationDir;
    }

    @Override
    public Map<String, File> getBackedUpOplogs(DiskStore diskStore) throws IOException {
        File checkedBaselineDir = this.checkBaseline(diskStore);
        if (checkedBaselineDir == null) {
            return Collections.emptyMap();
        }
        Collection<File> baselineOplogFiles = this.getBackedUpOplogs(checkedBaselineDir, diskStore);
        baselineOplogFiles.addAll(this.getPreviouslyBackedUpOpLogs(checkedBaselineDir));
        return TransformUtils.transformAndMap(baselineOplogFiles, TransformUtils.getFileNameTransformer());
    }

    Collection<File> getBackedUpOplogs(File checkedBaselineDir, DiskStore diskStore) {
        File baselineDir = new File(checkedBaselineDir, "diskstores");
        baselineDir = new File(baselineDir, this.getBackupDirName((DiskStoreImpl)diskStore));
        return FileUtils.listFiles(baselineDir, new String[]{"krf", "drf", "crf"}, true);
    }

    Collection<File> getPreviouslyBackedUpOpLogs(File checkedBaselineDir) throws IOException {
        BackupInspector inspector = this.createBackupInspector(checkedBaselineDir);
        HashSet<File> oplogs = new HashSet<File>();
        if (inspector.isIncremental() && inspector.getIncrementalOplogFileNames() != null) {
            inspector.getIncrementalOplogFileNames().forEach(oplog -> {
                oplog = inspector.getCopyFromForOplogFile((String)oplog);
                oplogs.add(new File((String)oplog));
            });
        }
        return oplogs;
    }

    BackupInspector createBackupInspector(File checkedBaselineDir) throws IOException {
        return BackupInspector.createInspector(checkedBaselineDir);
    }

    private File checkBaseline(DiskStore diskStore) {
        File incompleteBackup;
        File baselineDir = this.memberBackupLocationDir.toFile();
        if (!baselineDir.exists()) {
            baselineDir = this.findBaselineForThisMember(this.memberBackupLocationDir.getParent(), diskStore);
        }
        if (null != baselineDir && (incompleteBackup = new File(baselineDir, INCOMPLETE_BACKUP_FILE)).exists()) {
            baselineDir = null;
        }
        return baselineDir;
    }

    private File findBaselineForThisMember(Path baselineParentDir, DiskStore diskStore) {
        File baselineDir = null;
        File[] matchingFiles = baselineParentDir.toFile().listFiles((file, name) -> name.endsWith(this.getBackupDirName((DiskStoreImpl)diskStore)));
        if (null != matchingFiles && matchingFiles.length > 0) {
            baselineDir = matchingFiles[0].getParentFile().getParentFile();
        }
        return baselineDir;
    }

    String getBackupDirName(DiskStoreImpl diskStore) {
        String name = diskStore.getName();
        if (name == null) {
            name = GemFireCacheImpl.getDefaultDiskStoreName();
        }
        return name + "_" + diskStore.getDiskStoreID().toString();
    }
}

