/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.hbase.avro;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.hbase.client.HTablePool;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.hbase.avro.AvroEntityComposer;
import org.kitesdk.data.hbase.avro.AvroEntitySchema;
import org.kitesdk.data.hbase.avro.AvroEntitySerDe;
import org.kitesdk.data.hbase.avro.AvroKeyEntitySchemaParser;
import org.kitesdk.data.hbase.avro.AvroKeySchema;
import org.kitesdk.data.hbase.avro.AvroKeySerDe;
import org.kitesdk.data.hbase.avro.AvroUtils;
import org.kitesdk.data.hbase.avro.VersionedAvroEntityMapper;
import org.kitesdk.data.hbase.impl.BaseDao;
import org.kitesdk.data.hbase.impl.BaseEntityMapper;
import org.kitesdk.data.hbase.impl.CompositeBaseDao;
import org.kitesdk.data.hbase.impl.Dao;
import org.kitesdk.data.hbase.impl.EntityMapper;
import org.kitesdk.data.hbase.impl.SchemaManager;
import org.kitesdk.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificAvroDao<E extends SpecificRecord>
extends BaseDao<E> {
    private static Logger LOG = LoggerFactory.getLogger(SpecificAvroDao.class);
    private static final AvroKeyEntitySchemaParser parser = new AvroKeyEntitySchemaParser();

    public SpecificAvroDao(HTablePool tablePool, String tableName, String entitySchemaString, Class<E> entityClass) {
        super(tablePool, tableName, SpecificAvroDao.buildEntityMapper(entitySchemaString, entitySchemaString, entityClass));
    }

    public SpecificAvroDao(HTablePool tablePool, String tableName, InputStream entitySchemaStream, Class<E> entityClass) {
        this(tablePool, tableName, AvroUtils.inputStreamToString(entitySchemaStream), entityClass);
    }

    public SpecificAvroDao(HTablePool tablePool, String tableName, String entityName, SchemaManager schemaManager) {
        super(tablePool, tableName, new VersionedAvroEntityMapper.Builder().setSchemaManager(schemaManager).setTableName(tableName).setEntityName(entityName).setSpecific(true).build());
    }

    public static <E extends SpecificRecord, S extends SpecificRecord> Dao<E> buildCompositeDao(HTablePool tablePool, String tableName, List<String> subEntitySchemaStrings, Class<E> entityClass) {
        ArrayList entityMappers = new ArrayList();
        for (String subEntitySchemaString : subEntitySchemaStrings) {
            Class<?> subEntityClass;
            AvroEntitySchema subEntitySchema = parser.parseEntitySchema(subEntitySchemaString);
            try {
                subEntityClass = Class.forName(subEntitySchema.getAvroSchema().getFullName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            entityMappers.add(SpecificAvroDao.buildEntityMapper(subEntitySchemaString, subEntitySchemaString, subEntityClass));
        }
        return new SpecificCompositeAvroDao(tablePool, tableName, entityMappers, entityClass);
    }

    public static <K extends SpecificRecord, S extends SpecificRecord> Dao<Map<String, S>> buildCompositeDao(HTablePool tablePool, String tableName, List<String> subEntitySchemaStrings) {
        ArrayList entityMappers = new ArrayList();
        for (String subEntitySchemaString : subEntitySchemaStrings) {
            Class<?> subEntityClass;
            AvroEntitySchema subEntitySchema = parser.parseEntitySchema(subEntitySchemaString);
            try {
                subEntityClass = Class.forName(subEntitySchema.getAvroSchema().getFullName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            entityMappers.add(SpecificAvroDao.buildEntityMapper(subEntitySchemaString, subEntitySchemaString, subEntityClass));
        }
        return new SpecificMapCompositeAvroDao(tablePool, tableName, entityMappers);
    }

    public static <E extends SpecificRecord, S extends SpecificRecord> Dao<E> buildCompositeDaoWithInputStream(HTablePool tablePool, String tableName, List<InputStream> subEntitySchemaStreams, Class<E> entityClass) {
        ArrayList<String> subEntitySchemaStrings = new ArrayList<String>();
        for (InputStream subEntitySchemaStream : subEntitySchemaStreams) {
            subEntitySchemaStrings.add(AvroUtils.inputStreamToString(subEntitySchemaStream));
        }
        return SpecificAvroDao.buildCompositeDao(tablePool, tableName, subEntitySchemaStrings, entityClass);
    }

    public static <K extends SpecificRecord, E extends SpecificRecord, S extends SpecificRecord> Dao<E> buildCompositeDaoWithEntityManager(HTablePool tablePool, String tableName, Class<E> entityClass, SchemaManager schemaManager) {
        Schema entitySchema = SpecificAvroDao.getSchemaFromEntityClass(entityClass);
        ArrayList entityMappers = new ArrayList();
        for (Schema.Field field : entitySchema.getFields()) {
            entityMappers.add(new VersionedAvroEntityMapper.Builder().setSchemaManager(schemaManager).setTableName(tableName).setEntityName(SpecificAvroDao.getSchemaName(field.schema())).setSpecific(true).build());
        }
        return new SpecificCompositeAvroDao(tablePool, tableName, entityMappers, entityClass);
    }

    private static String getSchemaName(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            List types = schema.getTypes();
            if (types.size() == 2) {
                if (((Schema)types.get(0)).getType() == Schema.Type.NULL) {
                    return ((Schema)types.get(1)).getName();
                }
                if (((Schema)types.get(1)).getType() == Schema.Type.NULL) {
                    return ((Schema)types.get(0)).getName();
                }
            }
            throw new IllegalArgumentException("Unsupported union schema: " + schema);
        }
        return schema.getName();
    }

    public static <K extends SpecificRecord, S extends SpecificRecord> Dao<Map<String, S>> buildCompositeDaoWithEntityManager(HTablePool tablePool, String tableName, List<Class<S>> subEntityClasses, SchemaManager schemaManager) {
        ArrayList entityMappers = new ArrayList();
        for (Class<S> subEntityClass : subEntityClasses) {
            String entityName = SpecificAvroDao.getSchemaFromEntityClass(subEntityClass).getName();
            entityMappers.add(new VersionedAvroEntityMapper.Builder().setSchemaManager(schemaManager).setTableName(tableName).setEntityName(entityName).setSpecific(true).build());
        }
        return new SpecificMapCompositeAvroDao(tablePool, tableName, entityMappers);
    }

    private static Schema getSchemaFromEntityClass(Class<?> entityClass) {
        try {
            return (Schema)entityClass.getDeclaredField("SCHEMA$").get(null);
        }
        catch (Throwable e) {
            LOG.error("Error getting schema from entity of type: " + entityClass.getName(), e);
            throw new DatasetException(e);
        }
    }

    private static <E extends SpecificRecord> BaseEntityMapper<E> buildEntityMapper(String readerSchemaStr, String writtenSchemaStr, Class<E> entityClass) {
        AvroEntitySchema readerSchema = parser.parseEntitySchema(readerSchemaStr);
        readerSchema = AvroUtils.mergeSpecificStringTypes(entityClass, readerSchema);
        AvroEntitySchema writtenSchema = parser.parseEntitySchema(writtenSchemaStr);
        AvroEntityComposer entityComposer = new AvroEntityComposer(readerSchema, true);
        AvroEntitySerDe entitySerDe = new AvroEntitySerDe(entityComposer, readerSchema, writtenSchema, true);
        AvroKeySchema keySchema = parser.parseKeySchema(readerSchemaStr);
        keySchema = AvroUtils.mergeSpecificStringTypes(entityClass, keySchema);
        AvroKeySerDe keySerDe = new AvroKeySerDe(keySchema.getAvroSchema(), keySchema.getPartitionStrategy());
        return new BaseEntityMapper(keySchema, readerSchema, keySerDe, entitySerDe);
    }

    private static class SpecificMapCompositeAvroDao<S extends SpecificRecord>
    extends CompositeBaseDao<Map<String, S>, S> {
        private final List<Schema> subEntitySchemas = Lists.newArrayList();

        public SpecificMapCompositeAvroDao(HTablePool tablePool, String tableName, List<EntityMapper<S>> entityMappers) {
            super(tablePool, tableName, entityMappers);
            for (EntityMapper<S> entityMapper : entityMappers) {
                this.subEntitySchemas.add(parser.parseEntitySchema(entityMapper.getEntitySchema().getRawSchema()).getAvroSchema());
            }
        }

        @Override
        public Map<String, S> compose(List<S> entities) {
            HashMap<String, SpecificRecord> retEntity = new HashMap<String, SpecificRecord>();
            int cnt = 0;
            for (SpecificRecord entity : entities) {
                if (entity != null) {
                    retEntity.put(this.subEntitySchemas.get(cnt).getName(), entity);
                }
                ++cnt;
            }
            return retEntity;
        }

        @Override
        public List<S> decompose(Map<String, S> entity) {
            ArrayList<S> subEntityList = new ArrayList<S>();
            for (Schema s : this.subEntitySchemas) {
                subEntityList.add(entity.get(s.getName()));
            }
            return subEntityList;
        }
    }

    private static class SpecificCompositeAvroDao<E extends SpecificRecord, S extends SpecificRecord>
    extends CompositeBaseDao<E, S> {
        private final Class<E> entityClass;
        private final Constructor<E> entityConstructor;
        private final Schema entitySchema;

        public SpecificCompositeAvroDao(HTablePool tablePool, String tableName, List<EntityMapper<S>> entityMappers, Class<E> entityClass) {
            super(tablePool, tableName, entityMappers);
            this.entityClass = entityClass;
            try {
                this.entityConstructor = entityClass.getConstructor(new Class[0]);
                this.entitySchema = (Schema)entityClass.getDeclaredField("SCHEMA$").get(null);
            }
            catch (Throwable e) {
                LOG.error("Error getting constructor or schema field for entity of type: " + entityClass.getName(), e);
                throw new DatasetException(e);
            }
        }

        @Override
        public E compose(List<S> subEntities) {
            SpecificRecord entity;
            try {
                entity = (SpecificRecord)this.entityConstructor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                LOG.error("Error trying to construct entity of type: " + this.entityClass.getName(), e);
                throw new DatasetException(e);
            }
            int cnt = 0;
            for (SpecificRecord subEntity : subEntities) {
                if (subEntity != null) {
                    entity.put(cnt, (Object)subEntity);
                }
                ++cnt;
            }
            return (E)entity;
        }

        @Override
        public List<S> decompose(E entity) {
            ArrayList<SpecificRecord> subEntityList = new ArrayList<SpecificRecord>();
            for (int i = 0; i < this.entitySchema.getFields().size(); ++i) {
                subEntityList.add((SpecificRecord)entity.get(i));
            }
            return subEntityList;
        }
    }
}

