/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.jms;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.source.jms.JMSDestinationLocator;
import org.apache.flume.source.jms.JMSDestinationType;
import org.apache.flume.source.jms.JMSMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMSMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JMSMessageConsumer.class);
    private final int batchSize;
    private final long pollTimeout;
    private final JMSMessageConverter messageConverter;
    private final Connection connection;
    private final Session session;
    private final Destination destination;
    private final MessageConsumer messageConsumer;

    JMSMessageConsumer(InitialContext initialContext, ConnectionFactory connectionFactory, String destinationName, JMSDestinationLocator destinationLocator, JMSDestinationType destinationType, String messageSelector, int batchSize, long pollTimeout, JMSMessageConverter messageConverter, Optional<String> userName, Optional<String> password, Optional<String> clientId, boolean createDurableSubscription, String durableSubscriptionName) {
        this.batchSize = batchSize;
        this.pollTimeout = pollTimeout;
        this.messageConverter = messageConverter;
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"Batch size must be greater than zero");
        Preconditions.checkArgument((pollTimeout >= 0L ? 1 : 0) != 0, (Object)"Poll timeout cannot be negative");
        try {
            block17: {
                try {
                    this.connection = userName.isPresent() ? connectionFactory.createConnection((String)userName.get(), (String)password.get()) : connectionFactory.createConnection();
                    if (clientId.isPresent()) {
                        this.connection.setClientID((String)clientId.get());
                    }
                    this.connection.start();
                }
                catch (JMSException e) {
                    throw new FlumeException("Could not create connection to broker", (Throwable)e);
                }
                try {
                    this.session = this.connection.createSession(true, 0);
                }
                catch (JMSException e) {
                    throw new FlumeException("Could not create session", (Throwable)e);
                }
                try {
                    if (destinationLocator.equals((Object)JMSDestinationLocator.CDI)) {
                        switch (destinationType) {
                            case QUEUE: {
                                this.destination = this.session.createQueue(destinationName);
                                break block17;
                            }
                            case TOPIC: {
                                this.destination = this.session.createTopic(destinationName);
                                break block17;
                            }
                            default: {
                                throw new IllegalStateException(String.valueOf((Object)destinationType));
                            }
                        }
                    }
                    this.destination = (Destination)initialContext.lookup(destinationName);
                }
                catch (JMSException e) {
                    throw new FlumeException("Could not create destination " + destinationName, (Throwable)e);
                }
                catch (NamingException e) {
                    throw new FlumeException("Could not find destination " + destinationName, (Throwable)e);
                }
            }
            try {
                this.messageConsumer = createDurableSubscription ? this.session.createDurableSubscriber((Topic)this.destination, durableSubscriptionName, messageSelector.isEmpty() ? null : messageSelector, true) : this.session.createConsumer(this.destination, messageSelector.isEmpty() ? null : messageSelector);
            }
            catch (JMSException e) {
                throw new FlumeException("Could not create consumer", (Throwable)e);
            }
            String startupMsg = String.format("Connected to '%s' of type '%s' with user '%s', batch size '%d', selector '%s' ", new Object[]{destinationName, destinationType, userName.isPresent() ? userName.get() : "null", batchSize, messageSelector.isEmpty() ? null : messageSelector});
            logger.info(startupMsg);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    List<Event> take() throws JMSException {
        ArrayList<Event> result = new ArrayList<Event>(this.batchSize);
        Message message = this.receive();
        if (message != null) {
            result.addAll(this.messageConverter.convert(message));
            int max = this.batchSize - 1;
            for (int i = 0; i < max && (message = this.receiveNoWait()) != null; ++i) {
                result.addAll(this.messageConverter.convert(message));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Took batch of %s from %s", result.size(), this.destination));
        }
        return result;
    }

    private Message receive() throws JMSException {
        try {
            return this.messageConsumer.receive(this.pollTimeout);
        }
        catch (RuntimeException runtimeException) {
            JMSException jmsException = new JMSException("JMS provider has thrown runtime exception: " + runtimeException.getMessage());
            jmsException.setLinkedException((Exception)runtimeException);
            throw jmsException;
        }
    }

    private Message receiveNoWait() throws JMSException {
        try {
            return this.messageConsumer.receiveNoWait();
        }
        catch (RuntimeException runtimeException) {
            JMSException jmsException = new JMSException("JMS provider has thrown runtime exception: " + runtimeException.getMessage());
            jmsException.setLinkedException((Exception)runtimeException);
            throw jmsException;
        }
    }

    void commit() {
        try {
            this.session.commit();
        }
        catch (JMSException jmsException) {
            logger.warn("JMS Exception processing commit", (Throwable)jmsException);
        }
        catch (RuntimeException runtimeException) {
            logger.warn("Runtime Exception processing commit", (Throwable)runtimeException);
        }
    }

    void rollback() {
        try {
            this.session.rollback();
        }
        catch (JMSException jmsException) {
            logger.warn("JMS Exception processing rollback", (Throwable)jmsException);
        }
        catch (RuntimeException runtimeException) {
            logger.warn("Runtime Exception processing rollback", (Throwable)runtimeException);
        }
    }

    void close() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (JMSException e) {
            logger.error("Could not destroy session", (Throwable)e);
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            logger.error("Could not destroy connection", (Throwable)e);
        }
    }
}

