/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class ReplicationUtils$
implements Logging {
    public static final ReplicationUtils$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicationUtils$();
    }

    private Logger logger$lzycompute() {
        ReplicationUtils$ replicationUtils$ = this;
        synchronized (replicationUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    @TraitSetter
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Tuple2<Object, Object> updateLeaderAndIsr(KafkaZkClient zkClient, TopicPartition partition, LeaderAndIsr newLeaderAndIsr, int controllerEpoch) {
        this.debug((Function0<String>)new Serializable(partition, newLeaderAndIsr){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition$1;
            private final LeaderAndIsr newLeaderAndIsr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated ISR for ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$1, this.newLeaderAndIsr$1.isr().mkString(",")}));
            }
            {
                this.partition$1 = partition$1;
                this.newLeaderAndIsr$1 = newLeaderAndIsr$1;
            }
        });
        String path = TopicPartitionStateZNode$.MODULE$.path(partition);
        byte[] newLeaderData = TopicPartitionStateZNode$.MODULE$.encode(new LeaderIsrAndControllerEpoch(newLeaderAndIsr, controllerEpoch));
        Tuple2<Object, Object> updatePersistentPath = zkClient.conditionalUpdatePath(path, newLeaderData, newLeaderAndIsr.zkVersion(), (Option<Function3<KafkaZkClient, String, byte[], Tuple2<Object, Object>>>)new Some((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(KafkaZkClient zkClient, String path, byte[] expectedLeaderAndIsrInfo) {
                return ReplicationUtils$.MODULE$.kafka$utils$ReplicationUtils$$checkLeaderAndIsrZkData(zkClient, path, expectedLeaderAndIsrInfo);
            }
        }));
        return updatePersistentPath;
    }

    public Tuple2<Object, Object> kafka$utils$ReplicationUtils$$checkLeaderAndIsrZkData(KafkaZkClient zkClient, String path, byte[] expectedLeaderAndIsrInfo) {
        Tuple2.mcZI.sp sp2;
        block3: {
            try {
                Tuple2<Option<byte[]>, Stat> tuple2 = zkClient.getDataAndStat(path);
                if (tuple2 != null) {
                    Option<LeaderIsrAndControllerEpoch> expectedLeaderOpt;
                    Stat writtenStat;
                    Stat writtenStat2;
                    Option writtenLeaderOpt = (Option)tuple2._1();
                    Tuple2 tuple22 = new Tuple2((Object)writtenLeaderOpt, (Object)(writtenStat2 = (Stat)tuple2._2()));
                    Tuple2 tuple23 = tuple22;
                    Option writtenLeaderOpt2 = (Option)tuple23._1();
                    boolean succeeded = BoxesRunTime.unboxToBoolean((Object)writtenLeaderOpt2.map((Function1)new Serializable(writtenStat = (Stat)tuple23._2(), expectedLeaderOpt = TopicPartitionStateZNode$.MODULE$.decode(expectedLeaderAndIsrInfo, writtenStat)){
                        public static final long serialVersionUID = 0L;
                        private final Stat writtenStat$1;
                        private final Option expectedLeaderOpt$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(byte[] writtenData) {
                            Option<LeaderIsrAndControllerEpoch> writtenLeaderOpt = TopicPartitionStateZNode$.MODULE$.decode(writtenData, this.writtenStat$1);
                            Tuple2 tuple2 = new Tuple2((Object)this.expectedLeaderOpt$1, writtenLeaderOpt);
                            if (tuple2 == null) return false;
                            Option option = (Option)tuple2._1();
                            Option option2 = (Option)tuple2._2();
                            if (!(option instanceof Some)) return false;
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch expectedLeader = (LeaderIsrAndControllerEpoch)some.x();
                            if (!(option2 instanceof Some)) return false;
                            Some some2 = (Some)option2;
                            LeaderIsrAndControllerEpoch writtenLeader = (LeaderIsrAndControllerEpoch)some2.x();
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = expectedLeader;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = writtenLeader;
                            if (leaderIsrAndControllerEpoch != null) {
                                if (!((Object)leaderIsrAndControllerEpoch).equals(leaderIsrAndControllerEpoch2)) return false;
                                return true;
                            }
                            if (leaderIsrAndControllerEpoch2 == null) return true;
                            return false;
                        }
                        {
                            this.writtenStat$1 = writtenStat$1;
                            this.expectedLeaderOpt$1 = expectedLeaderOpt$1;
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    }));
                    sp2 = succeeded ? new Tuple2.mcZI.sp(true, writtenStat.getVersion()) : new Tuple2.mcZI.sp(false, -1);
                    break block3;
                }
                throw new MatchError(tuple2);
            }
            catch (Exception exception) {
                sp2 = new Tuple2.mcZI.sp(false, -1);
            }
        }
        return sp2;
    }

    private ReplicationUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

