/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003\u00165s_R$H.\u001a3DQ\u0006tg.\u001a7\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u00111A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Ua\u0011\u0001B;uS2L!a\u0006\n\u0003\u000f\u0011+G.Y=fIB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004B\u0001\u0006kRLGn]\u0005\u0003;i\u0011q\u0001T8hO&tw\r\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0001!\u0003\u001d\u0011X-];fgR,\u0012!\t\t\u0003E!r!a\t\u0014\u000e\u0003\u0011R!!\n\u0003\u0002\u000f9,Go^8sW&\u0011q\u0005J\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\tI#FA\u0004SKF,Xm\u001d;\u000b\u0005\u001d\"\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u0011I,\u0017/^3ti\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\taL\u0001\u0005i&lW-F\u00011!\t\t$(D\u00013\u0015\tY2G\u0003\u00025k\u000511m\\7n_:T!!\u0002\u001c\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0005\u0003wI\u0012A\u0001V5nK\"AQ\b\u0001B\u0001B\u0003%\u0001'A\u0003uS6,\u0007\u0005\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u00039!\bN]8ui2,G+[7f\u001bN,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0004\u0013:$\b\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u001fQD'o\u001c;uY\u0016$\u0016.\\3Ng\u0002B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\u001aG\"\fgN\\3m)\"\u0014x\u000e\u001e;mS:<7)\u00197mE\u0006\u001c7\u000e\u0005\u0003C\u0019:K\u0016BA'D\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002P/:\u0011\u0001K\n\b\u0003#Zs!AU+\u000e\u0003MS!\u0001\u0016\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0013\u0005\u0013\tA&F\u0001\u0005SKN\u0004xN\\:f!\t\u0011%,\u0003\u0002\\\u0007\n!QK\\5u\u0011\u0015i\u0006\u0001\"\u0001_\u0003\u0019a\u0014N\\5u}Q)q,\u00192dIB\u0011\u0001\rA\u0007\u0002\u0005!)q\u0004\u0018a\u0001C!)a\u0006\u0018a\u0001a!)q\b\u0018a\u0001\u0003\")!\n\u0018a\u0001\u0017\"9a\r\u0001a\u0001\n\u00039\u0017aB3oIRKW.Z\u000b\u0002QB\u0011!)[\u0005\u0003U\u000e\u0013A\u0001T8oO\"9A\u000e\u0001a\u0001\n\u0003i\u0017aC3oIRKW.Z0%KF$\"!\u00178\t\u000f=\\\u0017\u0011!a\u0001Q\u0006\u0019\u0001\u0010J\u0019\t\rE\u0004\u0001\u0015)\u0003i\u0003!)g\u000e\u001a+j[\u0016\u0004\u0003\"B:\u0001\t\u0003!\u0018\u0001\u00068pi&4\u0017\u0010\u00165s_R$H.\u001b8h\t>tW\rF\u0001Z\u0011\u00151\b\u0001\"\u0011x\u0003!9W\r\u001e#fY\u0006LHC\u00015y\u0011\u0015IX\u000f1\u0001{\u0003\u0011)h.\u001b;\u0011\u0005EY\u0018B\u0001?\u0013\u0005!!\u0016.\\3V]&$\b\"\u0002@\u0001\t\u0003z\u0018!C2p[B\f'/\u001a+p)\r\t\u0015\u0011\u0001\u0005\u0007\u0003\u0007i\b\u0019\u0001\t\u0002\u0003\u0011\u0004")
public class ThrottledChannel
implements Delayed,
Logging {
    private final RequestChannel.Request request;
    private final Time time;
    private final int throttleTimeMs;
    private final Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback;
    private long endTime;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ThrottledChannel throttledChannel = this;
        synchronized (throttledChannel) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public RequestChannel.Request request() {
        return this.request;
    }

    public Time time() {
        return this.time;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public long endTime() {
        return this.endTime;
    }

    public void endTime_$eq(long x$1) {
        this.endTime = x$1;
    }

    public void notifyThrottlingDone() {
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ThrottledChannel $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Channel throttled for: ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.throttleTimeMs())).append((Object)" ms").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.channelThrottlingCallback.apply((Object)new RequestChannel.EndThrottlingResponse(this.request()));
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTime() - this.time().milliseconds(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        ThrottledChannel other = (ThrottledChannel)d;
        return this.endTime() < other.endTime() ? -1 : (this.endTime() > other.endTime() ? 1 : 0);
    }

    public ThrottledChannel(RequestChannel.Request request, Time time, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        this.request = request;
        this.time = time;
        this.throttleTimeMs = throttleTimeMs;
        this.channelThrottlingCallback = channelThrottlingCallback;
        Logging$class.$init$(this);
        this.endTime = time.milliseconds() + (long)throttleTimeMs;
        channelThrottlingCallback.apply((Object)new RequestChannel.StartThrottlingResponse(request));
    }
}

