/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tue!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007y1\u0013F\u0004\u0002 I9\u0011\u0001eI\u0007\u0002C)\u0011!eG\u0001\u0007yI|w\u000e\u001e \n\u0003)I!!J\u0005\u0002\u000fA\f7m[1hK&\u0011q\u0005\u000b\u0002\u0004'\u0016\f(BA\u0013\n!\tQs&D\u0001,\u0015\taS&\u0001\u0002j_*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u00111\u0015\u000e\\3\t\u0011I\u0002!\u0011!Q\u0001\nu\t\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005!An\\4t+\u00051\u0004\u0003\u0002\b8s\u0011K!\u0001O\b\u0003\tA{w\u000e\u001c\t\u0003u\tk\u0011a\u000f\u0006\u0003yu\naaY8n[>t'BA\u0003?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\r[$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u000b\u001ak\u0011AA\u0005\u0003\u000f\n\u00111\u0001T8h\u0011!I\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!k\u0014\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\u0011Q\u0003!\u0011!Q\u0001\n5\u000bQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u0002F\u0001!)!$\u0016a\u0001;!)A'\u0016a\u0001m!)1*\u0016a\u0001\u001b\")Q\f\u0001C)=\u0006QAn\\4hKJt\u0015-\\3\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u0017\u0002\t1\fgnZ\u0005\u0003I\u0006\u0014aa\u0015;sS:<\u0007\u0002\u00034\u0001\u0005\u0004%\tA\u00010\u0002)=4gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f\u0011\u0019A\u0007\u0001)A\u0005?\u0006)rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u0004\u0003b\u00026\u0001\u0001\u0004%Ia[\u0001\fG\",7m\u001b9pS:$8/F\u0001m!\u0011i'/\u000b;\u000e\u00039T!a\u001c9\u0002\u0013%lW.\u001e;bE2,'BA9\n\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003g:\u00141!T1q!\t)x/D\u0001w\u0015\tQw*\u0003\u0002ym\n!rJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016DqA\u001f\u0001A\u0002\u0013%10A\bdQ\u0016\u001c7\u000e]8j]R\u001cx\fJ3r)\tax\u0010\u0005\u0002\t{&\u0011a0\u0003\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0002e\f\t\u00111\u0001m\u0003\rAH%\r\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003m\u00031\u0019\u0007.Z2la>Lg\u000e^:!Q\u0011\t\u0019!!\u0003\u0011\u0007!\tY!C\u0002\u0002\u000e%\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'\t!\"\u001b8Qe><'/Z:t+\t\t)\u0002E\u0004\u0002\u0018\u0005u\u0011(!\t\u000e\u0005\u0005e!bAA\u000ea\u00069Q.\u001e;bE2,\u0017\u0002BA\u0010\u00033\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u0002F\u0003GI1!!\n\u0003\u0005AaunZ\"mK\u0006t\u0017N\\4Ti\u0006$X\r\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u000b\u0003-Ig\u000e\u0015:pOJ,7o\u001d\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012\u0001\u00027pG.,\"!!\r\u0011\t\u0005M\u0012\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005)An\\2lg*!\u00111HA\u001f\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u007fi\u0013\u0001B;uS2LA!a\u0011\u00026\ti!+Z3oiJ\fg\u000e\u001e'pG.D\u0001\"a\u0012\u0001A\u0003%\u0011\u0011G\u0001\u0006Y>\u001c7\u000e\t\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001b\n!\u0003]1vg\u0016$7\t\\3b]&twmQ8oIV\u0011\u0011q\n\t\u0005\u0003g\t\t&\u0003\u0003\u0002T\u0005U\"!C\"p]\u0012LG/[8o\u0011!\t9\u0006\u0001Q\u0001\n\u0005=\u0013a\u00059bkN,Gm\u00117fC:LgnZ\"p]\u0012\u0004\u0003\"CA.\u0001\u0001\u0007I\u0011BA/\u0003e!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8\u0016\u0005\u0005}\u0003c\u0001\u0005\u0002b%\u0019\u00111M\u0005\u0003\r\u0011{WO\u00197f\u0011%\t9\u0007\u0001a\u0001\n\u0013\tI'A\u000feSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|w\fJ3r)\ra\u00181\u000e\u0005\u000b\u0003\u0003\t)'!AA\u0002\u0005}\u0003\u0002CA8\u0001\u0001\u0006K!a\u0018\u00025\u0011L'\u000f^5fgRdunZ\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\u001c\u0011)\t\u00055\u0014\u0011\u0002\u0005\n\u0003k\u0002\u0001\u0019!C\u0005\u0003o\nQ\u0002^5nK>3G*Y:u%VtWCAA=!\rA\u00111P\u0005\u0004\u0003{J!\u0001\u0002'p]\u001eD\u0011\"!!\u0001\u0001\u0004%I!a!\u0002#QLW.Z(g\u0019\u0006\u001cHOU;o?\u0012*\u0017\u000fF\u0002}\u0003\u000bC!\"!\u0001\u0002\u0000\u0005\u0005\t\u0019AA=\u0011!\tI\t\u0001Q!\n\u0005e\u0014A\u0004;j[\u0016|e\rT1tiJ+h\u000e\t\u0015\u0005\u0003\u000f\u000bI\u0001C\u0004\u0002\u0010\u0002!\t!!%\u0002+\u0005dGn\u00117fC:,'o\u00115fG.\u0004x.\u001b8ugV\u0011\u00111\u0013\t\b\u0003+\u000bY*OA=\u001d\rA\u0011qS\u0005\u0004\u00033K\u0011A\u0002)sK\u0012,g-C\u0002t\u0003;S1!!'\n\u0011!\t\t\u000b\u0001C\u0001\u0005\u0005\r\u0016!D2mK\u0006t\u0017N\\4Ti\u0006$X\r\u0006\u0003\u0002&\u0006-\u0006#\u0002\u0005\u0002(\u0006\u0005\u0012bAAU\u0013\t1q\n\u001d;j_:Dq!!,\u0002 \u0002\u0007\u0011(\u0001\u0002ua\"A\u0011\u0011\u0017\u0001\u0005\u0002\t\t\u0019,\u0001\ttKR\u001cE.Z1oS:<7\u000b^1uKR)A0!.\u00028\"9\u0011QVAX\u0001\u0004I\u0004\u0002CA]\u0003_\u0003\r!!\t\u0002\u000bM$\u0018\r^3\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u0006IrM]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h)\u0011\t\t-!3\u0011\u000b!\t9+a1\u0011\u0007\u0015\u000b)-C\u0002\u0002H\n\u0011!\u0002T8h)>\u001cE.Z1o\u0011!\tY-a/A\u0002\u00055\u0017\u0001\u0002;j[\u0016\u0004B!a4\u0002T6\u0011\u0011\u0011\u001b\u0006\u0003!mJA!!6\u0002R\n!A+[7f\u0011\u001d\tI\u000e\u0001C\u0001\u00037\fQ\u0002Z3mKR\f'\r\\3M_\u001e\u001cHCAAo!\u0015q\u0012q\\Ar\u0013\r\t\t\u000f\u000b\u0002\t\u0013R,'/\u00192mKB)\u0001\"!::\t&\u0019\u0011q]\u0005\u0003\rQ+\b\u000f\\33\u0011\u001d\tY\u000f\u0001C\u0001\u0003[\fQ\"\u00192peR\u001cE.Z1oS:<Gc\u0001?\u0002p\"9\u0011\u0011_Au\u0001\u0004I\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003k\u0004A\u0011AA|\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$2\u0001`A}\u0011\u001d\t\t0a=A\u0002eBq!!@\u0001\t\u0003\ty0\u0001\bsKN,X.Z\"mK\u0006t\u0017N\\4\u0015\u0007q\u0014\t\u0001C\u0004\u0002r\u0006m\b\u0019A\u001d\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b\u0005\t\u0012n]\"mK\u0006t\u0017N\\4J]N#\u0018\r^3\u0015\r\t%!q\u0002B\t!\rA!1B\u0005\u0004\u0005\u001bI!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003c\u0014\u0019\u00011\u0001:\u0011!\u0011\u0019Ba\u0001A\u0002\u0005\u0005\u0012!D3ya\u0016\u001cG/\u001a3Ti\u0006$X\rC\u0004\u0003\u0018\u0001!\tA!\u0007\u0002)\rDWmY6DY\u0016\fg.\u001b8h\u0003\n|'\u000f^3e)\ra(1\u0004\u0005\b\u0003c\u0014)\u00021\u0001:\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005C\t\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)\u0015a(1\u0005B\u0014\u0011\u001d\u0011)C!\bA\u0002%\nq\u0001Z1uC\u0012K'\u000f\u0003\u0005\u0003*\tu\u0001\u0019\u0001B\u0016\u0003\u0019)\b\u000fZ1uKB)\u0001\"a*\u0003.A1\u0001\"!::\u0003sBqA!\r\u0001\t\u0003\u0011\u0019$\u0001\nbYR,'o\u00115fG.\u0004x.\u001b8u\t&\u0014Hc\u0002?\u00036\t]\"1\b\u0005\b\u0003c\u0014y\u00031\u0001:\u0011\u001d\u0011IDa\fA\u0002%\nAb]8ve\u000e,Gj\\4ESJDqA!\u0010\u00030\u0001\u0007\u0011&\u0001\u0006eKN$Hj\\4ESJDqA!\u0011\u0001\t\u0003\u0011\u0019%A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\rF\u0002}\u0005\u000bB\u0001Ba\u0012\u0003@\u0001\u0007!\u0011J\u0001\u0004I&\u0014\b\u0003BAK\u0005\u0017J1\u0001ZAO\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005#\nq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u000fq\u0014\u0019F!\u0016\u0003X!9!Q\u0005B'\u0001\u0004I\u0003bBAy\u0005\u001b\u0002\r!\u000f\u0005\t\u00053\u0012i\u00051\u0001\u0002z\u00051qN\u001a4tKRDqA!\u0018\u0001\t\u0003\u0011y&\u0001\u0007e_:,7\t\\3b]&tw\rF\u0004}\u0005C\u0012\u0019G!\u001a\t\u000f\u0005E(1\fa\u0001s!9!Q\u0005B.\u0001\u0004I\u0003\u0002\u0003B4\u00057\u0002\r!!\u001f\u0002\u0013\u0015tGm\u00144gg\u0016$\bb\u0002B6\u0001\u0011\u0005!QN\u0001\rI>tW\rR3mKRLgn\u001a\u000b\u0004y\n=\u0004bBAy\u0005S\u0002\r!O\u0004\t\u0005g\u0012\u0001\u0012\u0001\u0002\u0003v\u0005\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0011\u0007\u0015\u00139HB\u0004\u0002\u0005!\u0005!A!\u001f\u0014\t\t]t!\u0004\u0005\b-\n]D\u0011\u0001B?)\t\u0011)\b\u0003\u0005\u0003\u0002\n]D\u0011\u0001BB\u0003II7oQ8na\u0006\u001cG/\u00118e\t\u0016dW\r^3\u0015\t\t%!Q\u0011\u0005\u0007\u0007\t}\u0004\u0019\u0001#\t\u0011\t%%q\u000fC\u0001\u0005\u0017\u000b\u0001c\u00197fC:\f'\r\\3PM\u001a\u001cX\r^:\u0015\u0015\t5%q\u0012BI\u0005'\u0013I\nE\u0004\t\u0003K\fI(!\u001f\t\r\r\u00119\t1\u0001E\u0011\u001d\t\tPa\"A\u0002eB\u0001B!&\u0003\b\u0002\u0007!qS\u0001\nY\u0006\u001cHo\u00117fC:\u0004R!\u001c::\u0003sB\u0001Ba'\u0003\b\u0002\u0007\u0011\u0011P\u0001\u0004]><\b")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> kafka$log$LogCleanerManager$$checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress;
    private final ReentrantLock lock;
    private final Condition kafka$log$LogCleanerManager$$pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpointFile> kafka$log$LogCleanerManager$$checkpoints() {
        return this.kafka$log$LogCleanerManager$$checkpoints;
    }

    public void kafka$log$LogCleanerManager$$checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.kafka$log$LogCleanerManager$$checkpoints = x$1;
    }

    public HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress() {
        return this.kafka$log$LogCleanerManager$$inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Condition kafka$log$LogCleanerManager$$pausedCleaningCond() {
        return this.kafka$log$LogCleanerManager$$pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    public void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    public void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply() {
                return ((TraversableOnce)this.$outer.kafka$log$LogCleanerManager$$checkpoints().values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$allCleanerCheckpoints$1 $outer;

                    public final Map<TopicPartition, Object> apply(OffsetCheckpointFile checkpoint) {
                        scala.collection.immutable.Map map;
                        try {
                            map = checkpoint.read();
                        }
                        catch (KafkaStorageException kafkaStorageException) {
                            this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().error((Function0<String>)new Serializable(this, checkpoint){
                                public static final long serialVersionUID = 0L;
                                private final OffsetCheckpointFile checkpoint$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to access checkpoint file ", " in dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpoint$2.file().getName(), this.checkpoint$2.file().getParentFile().getAbsolutePath()}));
                                }
                                {
                                    this.checkpoint$2 = checkpoint$2;
                                }
                            }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                                public static final long serialVersionUID = 0L;
                                private final KafkaStorageException e$1;

                                public final KafkaStorageException apply() {
                                    return this.e$1;
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            });
                            map = Predef$.MODULE$.Map().empty();
                        }
                        return map;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition tp$1;

            public final Option<LogCleaningState> apply() {
                return this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.tp$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
            }
        });
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, tp, state){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition tp$2;
            private final LogCleaningState state$1;

            public final Option<LogCleaningState> apply() {
                return this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.tp$2, (Object)this.state$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.state$1 = state$1;
            }
        });
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final Time time$1;

            public final Option<LogToClean> apply() {
                None$ none$;
                long now = this.time$1.milliseconds();
                this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
                scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.$outer.allCleanerCheckpoints();
                Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.$outer.logs().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$1) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Log log = (Log)tuple2._2();
                            boolean bl = log.config().compact();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                })).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$grabFilthiestCompactedLog$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$2) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$2;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            boolean bl = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains((Object)topicPartition);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).map((Function1)new Serializable(this, now, lastClean){
                    public static final long serialVersionUID = 0L;
                    private final long now$1;
                    private final scala.collection.immutable.Map lastClean$1;

                    public final LogToClean apply(Tuple2<TopicPartition, Log> x0$3) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            Log log = (Log)tuple2._2();
                            Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, (scala.collection.immutable.Map<TopicPartition, Object>)this.lastClean$1, this.now$1);
                            if (tuple22 != null) {
                                Tuple2.mcJJ.sp sp2;
                                long firstDirtyOffset = tuple22._1$mcJ$sp();
                                long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                                Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                                long firstDirtyOffset2 = sp3._1$mcJ$sp();
                                long firstUncleanableDirtyOffset2 = sp3._2$mcJ$sp();
                                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                                return logToClean;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.now$1 = now$1;
                        this.lastClean$1 = lastClean$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.totalBytes() > 0L;
                    }
                });
                this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
                Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
                    }
                });
                if (cleanableLogs.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                    this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                    none$ = new Some((Object)filthiest);
                }
                return none$;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Tuple2<TopicPartition, Log>> apply() {
                void var1_1;
                Iterable toClean = (Iterable)this.$outer.logs().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$4) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            Log log = (Log)tuple2._2();
                            boolean bl = !this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains((Object)topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                toClean.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final Option<LogCleaningState> apply(Tuple2<TopicPartition, Log> x0$5) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            Option option = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return var1_1;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.abortAndPauseCleaning(this.topicPartition$1);
                this.$outer.resumeCleaning(this.topicPartition$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1}));
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        });
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option option;
                block7: {
                    LogCleaningState logCleaningState;
                    block10: {
                        block6: {
                            BoxedUnit boxedUnit;
                            Option option2;
                            block9: {
                                block8: {
                                    block5: {
                                        option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicPartition$4);
                                        if (!None$.MODULE$.equals(option)) break block5;
                                        option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicPartition$4, (Object)LogCleaningPaused$.MODULE$);
                                        break block6;
                                    }
                                    if (!(option instanceof Some)) break block7;
                                    Some some = (Some)option;
                                    LogCleaningState state = (LogCleaningState)some.x();
                                    logCleaningState = state;
                                    if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block8;
                                    boxedUnit = this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicPartition$4, (Object)LogCleaningAborted$.MODULE$);
                                    break block9;
                                }
                                if (!LogCleaningPaused$.MODULE$.equals(logCleaningState)) break block10;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            option2 = boxedUnit;
                        }
                        while (true) {
                            if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$4, LogCleaningPaused$.MODULE$)) {
                                return;
                            }
                            this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
                        }
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$4, logCleaningState})));
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$4 = topicPartition$4;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$4}));
            }
            {
                this.topicPartition$4 = topicPartition$4;
            }
        });
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$5;

            public final Option<LogCleaningState> apply() {
                Option option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicPartition$5);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$5})));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogCleaningState state = (LogCleaningState)some.x();
                    LogCleaningState logCleaningState = state;
                    if (LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                        Option option2;
                        Option option3 = option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicPartition$5);
                        return option3;
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$5, logCleaningState})));
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$5 = topicPartition$5;
            }
        });
        this.info((Function0<String>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$5;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$5}));
            }
            {
                this.topicPartition$5 = topicPartition$5;
            }
        });
    }

    public boolean kafka$log$LogCleanerManager$$isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                LogCleaningState state;
                block2: {
                    option = this.kafka$log$LogCleanerManager$$inProgress().get((Object)topicPartition);
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = false;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogCleaningState logCleaningState = state = (LogCleaningState)some.x();
                LogCleaningState logCleaningState2 = expectedState;
                bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$6;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$6, LogCleaningAborted$.MODULE$)) {
                    throw new LogCleaningAbortedException();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$6 = topicPartition$6;
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, dataDir, update2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$1;
            private final Option update$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply((Object)this.dataDir$1);
                if (checkpoint != null) {
                    try {
                        Map existing = checkpoint.read().filterKeys(this.$outer.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.update$1));
                        checkpoint.write((Map<TopicPartition, Object>)existing);
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.$outer.error((Function0<String>)new Serializable(this, checkpoint){
                            public static final long serialVersionUID = 0L;
                            private final OffsetCheckpointFile checkpoint$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to access checkpoint file ", " in dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpoint$1.file().getName(), this.checkpoint$1.file().getParentFile().getAbsolutePath()}));
                            }
                            {
                                this.checkpoint$1 = checkpoint$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                            public static final long serialVersionUID = 0L;
                            private final KafkaStorageException e$2;

                            public final KafkaStorageException apply() {
                                return this.e$2;
                            }
                            {
                                this.e$2 = e$2;
                            }
                        });
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$1 = dataDir$1;
                this.update$1 = update$1;
            }
        });
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition, sourceLogDir, destLogDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            public final TopicPartition topicPartition$2;
            public final File sourceLogDir$1;
            private final File destLogDir$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                block4: {
                    try {
                        Option option = this.$outer.kafka$log$LogCleanerManager$$checkpoints().get((Object)this.sourceLogDir$1).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$alterCheckpointDir$1 $outer;

                            public final Option<Object> apply(OffsetCheckpointFile x$2) {
                                return x$2.read().get((Object)this.$outer.topicPartition$2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            long offset2 = BoxesRunTime.unboxToLong((Object)some.x());
                            this.$outer.updateCheckpoints(this.sourceLogDir$1, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
                            this.$outer.updateCheckpoints(this.destLogDir$1, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition$2, (Object)BoxesRunTime.boxToLong((long)offset2))));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.$outer.error((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$alterCheckpointDir$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to access checkpoint file in dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sourceLogDir$1.getAbsolutePath()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, (Function0<Throwable>)new Serializable(this, kafkaStorageException){
                            public static final long serialVersionUID = 0L;
                            private final KafkaStorageException e$3;

                            public final KafkaStorageException apply() {
                                return this.e$3;
                            }
                            {
                                this.e$3 = e$3;
                            }
                        });
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$2 = topicPartition$2;
                this.sourceLogDir$1 = sourceLogDir$1;
                this.destLogDir$1 = destLogDir$1;
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.info((Function0<String>)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final String dir$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping cleaning logs in dir ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1}));
            }
            {
                this.dir$1 = dir$1;
            }
        });
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            public final String dir$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogCleanerManager$$checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)this.$outer.kafka$log$LogCleanerManager$$checkpoints().filterKeys((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$handleLogDirFailure$1 $outer;

                    public final boolean apply(File x$3) {
                        String string = x$3.getAbsolutePath();
                        String string2 = this.$outer.dir$1;
                        return string != null ? !string.equals(string2) : string2 != null;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, dataDir, topicPartition, offset2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$2;
            private final TopicPartition topicPartition$3;
            private final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map<TopicPartition, Object> existing;
                OffsetCheckpointFile checkpoint;
                if (this.$outer.logs().get(this.topicPartition$3).config().compact() && (checkpoint = (OffsetCheckpointFile)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply((Object)this.dataDir$2)) != null && BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)this.topicPartition$3, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) > this.offset$1) {
                    checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$3), (Object)BoxesRunTime.boxToLong((long)this.offset$1))));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$2 = dataDir$2;
                this.topicPartition$3 = topicPartition$3;
                this.offset$1 = offset$1;
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition, dataDir, endOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$7;
            private final File dataDir$3;
            private final long endOffset$1;

            public final Object apply() {
                Option option;
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        LogCleaningState logCleaningState;
                        Some some;
                        boolean bl;
                        block4: {
                            bl = false;
                            some = null;
                            option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicPartition$7);
                            if (!(option instanceof Some)) break block4;
                            bl = true;
                            some = (Some)option;
                            LogCleaningState logCleaningState2 = (LogCleaningState)some.x();
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) break block4;
                            this.$outer.updateCheckpoints(this.dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition$7, (Object)BoxesRunTime.boxToLong((long)this.endOffset$1))));
                            boxedUnit = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicPartition$7);
                            break block5;
                        }
                        if (!bl || !LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.x())) break block6;
                        this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicPartition$7, (Object)LogCleaningPaused$.MODULE$);
                        this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().signalAll();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"State for partition ", " should exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$7})));
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$7, option})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$7 = topicPartition$7;
                this.dataDir$3 = dataDir$3;
                this.endOffset$1 = endOffset$1;
            }
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$8;

            public final Object apply() {
                Option option;
                block6: {
                    Option option2;
                    block5: {
                        LogCleaningState logCleaningState;
                        Some some;
                        boolean bl;
                        block4: {
                            bl = false;
                            some = null;
                            option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get((Object)this.topicPartition$8);
                            if (!(option instanceof Some)) break block4;
                            bl = true;
                            some = (Some)option;
                            LogCleaningState logCleaningState2 = (LogCleaningState)some.x();
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) break block4;
                            option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove((Object)this.topicPartition$8);
                            break block5;
                        }
                        if (!bl || !LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.x())) break block6;
                        this.$outer.kafka$log$LogCleanerManager$$inProgress().put((Object)this.topicPartition$8, (Object)LogCleaningPaused$.MODULE$);
                        this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().signalAll();
                        option2 = BoxedUnit.UNIT;
                    }
                    return option2;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"State for partition ", " should exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$8})));
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$8, option})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$8 = topicPartition$8;
            }
        });
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.kafka$log$LogCleanerManager$$checkpoints = ((TraversableOnce)logDirs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final Tuple2<File, OffsetCheckpointFile> apply(File dir) {
                return new Tuple2((Object)dir, (Object)new OffsetCheckpointFile(new File(dir, this.$outer.offsetCheckpointFile()), this.$outer.logDirFailureChannel()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.kafka$log$LogCleanerManager$$inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.kafka$log$LogCleanerManager$$pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

