/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.twitter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.conf.BatchSizeSupported;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.MediaEntity;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TwitterSource
extends AbstractSource
implements EventDrivenSource,
Configurable,
StatusListener,
BatchSizeSupported {
    private TwitterStream twitterStream;
    private Schema avroSchema;
    private long docCount = 0L;
    private long startTime = 0L;
    private long exceptionCount = 0L;
    private long totalTextIndexed = 0L;
    private long skippedDocs = 0L;
    private long batchEndTime = 0L;
    private final List<GenericData.Record> docs = new ArrayList<GenericData.Record>();
    private final ByteArrayOutputStream serializationBuffer = new ByteArrayOutputStream();
    private DataFileWriter<GenericRecord> dataFileWriter;
    private int maxBatchSize = 1000;
    private int maxBatchDurationMillis = 1000;
    private SimpleDateFormat formatterTo = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private DecimalFormat numFormatter = new DecimalFormat("###,###.###");
    private static int REPORT_INTERVAL = 100;
    private static int STATS_INTERVAL = REPORT_INTERVAL * 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterSource.class);

    public void configure(Context context) {
        String consumerKey = context.getString("consumerKey");
        String consumerSecret = context.getString("consumerSecret");
        String accessToken = context.getString("accessToken");
        String accessTokenSecret = context.getString("accessTokenSecret");
        this.twitterStream = new TwitterStreamFactory().getInstance();
        this.twitterStream.setOAuthConsumer(consumerKey, consumerSecret);
        this.twitterStream.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
        this.twitterStream.addListener((StatusListener)this);
        this.avroSchema = this.createAvroSchema();
        this.dataFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(this.avroSchema));
        this.maxBatchSize = context.getInteger("maxBatchSize", Integer.valueOf(this.maxBatchSize));
        this.maxBatchDurationMillis = context.getInteger("maxBatchDurationMillis", Integer.valueOf(this.maxBatchDurationMillis));
    }

    public synchronized void start() {
        LOGGER.info("Starting twitter source {} ...", (Object)this);
        this.docCount = 0L;
        this.startTime = System.currentTimeMillis();
        this.exceptionCount = 0L;
        this.totalTextIndexed = 0L;
        this.skippedDocs = 0L;
        this.batchEndTime = System.currentTimeMillis() + (long)this.maxBatchDurationMillis;
        this.twitterStream.sample();
        LOGGER.info("Twitter source {} started.", (Object)this.getName());
        super.start();
    }

    public synchronized void stop() {
        LOGGER.info("Twitter source {} stopping...", (Object)this.getName());
        this.twitterStream.shutdown();
        super.stop();
        LOGGER.info("Twitter source {} stopped.", (Object)this.getName());
    }

    public void onStatus(Status status) {
        GenericData.Record doc = this.extractRecord("", this.avroSchema, status);
        if (doc == null) {
            return;
        }
        this.docs.add(doc);
        if (this.docs.size() >= this.maxBatchSize || System.currentTimeMillis() >= this.batchEndTime) {
            byte[] bytes;
            this.batchEndTime = System.currentTimeMillis() + (long)this.maxBatchDurationMillis;
            try {
                bytes = this.serializeToAvro(this.avroSchema, this.docs);
            }
            catch (IOException e) {
                LOGGER.error("Exception while serializing tweet", (Throwable)e);
                return;
            }
            Event event = EventBuilder.withBody((byte[])bytes);
            this.getChannelProcessor().processEvent(event);
            this.docs.clear();
        }
        ++this.docCount;
        if (this.docCount % (long)REPORT_INTERVAL == 0L) {
            LOGGER.info(String.format("Processed %s docs", this.numFormatter.format(this.docCount)));
        }
        if (this.docCount % (long)STATS_INTERVAL == 0L) {
            this.logStats();
        }
    }

    private Schema createAvroSchema() {
        Schema avroSchema = Schema.createRecord((String)"Doc", (String)"adoc", null, (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        fields.add(new Schema.Field("user_friends_count", this.createOptional(Schema.create((Schema.Type)Schema.Type.INT)), null, null));
        fields.add(new Schema.Field("user_location", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("user_description", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("user_statuses_count", this.createOptional(Schema.create((Schema.Type)Schema.Type.INT)), null, null));
        fields.add(new Schema.Field("user_followers_count", this.createOptional(Schema.create((Schema.Type)Schema.Type.INT)), null, null));
        fields.add(new Schema.Field("user_name", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("user_screen_name", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("created_at", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("text", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("retweet_count", this.createOptional(Schema.create((Schema.Type)Schema.Type.LONG)), null, null));
        fields.add(new Schema.Field("retweeted", this.createOptional(Schema.create((Schema.Type)Schema.Type.BOOLEAN)), null, null));
        fields.add(new Schema.Field("in_reply_to_user_id", this.createOptional(Schema.create((Schema.Type)Schema.Type.LONG)), null, null));
        fields.add(new Schema.Field("source", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("in_reply_to_status_id", this.createOptional(Schema.create((Schema.Type)Schema.Type.LONG)), null, null));
        fields.add(new Schema.Field("media_url_https", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("expanded_url", this.createOptional(Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        avroSchema.setFields(fields);
        return avroSchema;
    }

    private GenericData.Record extractRecord(String idPrefix, Schema avroSchema, Status status) {
        User user = status.getUser();
        GenericData.Record doc = new GenericData.Record(avroSchema);
        doc.put("id", (Object)(idPrefix + status.getId()));
        doc.put("created_at", (Object)this.formatterTo.format(status.getCreatedAt()));
        doc.put("retweet_count", (Object)status.getRetweetCount());
        doc.put("retweeted", (Object)status.isRetweet());
        doc.put("in_reply_to_user_id", (Object)status.getInReplyToUserId());
        doc.put("in_reply_to_status_id", (Object)status.getInReplyToStatusId());
        this.addString(doc, "source", status.getSource());
        this.addString(doc, "text", status.getText());
        MediaEntity[] mediaEntities = status.getMediaEntities();
        if (mediaEntities.length > 0) {
            this.addString(doc, "media_url_https", mediaEntities[0].getMediaURLHttps());
            this.addString(doc, "expanded_url", mediaEntities[0].getExpandedURL());
        }
        doc.put("user_friends_count", (Object)user.getFriendsCount());
        doc.put("user_statuses_count", (Object)user.getStatusesCount());
        doc.put("user_followers_count", (Object)user.getFollowersCount());
        this.addString(doc, "user_location", user.getLocation());
        this.addString(doc, "user_description", user.getDescription());
        this.addString(doc, "user_screen_name", user.getScreenName());
        this.addString(doc, "user_name", user.getName());
        return doc;
    }

    private byte[] serializeToAvro(Schema avroSchema, List<GenericData.Record> docList) throws IOException {
        this.serializationBuffer.reset();
        this.dataFileWriter.create(avroSchema, (OutputStream)this.serializationBuffer);
        for (GenericData.Record doc2 : docList) {
            this.dataFileWriter.append((Object)doc2);
        }
        this.dataFileWriter.close();
        return this.serializationBuffer.toByteArray();
    }

    private Schema createOptional(Schema schema) {
        return Schema.createUnion(Arrays.asList(schema, Schema.create((Schema.Type)Schema.Type.NULL)));
    }

    private void addString(GenericData.Record doc, String avroField, String val) {
        if (val == null) {
            return;
        }
        doc.put(avroField, (Object)val);
        this.totalTextIndexed += (long)val.length();
    }

    private void logStats() {
        double mbIndexed = (double)this.totalTextIndexed / 1048576.0;
        long seconds = (System.currentTimeMillis() - this.startTime) / 1000L;
        seconds = Math.max(seconds, 1L);
        LOGGER.info(String.format("Total docs indexed: %s, total skipped docs: %s", this.numFormatter.format(this.docCount), this.numFormatter.format(this.skippedDocs)));
        LOGGER.info(String.format("    %s docs/second", this.numFormatter.format(this.docCount / seconds)));
        LOGGER.info(String.format("Run took %s seconds and processed:", this.numFormatter.format(seconds)));
        LOGGER.info(String.format("    %s MB/sec sent to index", this.numFormatter.format((float)this.totalTextIndexed / 1048576.0f / (float)seconds)));
        LOGGER.info(String.format("    %s MB text sent to index", this.numFormatter.format(mbIndexed)));
        LOGGER.info(String.format("There were %s exceptions ignored: ", this.numFormatter.format(this.exceptionCount)));
    }

    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
    }

    public void onScrubGeo(long userId, long upToStatusId) {
    }

    public void onStallWarning(StallWarning warning) {
    }

    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
    }

    public void onException(Exception e) {
        LOGGER.error("Exception while streaming tweets", (Throwable)e);
    }

    public long getBatchSize() {
        return this.maxBatchSize;
    }
}

