/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.http;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.http.HTTPSourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLOBHandler
implements HTTPSourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BLOBHandler.class);
    private String commaSeparatedHeaders;
    private String[] mandatoryHeaders;
    public static final String MANDATORY_PARAMETERS = "mandatoryParameters";
    public static final String DEFAULT_MANDATORY_PARAMETERS = "";
    public static final String PARAMETER_SEPARATOR = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> getEvents(HttpServletRequest request) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        ServletInputStream inputStream = request.getInputStream();
        Map parameters = request.getParameterMap();
        for (String parameter : parameters.keySet()) {
            String value = ((String[])parameters.get(parameter))[0];
            if (LOG.isDebugEnabled() && LogPrivacyUtil.allowLogRawData()) {
                LOG.debug("Setting Header [Key, Value] as [{},{}] ", (Object)parameter, (Object)value);
            }
            headers.put(parameter, value);
        }
        for (String header : this.mandatoryHeaders) {
            Preconditions.checkArgument((boolean)headers.containsKey(header), (Object)("Please specify " + header + " parameter in the request."));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            LOG.debug("Building an Event with stream of size -- {}", (Object)outputStream.size());
            Event event = EventBuilder.withBody((byte[])outputStream.toByteArray(), headers);
            event.setHeaders(headers);
            ArrayList<Event> eventList = new ArrayList<Event>();
            eventList.add(event);
            ArrayList<Event> arrayList = eventList;
            return arrayList;
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    @Override
    public void configure(Context context) {
        this.commaSeparatedHeaders = context.getString(MANDATORY_PARAMETERS, DEFAULT_MANDATORY_PARAMETERS);
        this.mandatoryHeaders = this.commaSeparatedHeaders.split(PARAMETER_SEPARATOR);
    }
}

