/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.partition;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.text.NumberFormat;
import java.util.Calendar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.kitesdk.data.spi.partition.CalendarFieldPartitioner;

@SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE", "SE_COMPARATOR_SHOULD_BE_SERIALIZABLE", "EQ_DOESNT_OVERRIDE_EQUALS"}, justification="False positive due to generics. EQ: parent equals implementation checks child type")
@Immutable
public class MonthFieldPartitioner
extends CalendarFieldPartitioner {
    private final NumberFormat format = NumberFormat.getIntegerInstance();

    public MonthFieldPartitioner(String sourceName) {
        this(sourceName, null);
    }

    public MonthFieldPartitioner(String sourceName, @Nullable String name) {
        super(sourceName, name == null ? "month" : name, 2, 12);
        this.format.setMinimumIntegerDigits(2);
        this.format.setMaximumIntegerDigits(2);
    }

    @Override
    public Integer apply(@Nonnull Long timestamp) {
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTimeInMillis(timestamp);
        return cal.get(this.calendarField) + 1;
    }
}

