/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.filesystem;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.DatasetIOException;
import org.kitesdk.data.DatasetOperationException;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.Loadable;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Registration;
import org.kitesdk.data.spi.URIPattern;
import org.kitesdk.data.spi.filesystem.FileSystemDatasetRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loader
implements Loadable {
    private static final Logger LOG = LoggerFactory.getLogger(Loader.class);
    private static final int UNSPECIFIED_PORT = -1;

    @Override
    public void load() {
        try {
            FileSystem.getLocal((Configuration)DefaultConfiguration.get());
        }
        catch (IOException e) {
            throw new DatasetIOException("Cannot load default config", e);
        }
        URIBuilder builder = new URIBuilder();
        Registration.register(new URIPattern("file:/*path?absolute=true"), new URIPattern("file:/*path/:namespace/:dataset?absolute=true"), builder);
        Registration.register(new URIPattern("file:*path"), new URIPattern("file:*path/:namespace/:dataset"), builder);
        Registration.register(new URIPattern("hdfs:/*path?absolute=true"), new URIPattern("hdfs:/*path/:namespace/:dataset?absolute=true"), builder);
        Registration.register(new URIPattern("hdfs:*path"), new URIPattern("hdfs:*path/:namespace/:dataset"), builder);
        Registration.register(new URIPattern("webhdfs:/*path?absolute=true"), new URIPattern("webhdfs:/*path/:namespace/:dataset?absolute=true"), builder);
    }

    private static URI fileSystemURI(Map<String, String> match) {
        String userInfo = match.containsKey("auth:username") ? (match.containsKey("auth:password") ? match.get("auth:username") + ":" + match.get("auth:password") : match.get("auth:username")) : null;
        try {
            int port = -1;
            if (match.containsKey("auth:port")) {
                try {
                    port = Integer.parseInt(match.get("auth:port"));
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
            }
            return new URI(match.get("uri:scheme"), userInfo, match.get("auth:host"), port, "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new DatasetOperationException("[BUG] Could not build FS URI", ex);
        }
    }

    private static class URIBuilder
    implements OptionBuilder<DatasetRepository> {
        private URIBuilder() {
        }

        @Override
        public DatasetRepository getFromOptions(Map<String, String> match) {
            FileSystem fs;
            String path = match.get("path");
            Path root = match.containsKey("absolute") && Boolean.valueOf(match.get("absolute")) != false ? (path == null || path.isEmpty() ? new Path("/") : new Path("/", path)) : (path == null || path.isEmpty() ? new Path(".") : new Path(path));
            Configuration conf = DefaultConfiguration.get();
            try {
                fs = FileSystem.get((URI)Loader.fileSystemURI(match), (Configuration)conf);
            }
            catch (IOException ex) {
                throw new DatasetIOException("Could not get a FileSystem", ex);
            }
            return new FileSystemDatasetRepository.Builder().configuration(new Configuration(conf)).rootDirectory(fs.makeQualified(root)).build();
        }
    }
}

