/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi;

import java.net.URI;
import java.util.Map;
import java.util.ServiceLoader;
import org.kitesdk.data.DatasetNotFoundException;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.Loadable;
import org.kitesdk.data.spi.OptionBuilder;
import org.kitesdk.data.spi.Pair;
import org.kitesdk.data.spi.URIPattern;
import org.kitesdk.shaded.com.google.common.base.Joiner;
import org.kitesdk.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Registration {
    private static final Logger LOG = LoggerFactory.getLogger(Registration.class);
    private static final Map<URIPattern, OptionBuilder<DatasetRepository>> REPO_PATTERNS = Maps.newLinkedHashMap();
    private static final Map<URIPattern, OptionBuilder<DatasetRepository>> DATASET_PATTERNS = Maps.newLinkedHashMap();
    private static final Map<URIPattern, URIPattern> REPO_TO_DATASET_PATTERNS = Maps.newLinkedHashMap();

    public static void register(URIPattern repoPattern, URIPattern datasetPattern, OptionBuilder<DatasetRepository> repoBuilder) {
        REPO_PATTERNS.put(repoPattern, repoBuilder);
        DATASET_PATTERNS.put(datasetPattern, repoBuilder);
        if (!REPO_TO_DATASET_PATTERNS.containsKey(repoPattern)) {
            REPO_TO_DATASET_PATTERNS.put(repoPattern, datasetPattern);
        }
    }

    public static Pair<URIPattern, Map<String, String>> lookupPatternByRepoUri(URI uri) {
        for (URIPattern pattern : REPO_TO_DATASET_PATTERNS.keySet()) {
            Map<String, String> match = pattern.getMatch(uri);
            if (match == null) continue;
            URIPattern datasetPattern = REPO_TO_DATASET_PATTERNS.get(pattern);
            return Pair.of(datasetPattern, match);
        }
        throw new IllegalArgumentException("Unknown repository URI: " + uri);
    }

    public static Pair<URIPattern, Map<String, String>> lookupDatasetPattern(URI uri) {
        for (URIPattern pattern : DATASET_PATTERNS.keySet()) {
            Map<String, String> match = pattern.getMatch(uri);
            if (match == null) continue;
            return Pair.of(pattern, match);
        }
        throw new IllegalArgumentException("Unknown dataset URI: " + uri);
    }

    public static Pair<DatasetRepository, Map<String, String>> lookupRepoUri(URI repoUri) {
        for (URIPattern pattern : REPO_PATTERNS.keySet()) {
            Map<String, String> match = pattern.getMatch(repoUri);
            if (match == null) continue;
            return Pair.of(REPO_PATTERNS.get(pattern).getFromOptions(match), match);
        }
        throw new IllegalArgumentException("Unknown repository URI: " + repoUri);
    }

    public static <R extends DatasetRepository> R open(URI uri) {
        return (R)Registration.lookupRepoUri(uri).first();
    }

    public static Pair<DatasetRepository, Map<String, String>> lookupDatasetUri(URI datasetUri) {
        for (URIPattern pattern : DATASET_PATTERNS.keySet()) {
            Map<String, String> match = pattern.getMatch(datasetUri);
            if (match == null) continue;
            return Pair.of(DATASET_PATTERNS.get(pattern).getFromOptions(match), match);
        }
        throw new DatasetNotFoundException(String.format("Unknown dataset URI: %s. Check that JARs for %s datasets are on the classpath.", datasetUri, datasetUri.getScheme()));
    }

    static {
        ServiceLoader<Loadable> impls = ServiceLoader.load(Loadable.class);
        for (Loadable loader : impls) {
            LOG.debug("Loading: " + loader.getClass().getName());
            try {
                loader.load();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Not loading URI patterns in " + loader.getClass().getName(), (Throwable)e);
                    continue;
                }
                LOG.warn("Not loading URI patterns in " + loader.getClass().getName());
            }
        }
        LOG.debug("Registered repository URIs:\n\t" + Joiner.on("\n\t").join(REPO_PATTERNS.keySet()));
        LOG.debug("Registered dataset URIs:\n\t" + Joiner.on("\n\t").join(DATASET_PATTERNS.keySet()));
    }
}

