/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flume.Channel;
import org.apache.flume.ChannelFactory;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.SinkFactory;
import org.apache.flume.SinkProcessor;
import org.apache.flume.SinkRunner;
import org.apache.flume.Source;
import org.apache.flume.SourceFactory;
import org.apache.flume.SourceRunner;
import org.apache.flume.annotations.Disposable;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.channel.ChannelSelectorFactory;
import org.apache.flume.channel.DefaultChannelFactory;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.Configurables;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.conf.channel.ChannelSelectorConfiguration;
import org.apache.flume.conf.sink.SinkConfiguration;
import org.apache.flume.conf.sink.SinkGroupConfiguration;
import org.apache.flume.conf.source.SourceConfiguration;
import org.apache.flume.node.ConfigurationProvider;
import org.apache.flume.node.MaterializedConfiguration;
import org.apache.flume.node.SimpleMaterializedConfiguration;
import org.apache.flume.sink.DefaultSinkFactory;
import org.apache.flume.sink.DefaultSinkProcessor;
import org.apache.flume.sink.SinkGroup;
import org.apache.flume.source.DefaultSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurationProvider.class);
    private final String agentName;
    private final SourceFactory sourceFactory;
    private final SinkFactory sinkFactory;
    private final ChannelFactory channelFactory;
    private final Map<Class<? extends Channel>, Map<String, Channel>> channelCache;

    public AbstractConfigurationProvider(String agentName) {
        this.agentName = agentName;
        this.sourceFactory = new DefaultSourceFactory();
        this.sinkFactory = new DefaultSinkFactory();
        this.channelFactory = new DefaultChannelFactory();
        this.channelCache = new HashMap<Class<? extends Channel>, Map<String, Channel>>();
    }

    protected abstract FlumeConfiguration getFlumeConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MaterializedConfiguration getConfiguration() {
        SimpleMaterializedConfiguration conf = new SimpleMaterializedConfiguration();
        FlumeConfiguration fconfig = this.getFlumeConfiguration();
        FlumeConfiguration.AgentConfiguration agentConf = fconfig.getConfigurationFor(this.getAgentName());
        if (agentConf != null) {
            HashMap channelComponentMap = Maps.newHashMap();
            HashMap sourceRunnerMap = Maps.newHashMap();
            HashMap sinkRunnerMap = Maps.newHashMap();
            try {
                this.loadChannels(agentConf, channelComponentMap);
                this.loadSources(agentConf, channelComponentMap, sourceRunnerMap);
                this.loadSinks(agentConf, channelComponentMap, sinkRunnerMap);
                HashSet channelNames = new HashSet(channelComponentMap.keySet());
                for (String string : channelNames) {
                    ChannelComponent channelComponent = (ChannelComponent)channelComponentMap.get(string);
                    if (channelComponent.components.isEmpty()) {
                        LOGGER.warn(String.format("Channel %s has no components connected and has been removed.", string));
                        channelComponentMap.remove(string);
                        Map<String, Channel> nameChannelMap = this.channelCache.get(channelComponent.channel.getClass());
                        if (nameChannelMap == null) continue;
                        nameChannelMap.remove(string);
                        continue;
                    }
                    LOGGER.info(String.format("Channel %s connected to %s", string, channelComponent.components.toString()));
                    conf.addChannel(string, channelComponent.channel);
                }
                for (Map.Entry entry : sourceRunnerMap.entrySet()) {
                    conf.addSourceRunner((String)entry.getKey(), (SourceRunner)entry.getValue());
                }
                for (Map.Entry entry : sinkRunnerMap.entrySet()) {
                    conf.addSinkRunner((String)entry.getKey(), (SinkRunner)entry.getValue());
                }
            }
            catch (InstantiationException ex) {
                LOGGER.error("Failed to instantiate component", (Throwable)ex);
            }
            finally {
                channelComponentMap.clear();
                sourceRunnerMap.clear();
                sinkRunnerMap.clear();
            }
        } else {
            LOGGER.warn("No configuration found for this host:{}", (Object)this.getAgentName());
        }
        return conf;
    }

    public String getAgentName() {
        return this.agentName;
    }

    private void loadChannels(FlumeConfiguration.AgentConfiguration agentConf, Map<String, ChannelComponent> channelComponentMap) throws InstantiationException {
        String msg;
        Channel channel;
        LOGGER.info("Creating channels");
        ArrayListMultimap channelsNotReused = ArrayListMultimap.create();
        for (Map.Entry<Class<? extends Channel>, Map<String, Channel>> entry : this.channelCache.entrySet()) {
            Class<? extends Channel> channelKlass = entry.getKey();
            Set<String> channelNames = entry.getValue().keySet();
            channelsNotReused.get(channelKlass).addAll(channelNames);
        }
        Set channelNames = agentConf.getChannelSet();
        Map compMap = agentConf.getChannelConfigMap();
        for (String chName : channelNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(chName);
            if (comp == null) continue;
            channel = this.getOrCreateChannel((ListMultimap<Class<? extends Channel>, String>)channelsNotReused, comp.getComponentName(), comp.getType());
            try {
                Configurables.configure((Object)channel, (ComponentConfiguration)comp);
                channelComponentMap.put(comp.getComponentName(), new ChannelComponent(channel));
                LOGGER.info("Created channel " + chName);
            }
            catch (Exception e) {
                msg = String.format("Channel %s has been removed due to an error during configuration", chName);
                LOGGER.error(msg, (Throwable)e);
            }
        }
        for (String chName : channelNames) {
            Context context = (Context)agentConf.getChannelContext().get(chName);
            if (context == null) continue;
            channel = this.getOrCreateChannel((ListMultimap<Class<? extends Channel>, String>)channelsNotReused, chName, context.getString("type"));
            try {
                Configurables.configure((Object)channel, (Context)context);
                channelComponentMap.put(chName, new ChannelComponent(channel));
                LOGGER.info("Created channel " + chName);
            }
            catch (Exception e) {
                msg = String.format("Channel %s has been removed due to an error during configuration", chName);
                LOGGER.error(msg, (Throwable)e);
            }
        }
        for (Class channelKlass : channelsNotReused.keySet()) {
            Map<String, Channel> channelMap = this.channelCache.get(channelKlass);
            if (channelMap == null) continue;
            for (String channelName : channelsNotReused.get((Object)channelKlass)) {
                if (channelMap.remove(channelName) == null) continue;
                LOGGER.info("Removed {} of type {}", (Object)channelName, (Object)channelKlass);
            }
            if (!channelMap.isEmpty()) continue;
            this.channelCache.remove(channelKlass);
        }
    }

    private Channel getOrCreateChannel(ListMultimap<Class<? extends Channel>, String> channelsNotReused, String name, String type) throws FlumeException {
        Channel channel;
        Class channelClass = this.channelFactory.getClass(type);
        if (channelClass.isAnnotationPresent(Disposable.class)) {
            Channel channel2 = this.channelFactory.create(name, type);
            channel2.setName(name);
            return channel2;
        }
        Map<String, Channel> channelMap = this.channelCache.get(channelClass);
        if (channelMap == null) {
            channelMap = new HashMap<String, Channel>();
            this.channelCache.put(channelClass, channelMap);
        }
        if ((channel = channelMap.get(name)) == null) {
            channel = this.channelFactory.create(name, type);
            channel.setName(name);
            channelMap.put(name, channel);
        }
        channelsNotReused.get((Object)channelClass).remove(name);
        return channel;
    }

    private void loadSources(FlumeConfiguration.AgentConfiguration agentConf, Map<String, ChannelComponent> channelComponentMap, Map<String, SourceRunner> sourceRunnerMap) throws InstantiationException {
        String msg;
        ChannelComponent channelComponent;
        ChannelProcessor channelProcessor;
        ChannelSelector selector;
        ChannelSelectorConfiguration selectorConfig;
        String msg2;
        Source source;
        Set sourceNames = agentConf.getSourceSet();
        Map compMap = agentConf.getSourceConfigMap();
        for (String sourceName : sourceNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(sourceName);
            if (comp == null) continue;
            SourceConfiguration config = (SourceConfiguration)comp;
            source = this.sourceFactory.create(comp.getComponentName(), comp.getType());
            try {
                Configurables.configure((Object)source, (ComponentConfiguration)config);
                Set channelNames = config.getChannels();
                ArrayList<Channel> sourceChannels = new ArrayList<Channel>();
                for (String chName : channelNames) {
                    ChannelComponent channelComponent2 = channelComponentMap.get(chName);
                    if (channelComponent2 == null) continue;
                    sourceChannels.add(channelComponent2.channel);
                }
                if (sourceChannels.isEmpty()) {
                    msg2 = String.format("Source %s is not connected to a channel", sourceName);
                    throw new IllegalStateException(msg2);
                }
                selectorConfig = config.getSelectorConfiguration();
                selector = ChannelSelectorFactory.create(sourceChannels, (ChannelSelectorConfiguration)selectorConfig);
                channelProcessor = new ChannelProcessor(selector);
                Configurables.configure((Object)channelProcessor, (ComponentConfiguration)config);
                source.setChannelProcessor(channelProcessor);
                sourceRunnerMap.put(comp.getComponentName(), SourceRunner.forSource((Source)source));
                for (Channel channel : sourceChannels) {
                    channelComponent = (ChannelComponent)Preconditions.checkNotNull((Object)channelComponentMap.get(channel.getName()), (Object)String.format("Channel %s", channel.getName()));
                    channelComponent.components.add(sourceName);
                }
            }
            catch (Exception e) {
                msg = String.format("Source %s has been removed due to an error during configuration", sourceName);
                LOGGER.error(msg, (Throwable)e);
            }
        }
        Map sourceContexts = agentConf.getSourceContext();
        for (String sourceName : sourceNames) {
            Context context = (Context)sourceContexts.get(sourceName);
            if (context == null) continue;
            source = this.sourceFactory.create(sourceName, context.getString("type"));
            try {
                ChannelSelectorConfiguration channelNames;
                Configurables.configure((Object)source, (Context)context);
                ArrayList<Channel> sourceChannels = new ArrayList<Channel>();
                for (ChannelSelectorConfiguration chName : channelNames = context.getString("channels").split("\\s+")) {
                    ChannelComponent channelComponent3 = channelComponentMap.get(chName);
                    if (channelComponent3 == null) continue;
                    sourceChannels.add(channelComponent3.channel);
                }
                if (sourceChannels.isEmpty()) {
                    msg2 = String.format("Source %s is not connected to a channel", sourceName);
                    throw new IllegalStateException(msg2);
                }
                selectorConfig = context.getSubProperties("selector.");
                selector = ChannelSelectorFactory.create(sourceChannels, (Map)selectorConfig);
                channelProcessor = new ChannelProcessor(selector);
                Configurables.configure((Object)channelProcessor, (Context)context);
                source.setChannelProcessor(channelProcessor);
                sourceRunnerMap.put(sourceName, SourceRunner.forSource((Source)source));
                for (Channel channel : sourceChannels) {
                    channelComponent = (ChannelComponent)Preconditions.checkNotNull((Object)channelComponentMap.get(channel.getName()), (Object)String.format("Channel %s", channel.getName()));
                    channelComponent.components.add(sourceName);
                }
            }
            catch (Exception e) {
                msg = String.format("Source %s has been removed due to an error during configuration", sourceName);
                LOGGER.error(msg, (Throwable)e);
            }
        }
    }

    private void loadSinks(FlumeConfiguration.AgentConfiguration agentConf, Map<String, ChannelComponent> channelComponentMap, Map<String, SinkRunner> sinkRunnerMap) throws InstantiationException {
        String msg;
        ChannelComponent channelComponent;
        Sink sink;
        Set sinkNames = agentConf.getSinkSet();
        Map compMap = agentConf.getSinkConfigMap();
        HashMap<String, Sink> sinks = new HashMap<String, Sink>();
        for (String sinkName : sinkNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(sinkName);
            if (comp == null) continue;
            SinkConfiguration config = (SinkConfiguration)comp;
            sink = this.sinkFactory.create(comp.getComponentName(), comp.getType());
            try {
                Configurables.configure((Object)sink, (ComponentConfiguration)config);
                channelComponent = channelComponentMap.get(config.getChannel());
                if (channelComponent == null) {
                    msg = String.format("Sink %s is not connected to a channel", sinkName);
                    throw new IllegalStateException(msg);
                }
                sink.setChannel(channelComponent.channel);
                sinks.put(comp.getComponentName(), sink);
                channelComponent.components.add(sinkName);
            }
            catch (Exception e) {
                msg = String.format("Sink %s has been removed due to an error during configuration", sinkName);
                LOGGER.error(msg, (Throwable)e);
            }
        }
        Map sinkContexts = agentConf.getSinkContext();
        for (String sinkName : sinkNames) {
            Context context = (Context)sinkContexts.get(sinkName);
            if (context == null) continue;
            sink = this.sinkFactory.create(sinkName, context.getString("type"));
            try {
                Configurables.configure((Object)sink, (Context)context);
                channelComponent = channelComponentMap.get(context.getString("channel"));
                if (channelComponent == null) {
                    msg = String.format("Sink %s is not connected to a channel", sinkName);
                    throw new IllegalStateException(msg);
                }
                sink.setChannel(channelComponent.channel);
                sinks.put(sinkName, sink);
                channelComponent.components.add(sinkName);
            }
            catch (Exception e) {
                msg = String.format("Sink %s has been removed due to an error during configuration", sinkName);
                LOGGER.error(msg, (Throwable)e);
            }
        }
        this.loadSinkGroups(agentConf, sinks, sinkRunnerMap);
    }

    private void loadSinkGroups(FlumeConfiguration.AgentConfiguration agentConf, Map<String, Sink> sinks, Map<String, SinkRunner> sinkRunnerMap) throws InstantiationException {
        Set sinkGroupNames = agentConf.getSinkgroupSet();
        Map compMap = agentConf.getSinkGroupConfigMap();
        HashMap<String, String> usedSinks = new HashMap<String, String>();
        for (String string : sinkGroupNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(string);
            if (comp == null) continue;
            SinkGroupConfiguration groupConf = (SinkGroupConfiguration)comp;
            ArrayList<Sink> groupSinks = new ArrayList<Sink>();
            for (String sink : groupConf.getSinks()) {
                Sink s = sinks.remove(sink);
                if (s == null) {
                    String sinkUser = (String)usedSinks.get(sink);
                    if (sinkUser != null) {
                        throw new InstantiationException(String.format("Sink %s of group %s already in use by group %s", sink, string, sinkUser));
                    }
                    throw new InstantiationException(String.format("Sink %s of group %s does not exist or is not properly configured", sink, string));
                }
                groupSinks.add(s);
                usedSinks.put(sink, string);
            }
            try {
                SinkGroup group = new SinkGroup(groupSinks);
                Configurables.configure((Object)group, (ComponentConfiguration)groupConf);
                sinkRunnerMap.put(comp.getComponentName(), new SinkRunner(group.getProcessor()));
            }
            catch (Exception e) {
                String msg = String.format("SinkGroup %s has been removed due to an error during configuration", string);
                LOGGER.error(msg, (Throwable)e);
            }
        }
        for (Map.Entry entry : sinks.entrySet()) {
            if (usedSinks.containsValue(entry.getKey())) continue;
            try {
                DefaultSinkProcessor pr = new DefaultSinkProcessor();
                ArrayList sinkMap = new ArrayList();
                sinkMap.add(entry.getValue());
                pr.setSinks(sinkMap);
                Configurables.configure((Object)pr, (Context)new Context());
                sinkRunnerMap.put((String)entry.getKey(), new SinkRunner((SinkProcessor)pr));
            }
            catch (Exception e) {
                String msg = String.format("SinkGroup %s has been removed due to an error during configuration", entry.getKey());
                LOGGER.error(msg, (Throwable)e);
            }
        }
    }

    protected Map<String, String> toMap(Properties properties) {
        HashMap result = Maps.newHashMap();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            String value = properties.getProperty(name);
            result.put(name, value);
        }
        return result;
    }

    private static class ChannelComponent {
        final Channel channel;
        final List<String> components;

        ChannelComponent(Channel channel) {
            this.channel = channel;
            this.components = Lists.newArrayList();
        }
    }
}

