/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.solr.morphline;

import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.flume.sink.solr.morphline.MorphlineHandler;
import org.apache.flume.sink.solr.morphline.MorphlineHandlerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphlineSink
extends AbstractSink
implements Configurable {
    private int maxBatchSize = 1000;
    private long maxBatchDurationMillis = 1000L;
    private String handlerClass;
    private MorphlineHandler handler;
    private Context context;
    private SinkCounter sinkCounter;
    public static final String BATCH_SIZE = "batchSize";
    public static final String BATCH_DURATION_MILLIS = "batchDurationMillis";
    public static final String HANDLER_CLASS = "handlerClass";
    private static final Logger LOGGER = LoggerFactory.getLogger(MorphlineSink.class);

    public MorphlineSink() {
        this(null);
    }

    protected MorphlineSink(MorphlineHandler handler) {
        this.handler = handler;
    }

    public void configure(Context context) {
        this.context = context;
        this.maxBatchSize = context.getInteger(BATCH_SIZE, Integer.valueOf(this.maxBatchSize));
        this.maxBatchDurationMillis = context.getLong(BATCH_DURATION_MILLIS, Long.valueOf(this.maxBatchDurationMillis));
        this.handlerClass = context.getString(HANDLER_CLASS, MorphlineHandlerImpl.class.getName());
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
    }

    private int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    private long getMaxBatchDurationMillis() {
        return this.maxBatchDurationMillis;
    }

    public synchronized void start() {
        LOGGER.info("Starting Morphline Sink {} ...", (Object)this);
        this.sinkCounter.start();
        if (this.handler == null) {
            MorphlineHandler tmpHandler;
            try {
                tmpHandler = (MorphlineHandler)Class.forName(this.handlerClass).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException((Throwable)e);
            }
            tmpHandler.configure(this.context);
            this.handler = tmpHandler;
        }
        super.start();
        LOGGER.info("Morphline Sink {} started.", (Object)this.getName());
    }

    public synchronized void stop() {
        LOGGER.info("Morphline Sink {} stopping...", (Object)this.getName());
        try {
            if (this.handler != null) {
                this.handler.stop();
            }
            this.sinkCounter.stop();
            LOGGER.info("Morphline Sink {} stopped. Metrics: {}, {}", (Object)this.getName(), (Object)this.sinkCounter);
        }
        finally {
            super.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() throws EventDeliveryException {
        int batchSize = this.getMaxBatchSize();
        long batchEndTime = System.currentTimeMillis() + this.getMaxBatchDurationMillis();
        Channel myChannel = this.getChannel();
        Transaction txn = myChannel.getTransaction();
        txn.begin();
        boolean isMorphlineTransactionCommitted = true;
        try {
            Event event;
            int numEventsTaken = 0;
            this.handler.beginTransaction();
            isMorphlineTransactionCommitted = false;
            for (int i = 0; i < batchSize && (event = myChannel.take()) != null; ++i) {
                this.sinkCounter.incrementEventDrainAttemptCount();
                ++numEventsTaken;
                if (LOGGER.isTraceEnabled() && LogPrivacyUtil.allowLogRawData()) {
                    LOGGER.trace("Flume event arrived {}", (Object)event);
                }
                this.handler.process(event);
                if (System.currentTimeMillis() >= batchEndTime) break;
            }
            if (numEventsTaken == 0) {
                this.sinkCounter.incrementBatchEmptyCount();
            }
            if (numEventsTaken < batchSize) {
                this.sinkCounter.incrementBatchUnderflowCount();
            } else {
                this.sinkCounter.incrementBatchCompleteCount();
            }
            this.handler.commitTransaction();
            isMorphlineTransactionCommitted = true;
            txn.commit();
            this.sinkCounter.addToEventDrainSuccessCount((long)numEventsTaken);
            Sink.Status i = numEventsTaken == 0 ? Sink.Status.BACKOFF : Sink.Status.READY;
            return i;
        }
        catch (Throwable t) {
            LOGGER.error("Morphline Sink " + this.getName() + ": Unable to process event from channel " + myChannel.getName() + ". Exception follows.", t);
            try {
                if (!isMorphlineTransactionCommitted) {
                    this.handler.rollbackTransaction();
                }
            }
            catch (Throwable t2) {
                LOGGER.error("Morphline Sink " + this.getName() + ": Unable to rollback morphline transaction. Exception follows.", t2);
            }
            finally {
                try {
                    txn.rollback();
                }
                catch (Throwable t4) {
                    LOGGER.error("Morphline Sink " + this.getName() + ": Unable to rollback Flume transaction. Exception follows.", t4);
                }
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof ChannelException) {
                Sink.Status status = Sink.Status.BACKOFF;
                return status;
            }
            throw new EventDeliveryException("Failed to send events", t);
        }
        finally {
            txn.close();
        }
    }

    public String toString() {
        int i = ((Object)((Object)this)).getClass().getName().lastIndexOf(46) + 1;
        String shortClassName = ((Object)((Object)this)).getClass().getName().substring(i);
        return this.getName() + " (" + shortClassName + ")";
    }
}

